/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.olap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.DistinctSelectCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.dto.MappingRelationShipDTO;
import kd.macc.faf.dto.OlapDataExtractingDTO;
import kd.macc.faf.engine.model.FAFOlapDataStatisticsInfo;
import kd.macc.faf.engine.model.FAFOlapDataStatisticsTask;
import kd.macc.faf.engine.task.IDataWorkTaskManager;
import kd.macc.faf.engine.task.status.FAFWorkTaskStatusConsumer;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.helper.FAFSyncDataSchemeHelper;
import kd.macc.faf.model.impl.DataSourceConfigModel;
import kd.macc.faf.model.impl.IDataMapEntry;
import kd.macc.faf.olap.OlapConnectionInformation;
import kd.macc.faf.olap.OlapSQLBuilder;
import kd.macc.faf.olap.driver.OlapRequestParam;
import kd.macc.faf.olap.driver.RequestFactoryBuilder;
import kd.macc.faf.olap.driver.bcm.BcmOlapRequestParam;
import kd.macc.faf.olap.driver.epm.EpmOlapRequestParam;

public class KdOlapServerHelper {
    private static final Log logger = LogFactory.getLog(KdOlapServerHelper.class);

    private KdOlapServerHelper() {
    }

    public static OlapConnection getOlapConnection(String cubeCatelog, OlapFromServiceEnum dataSourceTypeEnum) {
        OlapConnectionInformation connectInfo = RequestFactoryBuilder.getOlapConnectionInformation(dataSourceTypeEnum, olapRequestParam -> {
            if (olapRequestParam instanceof EpmOlapRequestParam) {
                ((EpmOlapRequestParam)olapRequestParam).setDatasetId(Long.parseLong(cubeCatelog));
            } else if (olapRequestParam instanceof BcmOlapRequestParam) {
                ((BcmOlapRequestParam)olapRequestParam).setCubeCatelog(cubeCatelog);
            }
            return olapRequestParam;
        });
        OlapConnection conn = new OlapConnection(connectInfo.getConnectSerial());
        conn.setUserName(connectInfo.getUsername());
        conn.setPassword(connectInfo.getPassword());
        return conn;
    }

    /*
     * Loose catch block
     */
    public static <T> T consumOlapServerConnection(String cubeCatelog, Function<OlapConnection, T> olapConnectionConsumer, OlapFromServiceEnum dataSourceTypeEnum) {
        T t;
        OlapConnection olapConnection;
        block15: {
            block13: {
                T t2;
                block14: {
                    if (olapConnectionConsumer == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u7684OLAP\u6570\u636e\u8fde\u63a5\u5904\u7406\u5668", (String)"KdOlapServerHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
                    }
                    olapConnection = null;
                    olapConnection = KdOlapServerHelper.getOlapConnection(cubeCatelog, dataSourceTypeEnum);
                    if (olapConnection != null) break block13;
                    t2 = null;
                    if (olapConnection == null) break block14;
                    try {
                        olapConnection.Close();
                    }
                    catch (Exception ex) {
                        logger.error(String.format("Close OLAP Server[%1$s] Error: %2$s", cubeCatelog, ex.getMessage()), (Throwable)ex);
                    }
                }
                return t2;
            }
            olapConnection.Open();
            t = olapConnectionConsumer.apply(olapConnection);
            if (olapConnection == null) break block15;
            try {
                olapConnection.Close();
            }
            catch (Exception ex) {
                logger.error(String.format("Close OLAP Server[%1$s] Error: %2$s", cubeCatelog, ex.getMessage()), (Throwable)ex);
            }
        }
        return t;
        catch (Exception ex) {
            try {
                throw new KDBizException((Throwable)ex, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u4f7f\u7528OLAP\u6570\u636e\u8fde\u63a5\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%1$s, CubeCatelog=%2$s", (String)"KdOlapServerHelper_1", (String)"macc-faf-common", (Object[])new Object[0]), ex.getMessage(), cubeCatelog)), new Object[0]);
            }
            catch (Throwable throwable) {
                if (olapConnection != null) {
                    try {
                        olapConnection.Close();
                    }
                    catch (Exception ex2) {
                        logger.error(String.format("Close OLAP Server[%1$s] Error: %2$s", cubeCatelog, ex2.getMessage()), (Throwable)ex2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public static FAFOlapDataStatisticsInfo consumOlapServerConnectionOlapStatistics(String cubeCatelog, Function<OlapConnection, FAFOlapDataStatisticsInfo> olapConnectionConsumer, OlapFromServiceEnum dataSourceTypeEnum) {
        FAFOlapDataStatisticsInfo fAFOlapDataStatisticsInfo;
        OlapConnection olapConnection;
        block15: {
            block13: {
                FAFOlapDataStatisticsInfo fAFOlapDataStatisticsInfo2;
                block14: {
                    if (olapConnectionConsumer == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u7684OLAP\u6570\u636e\u8fde\u63a5\u5904\u7406\u5668", (String)"KdOlapServerHelper_0", (String)"macc-faf-common", (Object[])new Object[0]));
                    }
                    olapConnection = null;
                    olapConnection = KdOlapServerHelper.getOlapConnection(cubeCatelog, dataSourceTypeEnum);
                    if (olapConnection != null) break block13;
                    fAFOlapDataStatisticsInfo2 = null;
                    if (olapConnection == null) break block14;
                    try {
                        olapConnection.Close();
                    }
                    catch (Exception ex) {
                        logger.error(String.format("Close OLAP Server[%s] Error: %s", cubeCatelog, ex.getMessage()), (Throwable)ex);
                    }
                }
                return fAFOlapDataStatisticsInfo2;
            }
            olapConnection.Open();
            fAFOlapDataStatisticsInfo = olapConnectionConsumer.apply(olapConnection);
            if (olapConnection == null) break block15;
            try {
                olapConnection.Close();
            }
            catch (Exception ex) {
                logger.error(String.format("Close OLAP Server[%s] Error: %s", cubeCatelog, ex.getMessage()), (Throwable)ex);
            }
        }
        return fAFOlapDataStatisticsInfo;
        catch (Exception ex) {
            try {
                throw new KDBizException((Throwable)ex, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u4f7f\u7528OLAP\u6570\u636e\u8fde\u63a5\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%1$s, CubeCatelog=%2$s", (String)"KdOlapServerHelper_1", (String)"macc-faf-common", (Object[])new Object[0]), ex.getMessage(), cubeCatelog)), new Object[0]);
            }
            catch (Throwable throwable) {
                if (olapConnection != null) {
                    try {
                        olapConnection.Close();
                    }
                    catch (Exception ex2) {
                        logger.error(String.format("Close OLAP Server[%s] Error: %s", cubeCatelog, ex2.getMessage()), (Throwable)ex2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static long queryDataToReader(OlapSQLBuilder sqlBuilder, MainEntityType outputDynEntity, BiFunction<SelectCommandInfo, OlapDataReader, Long> dataConsumer) {
        if (dataConsumer == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u7684OLAP\u6570\u636e\u5904\u7406\u5668", (String)"KdOlapServerHelper_2", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        if (sqlBuilder == null || !sqlBuilder.validate()) {
            String info = sqlBuilder != null ? sqlBuilder.toString() : null;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684OLAP \u67e5\u8be2\u4fe1\u606f\uff1a%1$s", (String)"KdOlapServerHelper_3", (String)"macc-faf-common", (Object[])new Object[0]), info));
        }
        return KdOlapServerHelper.consumOlapServerConnection(sqlBuilder.getCubeCatalog(), olapConnection -> (Long)KdOlapServerHelper.queryOlapDataToReader(olapConnection, sqlBuilder.buildSelectCommandInfo(), dataConsumer), sqlBuilder.getDataSourceTypeEnum());
    }

    public static <T> T queryOlapDataToReader(OlapConnection olapConnection, SelectCommandInfo queryInfo, BiFunction<SelectCommandInfo, OlapDataReader, T> dataConsumer) {
        try {
            OlapDataReader dataReader = new OlapCommand(olapConnection, (CommandInfo)queryInfo).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
            return dataConsumer.apply(queryInfo, dataReader);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", String.format(ResManager.loadKDString((String)"OLAP \u67e5\u8be2\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%1$s, SelectCommandInfo=%2$s", (String)"KdOlapServerHelper_4", (String)"macc-faf-common", (Object[])new Object[0]), ex.getMessage(), queryInfo)), new Object[0]);
        }
    }

    public static FAFOlapDataStatisticsInfo queryOlapDataToReaderOlapStatistics(OlapConnection olapConnection, SelectCommandInfo queryInfo, BiFunction<SelectCommandInfo, OlapDataReader, FAFOlapDataStatisticsInfo> dataConsumer) {
        try {
            OlapDataReader dataReader = new OlapCommand(olapConnection, (CommandInfo)queryInfo).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
            return dataConsumer.apply(queryInfo, dataReader);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", String.format(ResManager.loadKDString((String)"OLAP \u67e5\u8be2\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%1$s, SelectCommandInfo=%2$s", (String)"KdOlapServerHelper_4", (String)"macc-faf-common", (Object[])new Object[0]), ex.getMessage(), queryInfo)), new Object[0]);
        }
    }

    public static boolean isDimMemberExisted(String cubeCatelog, String dimNumber, OlapFromServiceEnum dataSourceTypeEnum, String ... dimMembers) {
        try {
            DistinctSelectCommandInfo queryInfo = new DistinctSelectCommandInfo();
            queryInfo.addDims(new String[]{dimNumber});
            if (dimMembers != null && dimMembers.length > 0) {
                queryInfo.addFilter(dimNumber, dimMembers);
            }
            KdOlapServerHelper.consumOlapServerConnection(cubeCatelog, olapConnection -> KdOlapServerHelper.queryOlapDataToReader(olapConnection, (SelectCommandInfo)queryInfo, (selectCommandInfo, dataReader) -> {
                dataReader.next();
                return 0L;
            }), dataSourceTypeEnum);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static FAFOlapDataStatisticsInfo queryDimMemComboStatistics(String cubeCatelog, String mainDimNumber, String splitDimNumber, Map<String, Set<String>> queryDimFilters, boolean ignoreMeasureNull, OlapFromServiceEnum dataSourceTypeEnum) {
        FAFOlapDataStatisticsTask statisticsTask;
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(new String[]{mainDimNumber});
        queryInfo.addMeasures(new String[]{"FMONEY"});
        IDataMapEntry<String, Integer> mainDim = new IDataMapEntry<String, Integer>(mainDimNumber, 1);
        if (splitDimNumber != null) {
            queryInfo.addDims(new String[]{splitDimNumber});
            IDataMapEntry<String, Integer> splitDim = new IDataMapEntry<String, Integer>(splitDimNumber, 2);
            statisticsTask = new FAFOlapDataStatisticsTask(ignoreMeasureNull, new IDataMapEntry[]{mainDim, splitDim});
        } else {
            statisticsTask = new FAFOlapDataStatisticsTask(ignoreMeasureNull, new IDataMapEntry[]{mainDim});
        }
        for (Map.Entry<String, Set<String>> filterEntry : queryDimFilters.entrySet()) {
            queryInfo.addFilter(filterEntry.getKey(), filterEntry.getValue().toArray(new String[0]));
        }
        return KdOlapServerHelper.consumOlapServerConnectionOlapStatistics(cubeCatelog, olapConnection -> KdOlapServerHelper.queryOlapDataToReaderOlapStatistics(olapConnection, queryInfo, (selectCommandInfo, dataReader) -> statisticsTask.processOlapQueryReader((SelectCommandInfo)selectCommandInfo, (OlapDataReader)dataReader)), dataSourceTypeEnum);
    }

    public static Set<String> queryDimMember(String cubeCatelog, String dimNumber, Map<String, Set<String>> queryDimFilters, OlapFromServiceEnum dataSourceTypeEnum) {
        DistinctSelectCommandInfo queryInfo = new DistinctSelectCommandInfo();
        queryInfo.addDims(new String[]{dimNumber});
        if (queryDimFilters != null) {
            for (Map.Entry<String, Set<String>> filterEntry : queryDimFilters.entrySet()) {
                queryInfo.addFilter(filterEntry.getKey(), filterEntry.getValue().toArray(new String[0]));
            }
        }
        return KdOlapServerHelper.consumOlapServerConnection(cubeCatelog, olapConnection -> KdOlapServerHelper.queryOlapDataToReader(olapConnection, (SelectCommandInfo)queryInfo, (selectCommandInfo, dataReader) -> {
            HashSet<String> dimMembers = new HashSet<String>(50);
            Object[] rowBuffer = new Object[1];
            while (dataReader.next()) {
                dataReader.getValues(rowBuffer);
                dimMembers.add(rowBuffer[0].toString());
            }
            return dimMembers;
        }), dataSourceTypeEnum);
    }

    public static Set<String> getValidDimMemberSet(String cubeCatelog, String dimNumber, String[] memeberValBuf, OlapFromServiceEnum dataSourceTypeEnum, Map<String, Set<String>> queryDimFilters) {
        if (memeberValBuf == null) {
            return KdOlapServerHelper.queryDimMember(cubeCatelog, dimNumber, null, dataSourceTypeEnum);
        }
        HashSet<String> dimMemberSet = new HashSet<String>(Arrays.asList(memeberValBuf));
        if (!KdOlapServerHelper.isDimMemberExisted(cubeCatelog, dimNumber, dataSourceTypeEnum, memeberValBuf)) {
            Set<String> olapDimMembers = KdOlapServerHelper.queryDimMember(cubeCatelog, dimNumber, null, dataSourceTypeEnum);
            dimMemberSet.retainAll(olapDimMembers);
        }
        return dimMemberSet;
    }

    public static Map<String, Set<String>> validateDimMemTasks(Map<String, Set<String>> dimensionFilters, Long taskId, String cubeNumber, OlapFromServiceEnum dataSourceTypeEnum) {
        FAFWorkTaskStatusConsumer statusConsumer = FAFWorkTaskStatusConsumer.getInstance();
        LinkedList<Future<Object>> validateDimMemTasks = new LinkedList<Future<Object>>();
        AtomicInteger validateDimMemTaskCnt = new AtomicInteger(0);
        for (Map.Entry<String, Set<String>> dimMemberEntry : dimensionFilters.entrySet()) {
            String verifyDimNumber = dimMemberEntry.getKey();
            validateDimMemTasks.add(IDataWorkTaskManager.getInstance().submit(() -> {
                int taskCnt = validateDimMemTaskCnt.incrementAndGet();
                statusConsumer.updateCachedWorkTaskStatusEvent(taskId, String.format(ResManager.loadKDString((String)"\u542f\u52a8\u6210\u5458\u7684\u6709\u6548\u6027\u6821\u9a8c\u4e2d: [\u9a8c\u8bc1\u4efb\u52a1\u6570:%1$s: \u5df2\u5b8c\u6210\u9a8c\u8bc1\u6570:%2$s]", (String)"KdOlapServerHelper_5", (String)"macc-faf-common", (Object[])new Object[0]), taskCnt, 0));
                Set<String> validDimMemberSet = KdOlapServerHelper.getValidDimMemberSet(cubeNumber, verifyDimNumber, ((Set)dimMemberEntry.getValue()).toArray(new String[0]), dataSourceTypeEnum, null);
                HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(1);
                resultMap.put(verifyDimNumber, validDimMemberSet);
                return resultMap;
            }, true));
        }
        HashMap<String, Set<String>> qualifyDimFilterMap = new HashMap<String, Set<String>>(dimensionFilters.size());
        int i = 0;
        StringBuilder invalidDimensions = new StringBuilder();
        for (Future future : validateDimMemTasks) {
            try {
                Map dimFilters = (Map)future.get();
                Map.Entry dimFilterEntry = dimFilters.entrySet().iterator().next();
                if (((Set)dimFilterEntry.getValue()).isEmpty()) {
                    invalidDimensions.append((String)dimFilterEntry.getKey()).append(", ");
                    continue;
                }
                qualifyDimFilterMap.putAll(dimFilters);
                statusConsumer.updateCachedWorkTaskStatusEvent(taskId, String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u6210\u5458\u7684\u6709\u6548\u6027\u6821\u9a8c\u5b8c\u6210: [\u9a8c\u8bc1\u4efb\u52a1\u6570:%1$s: \u5df2\u5b8c\u6210\u9a8c\u8bc1\u6570:%2$s]", (String)"KdOlapServerHelper_6", (String)"macc-faf-common", (Object[])new Object[0]), validateDimMemTaskCnt.get(), ++i));
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        statusConsumer.updateCachedWorkTaskStatusEvent(taskId, ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u3002", (String)"KdOlapServerHelper_7", (String)"macc-faf-common", (Object[])new Object[0]));
        if (!invalidDimensions.toString().isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u7ef4\u5ea6\u6240\u9009\u62e9\u7684\u6210\u5458\u5747\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"KdOlapServerHelper_8", (String)"macc-faf-common", (Object[])new Object[0]), invalidDimensions.substring(0, invalidDimensions.length() - 2)));
        }
        return qualifyDimFilterMap;
    }

    public static Map<String, Set<String>> acquireUsedDimMemTasks(Set<String> dimNumbers, Map<String, Set<String>> dimensionFilters, String cubeNumber, OlapFromServiceEnum dataSourceTypeEnum) {
        LinkedList<Future<Object>> usedDimMemTasks = new LinkedList<Future<Object>>();
        HashMap<String, Set<String>> usedDimMemberMap = new HashMap<String, Set<String>>(dimNumbers.size());
        for (String string : dimNumbers) {
            usedDimMemTasks.add(IDataWorkTaskManager.getInstance().submit(() -> {
                Set<String> usedDimMemberSet = KdOlapServerHelper.getValidDimMemberSet(cubeNumber, dimNumber, null, dataSourceTypeEnum, dimensionFilters);
                HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(1);
                resultMap.put(dimNumber, usedDimMemberSet);
                return resultMap;
            }, true));
        }
        for (Future future : usedDimMemTasks) {
            try {
                Map dimFilters = (Map)future.get();
                usedDimMemberMap.putAll(dimFilters);
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        return usedDimMemberMap;
    }

    public static boolean checkExtractingOlapData(OlapDataExtractingDTO extractingDTO, DataExtractingDTO dto) {
        boolean existOrg = false;
        boolean existPeriod = false;
        List<MappingRelationShipDTO> mappingRelationShipDTOs = extractingDTO.getMappingRelationShipDTOs();
        for (MappingRelationShipDTO mappingRelationShipDTO : mappingRelationShipDTOs) {
            if (mappingRelationShipDTO == null) continue;
            if (dto.getOrgDimNumber().equals(mappingRelationShipDTO.getTargetDimensionNumber())) {
                Collection<Object> orgIds = mappingRelationShipDTO.getDimMembersIdMapping().values();
                for (Object orgId : orgIds) {
                    if ((!(orgId instanceof Long) || !dto.getOrgIdSet().contains(orgId)) && (!(orgId instanceof Integer) || !dto.getOrgIdSet().contains(Long.parseLong(orgId.toString())))) continue;
                    existOrg = true;
                }
                continue;
            }
            if (!dto.getPeriodDimNumber().equals(mappingRelationShipDTO.getTargetDimensionNumber())) continue;
            Collection<Object> periodIds = mappingRelationShipDTO.getDimMembersIdMapping().values();
            for (Object periodId : periodIds) {
                if ((!(periodId instanceof Long) || !dto.getPeriodIdSet().contains(periodId)) && (!(periodId instanceof Integer) || !dto.getPeriodIdSet().contains(Long.parseLong(periodId.toString())))) continue;
                existPeriod = true;
            }
        }
        return existOrg && existPeriod;
    }

    public static String checkValidateOlapQuery(DataExtractingDTO dataExtDTO, DynamicObjectCollection dataSchemeDynColl) {
        StringBuilder tips = new StringBuilder();
        for (DynamicObject schemeObj : dataSchemeDynColl) {
            OlapDataExtractingDTO extractingDTO;
            DataSourceTypeEnum entityType = DataSourceTypeEnum.getEnum(schemeObj.getString("datasource.datasource_type"));
            if (DataSourceTypeEnum.EPM != entityType && DataSourceTypeEnum.BCM != entityType || (extractingDTO = FAFSyncDataSchemeHelper.buildOlapDataExtractingDTO(schemeObj.getLong("id"), dataExtDTO.getOrgIdSet(), dataExtDTO.getPeriodIdSet())) == null) continue;
            extractingDTO.buildExtractingValues();
            String unRelationParamTips = KdOlapServerHelper.checkUnRelationParamTips(extractingDTO, dataExtDTO);
            if (!StringUtils.isNotEmpty((String)unRelationParamTips)) continue;
            tips.append(unRelationParamTips);
        }
        return tips.length() == 0 ? null : tips.toString();
    }

    public static String checkUnRelationParamTips(OlapDataExtractingDTO extractingDTO, DataExtractingDTO dto) {
        StringBuilder orgTips = new StringBuilder();
        StringBuilder periodTips = new StringBuilder();
        List<MappingRelationShipDTO> relationShipDTOS = extractingDTO.getMappingRelationShipDTOs();
        for (MappingRelationShipDTO relationShipDTO : relationShipDTOS) {
            if (relationShipDTO == null) continue;
            String targetDimensionNumber = relationShipDTO.getTargetDimensionNumber();
            if (targetDimensionNumber.equals(dto.getOrgDimNumber())) {
                Collection<Object> relationOrgSet = relationShipDTO.getDimMembersIdMapping().values();
                HashSet<Long> orgIdSet = new HashSet<Long>(dto.getOrgIdSet());
                HashSet relationOrgLongIdSet = new HashSet(orgIdSet.size());
                for (Object orgId : relationOrgSet) {
                    if (orgId instanceof Integer) {
                        relationOrgLongIdSet.add(Long.parseLong(orgId.toString()));
                        continue;
                    }
                    if (!(orgId instanceof Long)) continue;
                    relationOrgLongIdSet.add((Long)orgId);
                }
                orgIdSet.removeAll(relationOrgLongIdSet);
                if (orgIdSet.isEmpty()) continue;
                Map map = BusinessDataServiceHelper.loadFromCache((Object[])orgIdSet.toArray(), (String)"bos_org");
                orgTips.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a", (String)"KdOlapServerHelper_9", (String)"macc-faf-common", (Object[])new Object[0]));
                int i = 0;
                for (DynamicObject value : map.values()) {
                    if (i == map.size() - 1) {
                        orgTips.append(value.getString("name")).append("\u3002");
                    } else {
                        orgTips.append(value.getString("name")).append("\u3001");
                    }
                    ++i;
                }
                orgTips.append("\n\r");
                continue;
            }
            if (!targetDimensionNumber.equals(dto.getPeriodDimNumber())) continue;
            Collection<Object> relationPeriodSet = relationShipDTO.getDimMembersIdMapping().values();
            HashSet<Long> relationPeriodLongIdSet = new HashSet<Long>(relationPeriodSet.size());
            for (Object e : relationPeriodSet) {
                if (e instanceof Integer) {
                    relationPeriodLongIdSet.add(Long.parseLong(e.toString()));
                    continue;
                }
                if (!(e instanceof Long)) continue;
                relationPeriodLongIdSet.add((Long)e);
            }
            HashSet<Long> periodIdSet = new HashSet<Long>(dto.getPeriodIdSet());
            periodIdSet.removeAll(relationPeriodLongIdSet);
            if (periodIdSet.isEmpty()) continue;
            periodTips.append(ResManager.loadKDString((String)"\u671f\u95f4\uff1a", (String)"KdOlapServerHelper_10", (String)"macc-faf-common", (Object[])new Object[0]));
            Map map = BusinessDataServiceHelper.loadFromCache((Object[])periodIdSet.toArray(), (String)dto.getPeriodBaseData());
            int i = 0;
            for (DynamicObject value : map.values()) {
                if (i == map.size() - 1) {
                    periodTips.append(value.getString("name")).append("\u3002");
                } else {
                    periodTips.append(value.getString("name")).append("\u3001");
                }
                ++i;
            }
            periodTips.append("\n\r");
        }
        return orgTips.append((CharSequence)periodTips).toString();
    }

    public static String validateSyncSchemaInTypeOfEpmOrBcm(Long analysisModelId) {
        EpmOlapRequestParam epmOlapRequestParam;
        Collection<DynamicObject> syncSchemasInTypeOfEpmOrBcm = KdOlapServerHelper.getSyncSchemasInTypeOfEpmOrBcm(analysisModelId);
        if (CollectionUtils.isEmpty(syncSchemasInTypeOfEpmOrBcm)) {
            return "";
        }
        Object[] dataSourceIds = syncSchemasInTypeOfEpmOrBcm.stream().map(syncSchema -> syncSchema.getLong("datasource_id")).distinct().toArray();
        Map dataSourceIdMap = BusinessDataServiceHelper.loadFromCache((Object[])dataSourceIds, (String)"pa_datasourceconfig");
        ArrayList<EpmOlapRequestParam> epmOlapRequestParams = new ArrayList<EpmOlapRequestParam>(2);
        ArrayList<BcmOlapRequestParam> bcmOlapRequestParams = new ArrayList<BcmOlapRequestParam>(2);
        block4: for (DynamicObject syncSchema2 : syncSchemasInTypeOfEpmOrBcm) {
            DynamicObject datasource = (DynamicObject)dataSourceIdMap.get(syncSchema2.getLong("datasource_id"));
            DataSourceConfigModel dataSourceConfigModel = new DataSourceConfigModel();
            dataSourceConfigModel.loadFromDynamicObject(datasource);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("dataSourceNameNumber", String.format("%1$s[%2$s]", datasource.getString("name"), datasource.getString("number")));
            DataSourceTypeEnum dataSourceTypeEnum = dataSourceConfigModel.getDataSourceTypeEnum();
            switch (dataSourceTypeEnum) {
                case EPM: {
                    epmOlapRequestParam = (EpmOlapRequestParam)dataSourceConfigModel.getOlapRequestParam();
                    epmOlapRequestParam.setCustomParam(params);
                    epmOlapRequestParams.add(epmOlapRequestParam);
                    continue block4;
                }
                case BCM: {
                    BcmOlapRequestParam bcmOlapRequestParam = (BcmOlapRequestParam)dataSourceConfigModel.getOlapRequestParam();
                    bcmOlapRequestParam.setCustomParam(params);
                    bcmOlapRequestParams.add(bcmOlapRequestParam);
                    continue block4;
                }
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\u3002", (String)"KdOlapServerHelper_11", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        List existEpmModuleIds = QueryServiceHelper.queryPrimaryKeys((String)"epm_model", (QFilter[])new QFilter("id", "in", epmOlapRequestParams.stream().map(OlapRequestParam::getModuleId).collect(Collectors.toSet())).toArray(), null, (int)-1);
        List existEpmModelIds = QueryServiceHelper.queryPrimaryKeys((String)"eb_businessmodel", (QFilter[])new QFilter("id", "in", epmOlapRequestParams.stream().map(EpmOlapRequestParam::getModelId).collect(Collectors.toSet())).toArray(), null, (int)-1);
        List existEpmDataSetIds = QueryServiceHelper.queryPrimaryKeys((String)"eb_dataset", (QFilter[])new QFilter("id", "in", epmOlapRequestParams.stream().map(EpmOlapRequestParam::getDatasetId).collect(Collectors.toSet())).toArray(), null, (int)-1);
        Optional<EpmOlapRequestParam> anyEpmSystem = epmOlapRequestParams.stream().filter(param -> !existEpmModuleIds.contains(param.getModuleId())).findAny();
        if (anyEpmSystem.isPresent()) {
            EpmOlapRequestParam epmOlapRequestParam2 = anyEpmSystem.get();
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90%s\u53c2\u6570\u6240\u9009\u9884\u7b97\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u88ab\u5220\u9664", (String)"KdOlapServerHelper_12", (String)"macc-faf-common", (Object[])new Object[0]), epmOlapRequestParam2.getCustomParam().get("dataSourceNameNumber"));
        }
        Optional<EpmOlapRequestParam> anyEpmModel = epmOlapRequestParams.stream().filter(param -> !existEpmModelIds.contains(param.getModelId())).findAny();
        if (anyEpmModel.isPresent()) {
            EpmOlapRequestParam epmOlapRequestParam3 = anyEpmModel.get();
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90%s\u53c2\u6570\u6240\u9009\u4e1a\u52a1\u6a21\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u88ab\u5220\u9664", (String)"KdOlapServerHelper_13", (String)"macc-faf-common", (Object[])new Object[0]), epmOlapRequestParam3.getCustomParam().get("dataSourceNameNumber"));
        }
        Optional<EpmOlapRequestParam> anyEpmDataSet = epmOlapRequestParams.stream().filter(param -> !existEpmDataSetIds.contains(param.getDatasetId())).findAny();
        if (anyEpmDataSet.isPresent()) {
            epmOlapRequestParam = anyEpmDataSet.get();
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90%s\u53c2\u6570\u6240\u9009\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u88ab\u5220\u9664", (String)"KdOlapServerHelper_14", (String)"macc-faf-common", (Object[])new Object[0]), epmOlapRequestParam.getCustomParam().get("dataSourceNameNumber"));
        }
        List existBcmModuleIds = QueryServiceHelper.queryPrimaryKeys((String)"bcm_model", (QFilter[])new QFilter("id", "in", bcmOlapRequestParams.stream().map(OlapRequestParam::getModuleId).collect(Collectors.toSet())).toArray(), null, (int)-1);
        List existBcmOrgViewIds = QueryServiceHelper.queryPrimaryKeys((String)"bcm_cslscheme", (QFilter[])new QFilter("id", "in", bcmOlapRequestParams.stream().map(BcmOlapRequestParam::getOrgViewId).collect(Collectors.toSet())).toArray(), null, (int)-1);
        Optional<BcmOlapRequestParam> anyBcmSystem = bcmOlapRequestParams.stream().filter(param -> !existBcmModuleIds.contains(param.getModuleId())).findAny();
        if (anyBcmSystem.isPresent()) {
            BcmOlapRequestParam bcmOlapRequestParam = anyBcmSystem.get();
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90%s\u53c2\u6570\u6240\u9009\u5408\u5e76\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u88ab\u5220\u9664", (String)"KdOlapServerHelper_15", (String)"macc-faf-common", (Object[])new Object[0]), bcmOlapRequestParam.getCustomParam().get("dataSourceNameNumber"));
        }
        return "";
    }

    public static Collection<DynamicObject> getSyncSchemasInTypeOfEpmOrBcm(Long analysisModelId) {
        QFilter modelFilter = new QFilter("analysismodel", "=", (Object)analysisModelId);
        QFilter sourceTypeFilter = new QFilter("datasource.datasource_type", "in", (Object)new String[]{DataSourceTypeEnum.BCM.getCode(), DataSourceTypeEnum.EPM.getCode()});
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadFromCache((String)"pa_syncdataschema", (String)"id,name,datasource", (QFilter[])new QFilter[]{modelFilter, enableFilter, sourceTypeFilter}).values();
    }
}

