/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.olap;

import java.io.Serializable;
import java.util.Map;
import kd.bos.encrypt.EncrypterFactory;
import kd.macc.faf.enums.OlapFromServiceEnum;

public class OlapConnectionInformation
implements Serializable {
    private static final long serialVersionUID = 16201323292368509L;
    private String address;
    private String username;
    private String password;
    private String connectSerial;

    public OlapConnectionInformation() {
    }

    public OlapConnectionInformation(Map<String, String> srcMap, OlapFromServiceEnum dataSourceTypeEnum) {
        if (OlapFromServiceEnum.BCM == dataSourceTypeEnum) {
            this.initFromMap(srcMap);
        } else if (OlapFromServiceEnum.EPM == dataSourceTypeEnum) {
            this.initFromEpmMap(srcMap);
        }
    }

    public final void initFromMap(Map<String, String> srcMap) {
        this.address = srcMap.get("address");
        this.username = srcMap.get("username");
        this.password = srcMap.get("password");
        if (this.password != null && this.password.startsWith("OlapPwd_")) {
            String subPwd = this.password.substring(8);
            this.password = EncrypterFactory.getAesEncrypter().decrypt(subPwd);
        }
        this.connectSerial = srcMap.get("connectSerial");
    }

    public final void initFromEpmMap(Map<String, String> srcMap) {
        this.username = EncrypterFactory.getAesEncrypter().decrypt(srcMap.get("username"));
        this.password = EncrypterFactory.getAesEncrypter().decrypt(srcMap.get("password"));
        this.connectSerial = EncrypterFactory.getAesEncrypter().decrypt(srcMap.get("connectSerial"));
    }

    public String toString() {
        return "OlapConnectionInformation [address=" + this.address + ", username=" + this.username + ", password=" + this.password + ", connectSerial=" + this.connectSerial + "]";
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConnectSerial() {
        return this.connectSerial;
    }

    public void setConnectSerial(String connectSerial) {
        this.connectSerial = connectSerial;
    }
}

