/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.olap.driver;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.olap.OlapConnectionInformation;
import kd.macc.faf.olap.OlapServerDimMemberMetaInfo;
import kd.macc.faf.olap.OlapServerDimemsionMetaInfo;
import kd.macc.faf.olap.driver.OlapRequest;
import kd.macc.faf.olap.driver.OlapRequestParam;
import kd.macc.faf.olap.driver.RequestAbstractFactory;
import kd.macc.faf.olap.driver.bcm.BcmRequestFactory;
import kd.macc.faf.olap.driver.epm.EpmRequestFactory;

public class RequestFactoryBuilder {
    private static RequestAbstractFactory<?> createFactory(OlapFromServiceEnum olapFromServiceEnum) {
        if (OlapFromServiceEnum.EPM == olapFromServiceEnum) {
            return new EpmRequestFactory();
        }
        if (OlapFromServiceEnum.BCM == olapFromServiceEnum) {
            return new BcmRequestFactory();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u63a5\u53e3\u8bf7\u6c42", (String)"RequestFactoryBuilder_0", (String)"macc-faf-common", (Object[])new Object[0]));
    }

    private static Tuple2<OlapRequest, OlapRequestParam> getTuple2(OlapFromServiceEnum olapFromServiceEnum, Function<OlapRequestParam, OlapRequestParam> function) {
        RequestAbstractFactory<?> factory = RequestFactoryBuilder.createFactory(olapFromServiceEnum);
        Object request = factory.createRequest();
        OlapRequestParam olapRequestParam = factory.createOlapRequestParam();
        olapRequestParam = function.apply(olapRequestParam);
        return new Tuple2(request, (Object)olapRequestParam);
    }

    public static Map<String, OlapServerDimemsionMetaInfo> getAllDim(OlapFromServiceEnum olapFromServiceEnum, Function<OlapRequestParam, OlapRequestParam> function) {
        Tuple2<OlapRequest, OlapRequestParam> tuple2 = RequestFactoryBuilder.getTuple2(olapFromServiceEnum, function);
        return ((OlapRequest)tuple2.t1).loadModuleAllDimensionMetas((OlapRequestParam)tuple2.t2);
    }

    public static OlapServerDimemsionMetaInfo getDimensioin(OlapFromServiceEnum olapFromServiceEnum, Function<OlapRequestParam, OlapRequestParam> function) {
        Tuple2<OlapRequest, OlapRequestParam> tuple2 = RequestFactoryBuilder.getTuple2(olapFromServiceEnum, function);
        return ((OlapRequest)tuple2.t1).loadDimension((OlapRequestParam)tuple2.t2);
    }

    public static Map<String, OlapServerDimMemberMetaInfo> getAllMemberOfDim(OlapFromServiceEnum olapFromServiceEnum, Function<OlapRequestParam, OlapRequestParam> function) {
        Tuple2<OlapRequest, OlapRequestParam> tuple2 = RequestFactoryBuilder.getTuple2(olapFromServiceEnum, function);
        return ((OlapRequest)tuple2.t1).loadDimensionMembers((OlapRequestParam)tuple2.t2);
    }

    public static Set<String> changeIdToNumber(OlapFromServiceEnum olapFromServiceEnum, Function<OlapRequestParam, OlapRequestParam> function, Set<Long> ids) {
        Tuple2<OlapRequest, OlapRequestParam> tuple2 = RequestFactoryBuilder.getTuple2(olapFromServiceEnum, function);
        return ((OlapRequest)tuple2.t1).changeIdToNumber((OlapRequestParam)tuple2.t2, ids);
    }

    public static OlapConnectionInformation getOlapConnectionInformation(OlapFromServiceEnum olapFromServiceEnum, Function<OlapRequestParam, OlapRequestParam> function) {
        Tuple2<OlapRequest, OlapRequestParam> tuple2 = RequestFactoryBuilder.getTuple2(olapFromServiceEnum, function);
        return ((OlapRequest)tuple2.t1).getOlapConnectionInformation((OlapRequestParam)tuple2.t2);
    }
}

