/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.olap.driver.bcm;

import java.util.Map;
import java.util.Set;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.olap.OlapConnectionInformation;
import kd.macc.faf.olap.OlapServerDimMemberMetaInfo;
import kd.macc.faf.olap.OlapServerDimemsionMetaInfo;
import kd.macc.faf.olap.driver.OlapDeserialize;
import kd.macc.faf.olap.driver.OlapRequest;
import kd.macc.faf.olap.driver.bcm.BcmOlapRequestParam;
import kd.macc.faf.util.IDataMServiceUtil;
import org.jetbrains.annotations.NotNull;

public class BcmOlapRequest
implements OlapRequest<BcmOlapRequestParam> {
    private static final Log logger = LogFactory.getLog(BcmOlapRequest.class);

    @Override
    public Map<String, OlapServerDimemsionMetaInfo> loadModuleAllDimensionMetas(@NotNull BcmOlapRequestParam bcmOlapRequestParam) {
        IDataMServiceUtil.throwException(bcmOlapRequestParam.getModuleId() == null);
        try {
            return OlapDeserialize.deserializeOlapServerDimemsionMetaInfoMap((Map)BcmOlapRequest.invokeBCMBizServiceEx(null, "loadModuleAllDimensionMetas", bcmOlapRequestParam.getModuleId()), OlapServerDimemsionMetaInfo.class);
        }
        catch (Exception e) {
            logger.error(String.format("[bcm] Call loadModuleAllDimensionMetas error,param: moduleId=%s", bcmOlapRequestParam.getModuleId()));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    @Override
    public OlapServerDimemsionMetaInfo loadDimension(@NotNull BcmOlapRequestParam bcmOlapRequestParam) {
        IDataMServiceUtil.throwException(bcmOlapRequestParam.getModuleId() == null || bcmOlapRequestParam.getDimNumber() == null);
        return BcmOlapRequest.invokeBCMBizServiceEx(OlapServerDimemsionMetaInfo.class, "loadModuleDimensionMeta", bcmOlapRequestParam.getModuleId(), bcmOlapRequestParam.getDimNumber());
    }

    @Override
    public Map<String, OlapServerDimMemberMetaInfo> loadDimensionMembers(@NotNull BcmOlapRequestParam bcmOlapRequestParam) {
        IDataMServiceUtil.throwException(bcmOlapRequestParam.getModuleId() == null || bcmOlapRequestParam.getDimNumber() == null || bcmOlapRequestParam.getDimId() == null);
        try {
            return OlapDeserialize.deserializeOlapServerDimemsionMetaInfoMap((Map)BcmOlapRequest.invokeBCMBizServiceEx(null, "loadDimensionMembers", bcmOlapRequestParam.getModuleId(), bcmOlapRequestParam.getOrgViewId(), bcmOlapRequestParam.getDimensionEntityName(), bcmOlapRequestParam.getDimId(), null, null, false, null), OlapServerDimMemberMetaInfo.class);
        }
        catch (Exception e) {
            logger.error(String.format("[FAF] call loadDimensionMembers error, params: moduleId=%s,viewId=%s,entity=%s,dimId=%s", bcmOlapRequestParam.getModuleId(), bcmOlapRequestParam.getOrgViewId(), bcmOlapRequestParam.getDimensionEntityName(), bcmOlapRequestParam.getDimId()));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    @Override
    public Set<String> changeIdToNumber(BcmOlapRequestParam bcmOlapRequestParam, Set<Long> ids) {
        IDataMServiceUtil.throwException(bcmOlapRequestParam.getDimensionEntityName() == null || bcmOlapRequestParam.getDimId() == null || ids == null);
        try {
            Map map = (Map)BcmOlapRequest.invokeBCMBizServiceEx(null, "loadDimensionMemberNumberId", bcmOlapRequestParam.getDimensionEntityName(), bcmOlapRequestParam.getDimId(), ids, false);
            return map.keySet();
        }
        catch (Exception e) {
            logger.error(String.format("[FAF] call loadDimensionMembers error, params: moduleId=%s,viewId=%s,entity=%s,dimId=%s", bcmOlapRequestParam.getModuleId(), bcmOlapRequestParam.getOrgViewId(), bcmOlapRequestParam.getDimensionEntityName(), bcmOlapRequestParam.getDimId()));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    @Override
    public OlapConnectionInformation getOlapConnectionInformation(@NotNull BcmOlapRequestParam bcmOlapRequestParam) {
        IDataMServiceUtil.throwException(bcmOlapRequestParam.getCubeCatelog() == null);
        return new OlapConnectionInformation((Map)BcmOlapRequest.invokeBCMBizServiceEx(null, "getOlapConnectionInformation", bcmOlapRequestParam.getCubeCatelog(), null), OlapFromServiceEnum.BCM);
    }

    public String getModelNumber(Long moduleId) {
        try {
            return (String)BcmOlapRequest.invokeBCMBizServiceEx(null, "getModelNumber", moduleId);
        }
        catch (Exception e) {
            logger.error(String.format("[FAF] call getModelNumber error, params: moduleId=%s", moduleId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public static <T> T invokeBCMBizServiceEx(Class<T> jsonObjectClassType, String methodName, Object ... params) {
        try {
            return IDataMServiceUtil.invokeBizService(jsonObjectClassType, "fi", "bcm", "BCMToFSAMsService", methodName, params);
        }
        catch (Exception e) {
            throw new KDBizException(e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
    }
}

