/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.olap.driver.epm;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.olap.OlapConnectionInformation;
import kd.macc.faf.olap.OlapServerBaseMetaInfo;
import kd.macc.faf.olap.OlapServerDimMemberMetaInfo;
import kd.macc.faf.olap.OlapServerDimemsionMetaInfo;
import kd.macc.faf.olap.driver.OlapDeserialize;
import kd.macc.faf.olap.driver.OlapRequest;
import kd.macc.faf.olap.driver.epm.EpmOlapRequestParam;
import kd.macc.faf.util.IDataMServiceUtil;

public class EpmOlapRequest
implements OlapRequest<EpmOlapRequestParam> {
    private static final Log logger = LogFactory.getLog(EpmOlapRequest.class);

    @Override
    public Map<String, OlapServerDimemsionMetaInfo> loadModuleAllDimensionMetas(EpmOlapRequestParam epmOlapRequestParam) {
        IDataMServiceUtil.throwException(epmOlapRequestParam.getModuleId() == null);
        if (epmOlapRequestParam.getDatasetId() == null) {
            epmOlapRequestParam.setDatasetId(0L);
        }
        try {
            return OlapDeserialize.deserializeOlapServerDimemsionMetaInfoMap((Map)EpmOlapRequest.invokeEpmBizServiceEx(null, "loadModuleAllDimensionMetas", epmOlapRequestParam.getModuleId(), epmOlapRequestParam.getDatasetId()), OlapServerDimemsionMetaInfo.class);
        }
        catch (Exception e) {
            logger.error(String.format("[epm] Call loadModuleAllDimensionMetas error,param: moduleId=%s", epmOlapRequestParam.getModuleId()));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    @Override
    public OlapServerDimemsionMetaInfo loadDimension(EpmOlapRequestParam epmOlapRequestParam) {
        IDataMServiceUtil.throwException(epmOlapRequestParam.getModuleId() == null || epmOlapRequestParam.getDimNumber() == null);
        try {
            return EpmOlapRequest.invokeEpmBizServiceEx(OlapServerDimemsionMetaInfo.class, "loadModuleDimensionMeta", epmOlapRequestParam.getModuleId(), epmOlapRequestParam.getDimNumber());
        }
        catch (Exception e) {
            logger.error(String.format("[epm] Call loadModuleAllDimensionMetas error,param: moduleId=%s,dimNumber=%s", epmOlapRequestParam.getModuleId(), epmOlapRequestParam.getDimNumber()));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    @Override
    public Map<String, OlapServerDimMemberMetaInfo> loadDimensionMembers(EpmOlapRequestParam epmOlapRequestParam) {
        IDataMServiceUtil.throwException(epmOlapRequestParam.getModuleId() == null || epmOlapRequestParam.getDimensionEntityName() == null || epmOlapRequestParam.getDimId() == null);
        if (epmOlapRequestParam.getDatasetId() == null) {
            epmOlapRequestParam.setDatasetId(0L);
        }
        try {
            return OlapDeserialize.deserializeOlapServerDimemsionMetaInfoMap((Map)EpmOlapRequest.invokeEpmBizServiceEx(null, "loadDimensionMembers", epmOlapRequestParam.getModuleId(), epmOlapRequestParam.getDimensionEntityName(), epmOlapRequestParam.getDimId(), epmOlapRequestParam.getDatasetId()), OlapServerDimMemberMetaInfo.class);
        }
        catch (Exception e) {
            logger.error(String.format("[epm] Call loadModuleAllDimensionMetas error,param: moduleId=%s,dimensionEntityName=%s,datasetId=%s", epmOlapRequestParam.getModuleId(), epmOlapRequestParam.getDimensionEntityName(), epmOlapRequestParam.getDatasetId()));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    @Override
    public Set<String> changeIdToNumber(EpmOlapRequestParam epmOlapRequestParam, Set<Long> ids) {
        IDataMServiceUtil.throwException(epmOlapRequestParam.getModuleId() == null || epmOlapRequestParam.getDimensionEntityName() == null || epmOlapRequestParam.getDimId() == null || ids == null);
        if (epmOlapRequestParam.getDatasetId() == null) {
            epmOlapRequestParam.setDatasetId(0L);
        }
        Map<String, OlapServerDimMemberMetaInfo> stringOlapServerDimMemberMetaInfoMap = this.loadDimensionMembers(epmOlapRequestParam);
        return stringOlapServerDimMemberMetaInfoMap.values().stream().filter(p -> ids.contains(p.getId())).map(OlapServerBaseMetaInfo::getNumber).collect(Collectors.toSet());
    }

    @Override
    public OlapConnectionInformation getOlapConnectionInformation(EpmOlapRequestParam epmOlapRequestParam) {
        IDataMServiceUtil.throwException(epmOlapRequestParam.getDatasetId() == null);
        return new OlapConnectionInformation((Map)EpmOlapRequest.invokeEpmBizServiceEx(null, "getOlapConnectionInformation", epmOlapRequestParam.getDatasetId()), OlapFromServiceEnum.EPM);
    }

    public static <T> T invokeEpmBizServiceEx(Class<T> jsonObjectClassType, String methodName, Object ... params) {
        try {
            return IDataMServiceUtil.invokeBizService(jsonObjectClassType, "epm", "eb", "MPOlapService", methodName, params);
        }
        catch (Exception e) {
            throw new KDBizException(e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
    }
}

