/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.rdb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.enums.FAFSituationTypeEnum;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.model.impl.FAFDimensionModel;
import kd.macc.faf.rdb.RdbSQLAbstractCalculateIterator;

public class RdbComplementIterator
extends RdbSQLAbstractCalculateIterator {
    private FAFDimensionModel orgDim;
    private FAFDimensionModel periodDim;
    private Map<Long, Long> curToPrePeriodMap;
    private Set<Long> orgIdSet;
    private String periodBaseEntity;

    public RdbComplementIterator(String routeKey, String entityName, String selectFields, FAFDimensionModel orgDim, FAFDimensionModel periodDim, Map<Long, Long> curToPrePeriodMap, Set<Long> orgIdSet, String periodBaseEntity) {
        super(routeKey, entityName, selectFields);
        this.orgDim = orgDim;
        this.periodDim = periodDim;
        this.curToPrePeriodMap = curToPrePeriodMap;
        this.orgIdSet = orgIdSet;
        this.periodBaseEntity = periodBaseEntity;
    }

    @Override
    public void splitFilter() {
        String orgField = this.orgDim.getNumber();
        QFilter orgFilter = new QFilter(orgField, "in", this.orgIdSet);
        HashSet periodIds = new HashSet(this.curToPrePeriodMap.size() * 2);
        this.curToPrePeriodMap.forEach((k, v) -> {
            periodIds.add(k);
            if (v != null) {
                String vStr;
                String vYearStr;
                String kStr;
                String kYearStr;
                int start = 0;
                int end = 4;
                if ("bd_period".equals(this.periodBaseEntity)) {
                    Long periodTypeId = this.periodDim.getPeriodType();
                    if (periodTypeId == null) {
                        throw new KDBizException("period type is null");
                    }
                    String periodTypeIdStr = String.valueOf(periodTypeId);
                    start = periodTypeIdStr.length();
                    end = periodTypeIdStr.length() + end;
                }
                if ((kYearStr = (kStr = String.valueOf(k)).substring(start, end)).equals(vYearStr = (vStr = String.valueOf(v)).substring(start, end))) {
                    periodIds.add(v);
                }
            }
        });
        String periodField = this.periodDim.getNumber();
        QFilter periodFilter = new QFilter(periodField, "in", periodIds);
        QFilter notSituationFilter = new QFilter("situationtype", "=", (Object)FAFSituationTypeEnum.ACTUAL.getCode());
        HashMap<Long, Set> orgToPeriodMap = new HashMap<Long, Set>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fixDimStatistic", (String)this.entityNumber, (String)(orgField + "," + periodField), (QFilter[])new QFilter[]{orgFilter, periodFilter, notSituationFilter, FAFTableDataHelper.fixFilter(true)}, null);){
            DataSet distinctDataSet = dataSet.distinct();
            for (Row row : distinctDataSet) {
                Long periodId = row.getLong(periodField);
                Long orgId = row.getLong(orgField);
                Set idSet = orgToPeriodMap.computeIfAbsent(orgId, k -> new HashSet(12));
                idSet.add(periodId);
            }
            distinctDataSet.close();
        }
        orgToPeriodMap.forEach((k, v) -> {
            QFilter[] filters = new QFilter[]{new QFilter(orgField, "=", k), new QFilter(periodField, "in", v), notSituationFilter};
            this.splitFilterList.add(filters);
        });
        this.end.set(true);
    }
}

