/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.rdb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.enums.FAFSituationTypeEnum;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.model.impl.FAFDimensionModel;
import kd.macc.faf.model.impl.FAFMeasureModel;
import kd.macc.faf.rdb.RdbSQLAbstractCalculateIterator;
import kd.macc.faf.rdb.SomeDatasNeasureUnneedCal;

public class RdbSQLSingleCalMeasureIterator
extends RdbSQLAbstractCalculateIterator
implements SomeDatasNeasureUnneedCal {
    private FAFMeasureModel calMeasureModel;
    private FAFDimensionModel orgDim;
    private Set<Long> orgIdSet;

    public RdbSQLSingleCalMeasureIterator(String routeKey, String entityName, String selectFields, FAFMeasureModel calMeasureModel, FAFDimensionModel orgDim, Set<Long> orgIdSet) {
        super(routeKey, entityName, selectFields);
        this.calMeasureModel = calMeasureModel;
        this.orgDim = orgDim;
        this.orgIdSet = orgIdSet;
    }

    @Override
    public void splitFilter() {
        FAFDimensionModel dimension = this.calMeasureModel.getDimension();
        HashSet<Object> situationIdSet = new HashSet<Object>(10);
        HashSet<Object> notSituationIdSet = new HashSet<Object>(10);
        String calDim = dimension.getNumber();
        String org = this.orgDim.getNumber();
        String[] fields = new String[]{org, calDim, "situationtype"};
        boolean isOrg = calDim.equals(org);
        if (isOrg) {
            fields = new String[]{calDim, "situationtype"};
        }
        QFilter[] filters = null;
        if (this.orgIdSet != null && !this.orgIdSet.isEmpty()) {
            filters = new QFilter[]{new QFilter(org, "in", this.orgIdSet)};
        }
        HashMap<Object, Set<Object>> situationOrgMap = new HashMap<Object, Set<Object>>(10);
        HashMap<Object, Set<Object>> noSituationOrgMap = new HashMap<Object, Set<Object>>(10);
        try (DataSet dataSet = FAFTableDataHelper.fixDimStatistic(this.entityNumber, fields, true, filters);){
            for (Row row : dataSet) {
                Object orgId;
                boolean isSituation;
                int situation = row.getInteger("situationtype");
                FAFSituationTypeEnum situationEnum = FAFSituationTypeEnum.getEnum(String.valueOf(situation));
                Object dataId = row.get(calDim);
                boolean bl = isSituation = situationEnum == FAFSituationTypeEnum.BUDGET;
                if (isSituation) {
                    situationIdSet.add(dataId);
                } else {
                    notSituationIdSet.add(dataId);
                }
                if (isOrg) continue;
                HashMap<Object, Set<Object>> orgMap = isSituation ? situationOrgMap : noSituationOrgMap;
                HashSet<Object> calIdSet = (HashSet<Object>)orgMap.get(orgId = row.get(org));
                if (calIdSet == null) {
                    calIdSet = new HashSet<Object>();
                    orgMap.put(orgId, calIdSet);
                }
                calIdSet.add(dataId);
            }
        }
        if (isOrg) {
            this.genFilter(dimension, notSituationIdSet, false);
            this.genFilter(dimension, situationIdSet, true);
        } else {
            this.genFilter(dimension, noSituationOrgMap, notSituationIdSet, false);
            this.genFilter(dimension, situationOrgMap, situationIdSet, true);
        }
        this.end.set(true);
    }

    private void genFilter(FAFDimensionModel dimension, Map<Object, Set<Object>> orgMap, Collection<Object> idList, boolean isSituation) {
        if (idList.isEmpty()) {
            return;
        }
        Map<Object, List<Object>> classifyMap = FAFTableDataHelper.queryDimensionData(dimension, this.calMeasureModel.getDimensionattrs(), idList);
        Set<Map.Entry<Object, List<Object>>> entrySet = classifyMap.entrySet();
        HashMap<Object, Object> idKeyMap = new HashMap<Object, Object>(idList.size());
        for (Map.Entry<Object, List<Object>> entry : entrySet) {
            List<Object> ids = entry.getValue();
            Object key = entry.getKey();
            for (Object id : ids) {
                idKeyMap.put(id, key);
            }
        }
        FAFSituationTypeEnum situationTypeEnum = isSituation ? FAFSituationTypeEnum.BUDGET : FAFSituationTypeEnum.ACTUAL;
        Set<Map.Entry<Object, Set<Object>>> orgEntrySet = orgMap.entrySet();
        for (Map.Entry<Object, Set<Object>> entry : orgEntrySet) {
            Set<Object> idSet = entry.getValue();
            Object orgId = entry.getKey();
            HashMap orgClassifyMap = new HashMap();
            for (Object id : idSet) {
                Object key = idKeyMap.get(id);
                ArrayList<Object> idClassList = (ArrayList<Object>)orgClassifyMap.get(key);
                if (idClassList == null) {
                    idClassList = new ArrayList<Object>(10);
                    orgClassifyMap.put(key, idClassList);
                }
                idClassList.add(id);
            }
            Set comboEntrySet = orgClassifyMap.entrySet();
            for (Map.Entry filterEntry : comboEntrySet) {
                List classifyCalIdList = (List)filterEntry.getValue();
                this.splitFilterList.add(new QFilter[]{new QFilter(dimension.getNumber(), "in", (Object)classifyCalIdList), new QFilter(this.orgDim.getNumber(), "=", orgId), new QFilter("situationtype", "=", (Object)situationTypeEnum.getCode())});
            }
        }
    }

    private void genFilter(FAFDimensionModel dimension, Collection<Object> idList, boolean isSituation) {
        Map<Object, List<Object>> classifyMap = FAFTableDataHelper.queryDimensionData(dimension, this.calMeasureModel.getDimensionattrs(), idList);
        FAFSituationTypeEnum situationTypeEnum = isSituation ? FAFSituationTypeEnum.BUDGET : FAFSituationTypeEnum.ACTUAL;
        for (List<Object> list : classifyMap.values()) {
            this.splitFilterList.add(new QFilter[]{new QFilter(dimension.getNumber(), "in", list), new QFilter("situationtype", "=", (Object)situationTypeEnum.getCode())});
        }
    }
}

