/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.rdb;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.model.impl.ThreeValueTuple;
import kd.macc.faf.rdb.RdbSQLInfo;

public class RdbSQLSplitTaskIterator
extends RdbSQLInfo
implements Iterator<ThreeValueTuple<QFilter[], Integer, Integer>>,
Cloneable {
    protected List<ThreeValueTuple<QFilter[], Integer, Integer>> splitQFilters;
    protected ThreeValueTuple<QFilter[], Integer, Integer> qFiltersTuple;
    protected AtomicInteger qFilterIndex;
    protected String subEntryFields;
    protected String[] orgAndPeriodTargetNumber;
    protected Integer batchCount;
    protected Integer totalCount;

    public RdbSQLSplitTaskIterator(String routeKey, String entityNumber, String selectFields, QFilter[] filters, List<ThreeValueTuple<QFilter[], Integer, Integer>> splitQFilters, String[] targetNumber, Integer batchCount, Integer totalCount) {
        super(routeKey, entityNumber, selectFields, filters);
        this.splitQFilters = splitQFilters;
        this.qFilterIndex = new AtomicInteger(0);
        this.orgAndPeriodTargetNumber = targetNumber;
        this.batchCount = batchCount;
        this.totalCount = totalCount;
    }

    @Override
    public synchronized boolean hasNext() {
        return (this.qFiltersTuple != null || this.splitQFilters.size() > this.qFilterIndex.get()) && (this.qFiltersTuple == null || !this.qFiltersTuple.getValue().equals(this.qFiltersTuple.getElement()));
    }

    @Override
    public synchronized ThreeValueTuple<QFilter[], Integer, Integer> next() {
        this.qFiltersTuple.setElement(this.qFiltersTuple.getValue());
        return this.qFiltersTuple;
    }

    public RdbSQLSplitTaskIterator createNextQFilterIterator() {
        try {
            RdbSQLSplitTaskIterator clone = (RdbSQLSplitTaskIterator)this.clone();
            clone.setqFiltersTuple(this.splitQFilters.get(this.qFilterIndex.getAndAdd(1)));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u6570\u636e\u62bd\u53d6\u4e2d ,RdbSQLSplitTaskIterator\u62f7\u8d1d\u3002\u53d1\u751f\u5f02\u5e38\uff1a%s", (String)"RdbSQLSplitTaskIterator_0", (String)"macc-faf-common", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
    }

    public static QFilter[] concat(QFilter[] first, QFilter[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        QFilter[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public void close() {
        this.qFiltersTuple = null;
    }

    public String[] getOrgAndPeriodTargetNumber() {
        return this.orgAndPeriodTargetNumber;
    }

    public String getSubEntryFields() {
        return this.subEntryFields;
    }

    public void setSubEntryFields(String subEntryFields) {
        this.subEntryFields = subEntryFields;
    }

    public void setqFiltersTuple(ThreeValueTuple<QFilter[], Integer, Integer> qFiltersTuple) {
        this.qFiltersTuple = qFiltersTuple;
    }

    public ThreeValueTuple<QFilter[], Integer, Integer> getQFiltersTuple() {
        return this.qFiltersTuple;
    }

    public Integer getBatchCount() {
        return this.batchCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }
}

