/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.rdb;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.model.impl.FAFDimensionModel;
import kd.macc.faf.rdb.RdbSQLAbstractCalculateIterator;
import kd.macc.faf.util.DateUtil;

public class RdbSQLSummaryIterator
extends RdbSQLAbstractCalculateIterator {
    private String[] fixDimensions;
    private Map<String, FAFDimensionModel> fixDimensionMap;
    private FAFDimensionModel orgDim;
    private FAFDimensionModel periodDim;
    private Set<Long> orgIdSet;
    private Set<Long> periodIdSet;
    private boolean hasDate;
    private Date startDate;
    private Date endDate;

    public RdbSQLSummaryIterator(String routeKey, String entityName, String selectFields, FAFDimensionModel orgDim, FAFDimensionModel periodDim, Set<Long> orgIdSet, Set<Long> periodIdSet, Date startDate, Date endDate) {
        super(routeKey, entityName, selectFields);
        this.orgDim = orgDim;
        this.periodDim = periodDim;
        this.orgIdSet = orgIdSet;
        this.periodIdSet = periodIdSet;
        this.hasDate = DimensionTypeEnum.DATE == periodDim.getDataType();
        this.fixDimensions = new String[]{orgDim.getNumber(), periodDim.getNumber(), "situationtype"};
        this.fixDimensionMap = new HashMap<String, FAFDimensionModel>(5);
        this.fixDimensionMap.put(orgDim.getNumber(), orgDim);
        this.fixDimensionMap.put(periodDim.getNumber(), periodDim);
        this.startDate = startDate;
        this.endDate = endDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void splitFilter() {
        QFilter[] filters = this.genFilters();
        if (this.hasDate) {
            FAFDimensionModel dimModel;
            int i;
            HashSet<String> filterStrSet = new HashSet<String>(10);
            try (DataSet dataSet = FAFTableDataHelper.fixDimStatistic(this.entityNumber, this.fixDimensions, false, filters);){
                if (dataSet != null) {
                    for (Row row : dataSet) {
                        i = 0;
                        StringBuilder key = new StringBuilder();
                        String[] stringArray = this.fixDimensions;
                        int n = stringArray.length;
                        for (int j = 0; j < n; ++j) {
                            String dim = stringArray[j];
                            ++i;
                            dimModel = this.fixDimensionMap.get(dim);
                            if (dimModel == null) {
                                key.append(dim).append('=').append(row.getString(dim)).append('|');
                                continue;
                            }
                            if (DimensionTypeEnum.DATE == dimModel.getDataType()) {
                                Date date = row.getDate(dim);
                                String dateStr = DateUtil.getYearAndMonth(date);
                                key.append(dim).append('=').append(dateStr).append('|');
                                continue;
                            }
                            String idStr = String.valueOf(row.get(dim));
                            key.append(dim).append('=').append(idStr).append('|');
                        }
                        filterStrSet.add(key.substring(0, key.length() - 1));
                    }
                }
            }
            if (filterStrSet.isEmpty()) return;
            for (String key : filterStrSet) {
                String[] filterStrs = key.split("\\|");
                QFilter[] filter = new QFilter[filterStrs.length];
                i = 0;
                block25: for (String filterStr : filterStrs) {
                    String[] filterValue = filterStr.split("=");
                    dimModel = this.fixDimensionMap.get(filterValue[0]);
                    if (dimModel == null) {
                        filter[i++] = new QFilter(filterValue[0], "=", (Object)Integer.parseInt(filterValue[1]));
                        continue;
                    }
                    switch (dimModel.getDataType()) {
                        case DATE: {
                            Date[] dates = DateUtil.getMothStartAndEnd(filterValue[1]);
                            String dateFilterStr = String.format(" %s >= ? and %s <= ? ", filterValue[0], filterValue[0]);
                            filter[i++] = QFilter.of((String)dateFilterStr, (Object[])new Object[]{dates[0], dates[1]});
                            continue block25;
                        }
                        case OTHER: 
                        case NOTHING: {
                            filter[i++] = new QFilter(filterValue[0], "=", (Object)filterValue[1]);
                            continue block25;
                        }
                        default: {
                            filter[i++] = new QFilter(filterValue[0], "=", (Object)Long.valueOf(filterValue[1]));
                        }
                    }
                }
                this.splitFilterList.add(filter);
            }
            return;
        }
        try (DataSet dataSet = FAFTableDataHelper.fixDimStatistic(this.entityNumber, this.fixDimensions, false, filters);){
            if (dataSet == null) return;
            for (Row row : dataSet) {
                QFilter[] filter = new QFilter[this.fixDimensions.length];
                int i = 0;
                for (String dim : this.fixDimensions) {
                    filter[i] = new QFilter(dim, "=", row.get(dim));
                    ++i;
                }
                this.splitFilterList.add(filter);
            }
            return;
        }
    }

    private QFilter[] genFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>(4);
        if (this.orgIdSet != null && !this.orgIdSet.isEmpty()) {
            list.add(new QFilter(this.orgDim.getNumber(), "in", this.orgIdSet));
        }
        if (this.hasDate && this.startDate != null && this.endDate != null) {
            QFilter startFilter = new QFilter(this.periodDim.getNumber(), ">=", (Object)this.startDate);
            QFilter endFilter = new QFilter(this.periodDim.getNumber(), "<=", (Object)this.endDate);
            list.add(startFilter.and(endFilter));
        }
        if (!this.hasDate && this.periodIdSet != null && !this.periodIdSet.isEmpty()) {
            list.add(new QFilter(this.periodDim.getNumber(), "in", this.periodIdSet));
        }
        return list.isEmpty() ? null : list.toArray(new QFilter[0]);
    }
}

