/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.template;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.template.FAFTemplate;

public class FAFDynamicObjectTemplate {
    private final String entityName;
    private final Map<String, Object> propsMap = new LinkedHashMap<String, Object>();
    private final Map<String, Object[]> entryPropsMap = new LinkedHashMap<String, Object[]>();
    private FAFTemplate paTemplate;

    private FAFDynamicObjectTemplate(String entityName) {
        this.entityName = entityName;
        this.paTemplate = new FAFTemplate();
    }

    public static FAFDynamicObjectTemplate create(String entityName) {
        return new FAFDynamicObjectTemplate(entityName);
    }

    public FAFTemplate.Builder template() {
        return FAFTemplate.builder(this);
    }

    public FAFDynamicObjectTemplate propsCommon() {
        this.propsMap.put("creator", RequestContext.get().getCurrUserId());
        this.propsMap.put("createtime", new Date());
        this.propsMap.put("status", Character.valueOf('C'));
        this.propsMap.put("enable", Character.valueOf('1'));
        return this;
    }

    public FAFDynamicObjectTemplate template(FAFTemplate template) {
        this.paTemplate = template;
        return this;
    }

    public FAFDynamicObjectTemplate put(String prop, Object value) {
        this.propsMap.put(prop, value);
        return this;
    }

    @Deprecated
    public FAFDynamicObjectTemplate put(String prop, List<Map<String, Object>> value) {
        return null;
    }

    @Deprecated
    public DynamicObject[] getOneDynamicObject() {
        return null;
    }

    public DynamicObject[] getDynamicObjects() {
        List<Object[]> valuesList = this.paTemplate.getValuesList();
        DynamicObject[] dynamicObjects = new DynamicObject[valuesList.size()];
        for (int i = 0; i < valuesList.size(); ++i) {
            Object[] objects = valuesList.get(i);
            Map<String, Object> propsMaps = this.fillPropsMaps(objects);
            dynamicObjects[i] = this.getDynamicObject(propsMaps);
        }
        return dynamicObjects;
    }

    private Map<String, Object> fillPropsMaps(Object[] values) {
        Map<String, Object> propsMap = this.getPropsMap();
        Object[] fields = this.paTemplate.getFields();
        this.fillPropsMap(propsMap, fields, values);
        return propsMap;
    }

    private Map<String, Object> getPropsMap() {
        Map<String, Object> map = this.paTemplate.getPropsMap();
        Set<Map.Entry<String, Object>> entries = this.propsMap.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    private void fillPropsMap(Map<String, Object> propsMap, Object[] fields, Object[] values) {
        for (int i = 0; i < fields.length; ++i) {
            Object field = fields[i];
            Object value = values[i];
            if (field.getClass().isArray() && value.getClass().isArray()) {
                Object[] entryFields = (Object[])field;
                Object[] entryValues = (Object[])value;
                String entryKey = String.valueOf(entryFields[entryFields.length - 1]);
                this.entryPropsMap.put(entryKey, entryFields);
                propsMap.put(entryKey, entryValues);
                continue;
            }
            if (!(field instanceof String)) continue;
            propsMap.put((String)field, value);
        }
    }

    public DynamicObject getDynamicObject(Map<String, Object> propsMap) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
        Set<Map.Entry<String, Object>> entries = propsMap.entrySet();
        for (Map.Entry<String, Object> row : entries) {
            Object value = row.getValue();
            if (value.getClass().isArray()) {
                Object[] entryRows;
                DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection(row.getKey());
                for (Object entryRow : entryRows = (Object[])value) {
                    DynamicObject entryDynamicObject = dynamicObjects.addNew();
                    Object[] entryFields = this.entryPropsMap.get(row.getKey());
                    Object[] entryRowData = (Object[])entryRow;
                    this.setDynamicObjects(entryDynamicObject, this.toMap(entryFields, entryRowData));
                }
                continue;
            }
            dynamicObject.set(row.getKey(), row.getValue());
        }
        return dynamicObject;
    }

    private Map<String, Object> toMap(Object[] entryFields, Object[] entryRowData) {
        HashMap<String, Object> objectHashMap = new HashMap<String, Object>();
        for (int i = 0; i < entryFields.length - 1; ++i) {
            if (!(entryFields[i] instanceof String)) continue;
            objectHashMap.put((String)entryFields[i], entryRowData[i]);
        }
        return objectHashMap;
    }

    private void setDynamicObjects(DynamicObject dynamicObject, Map<String, Object> entryRow) {
        Set<Map.Entry<String, Object>> entries = entryRow.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            dynamicObject.set(entry.getKey(), entry.getValue());
        }
    }
}

