/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.macc.faf.template.FAFDynamicObjectTemplate;

public class FAFTemplate {
    private final Object[] fields;
    private final List<Object[]> valuesList;
    private final Map<String, Object> propsMap;

    public FAFTemplate() {
        this.fields = new Object[0];
        this.valuesList = new ArrayList<Object[]>(0);
        this.propsMap = new HashMap<String, Object>(0);
    }

    public FAFTemplate(Object[] fields, List<Object[]> valuesList) {
        this.fields = fields;
        this.valuesList = valuesList;
        this.propsMap = new HashMap<String, Object>();
    }

    public Object[] getFields() {
        return this.fields;
    }

    public List<Object[]> getValuesList() {
        return this.valuesList;
    }

    public Map<String, Object> getPropsMap() {
        return this.propsMap;
    }

    public static Builder builder(FAFDynamicObjectTemplate paDynamicObjectTemplate) {
        return new Builder(paDynamicObjectTemplate);
    }

    public static class Builder {
        private Object[] fields;
        private final List<Object[]> valuesList;
        private final FAFDynamicObjectTemplate objectTemplate;

        public Builder(FAFDynamicObjectTemplate objectTemplate) {
            this.objectTemplate = objectTemplate;
            this.valuesList = new ArrayList<Object[]>(2);
        }

        public Builder setFields(Object[] fields) {
            this.fields = fields;
            return this;
        }

        public Builder addValues(Object[] values) {
            this.valuesList.add(values);
            return this;
        }

        public Builder addValuesList(List<Object[]> valuesList) {
            this.valuesList.addAll(valuesList);
            return this;
        }

        public FAFDynamicObjectTemplate finish() {
            if (this.fields == null) {
                throw new KDBizException("PATemplate fields not null");
            }
            return this.objectTemplate.template(new FAFTemplate(this.fields, this.valuesList));
        }
    }
}

