/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.enums.DimensionNecessityEnum;
import org.apache.commons.codec.digest.DigestUtils;

public class AnalysisModelHashUtil {
    private static final Log logger = LogFactory.getLog(AnalysisModelHashUtil.class);

    private AnalysisModelHashUtil() {
    }

    public static boolean isModelContainsDimHash(String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty dimHashProperty = dataEntityType.getProperty("dimhash");
        return dimHashProperty != null;
    }

    public static List<String> queryModelHashDimension(Long analysisModelId) {
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModel != null) {
            return AnalysisModelHashUtil.queryModelHashDimension(analysisModel);
        }
        return new ArrayList<String>();
    }

    public static List<String> queryModelHashDimension(DynamicObject analysisModel) {
        List<String> modelHashDimensionNumberList = new ArrayList<String>();
        if (analysisModel != null) {
            DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
            modelHashDimensionNumberList = dimensionEntry.stream().filter(dy -> !DimensionNecessityEnum.PERIOD.getCode().equals(dy.getString("necessity_dim"))).sorted(Comparator.comparingLong(dy -> dy.getLong("dimension_id"))).map(dy -> dy.getDynamicObject("dimension").getString("number")).collect(Collectors.toList());
        }
        return modelHashDimensionNumberList;
    }

    public static String calculateDimHash(RowMeta rowMeta, RowX rowx, List<String> modelHashDimensionNumberList) {
        StringBuilder sb = new StringBuilder(512);
        for (String field : modelHashDimensionNumberList) {
            Object value;
            int index = rowMeta.getFieldIndex(field, false);
            if (index < 0 || (value = rowx.get(index)) == null) continue;
            sb.append(AnalysisModelHashUtil.dimValueToString(value));
        }
        return AnalysisModelHashUtil.calculateHash(sb.toString());
    }

    public static String calculateDimHash(RowX rowx, List<Integer> dimensionIndexs) {
        StringBuilder sb = new StringBuilder(512);
        for (int index : dimensionIndexs) {
            Object value;
            if (index < 0 || (value = rowx.get(index)) == null) continue;
            sb.append(AnalysisModelHashUtil.dimValueToString(value));
        }
        return AnalysisModelHashUtil.calculateHash(sb.toString());
    }

    public static String calculateDimHash(Row row, List<String> modelHashDimensionNumberList) {
        StringBuilder sb = new StringBuilder(512);
        for (String field : modelHashDimensionNumberList) {
            Object value = row.get(field);
            if (value == null) continue;
            sb.append(AnalysisModelHashUtil.dimValueToString(value));
        }
        return AnalysisModelHashUtil.calculateHash(sb.toString());
    }

    public static String calculateDimHash(DynamicObject modelDetailOrSummaryData, List<String> modelHashDimensionNumberList) {
        StringBuilder sb = new StringBuilder(512);
        for (String field : modelHashDimensionNumberList) {
            Object value = modelDetailOrSummaryData.get(field);
            if (value == null) continue;
            sb.append(AnalysisModelHashUtil.dimValueToString(value));
        }
        return AnalysisModelHashUtil.calculateHash(sb.toString());
    }

    private static String dimValueToString(Object value) {
        if (value != null) {
            if (value instanceof Long) {
                Long longValue = (Long)value;
                return longValue == 0L ? "" : longValue.toString();
            }
            if (value instanceof String) {
                return ((String)value).trim();
            }
            if (value instanceof DynamicObject) {
                return AnalysisModelHashUtil.dimValueToString(((DynamicObject)value).getPkValue());
            }
        }
        return "";
    }

    private static String calculateHash(String dimValue) {
        if (dimValue != null) {
            return DigestUtils.md5Hex((byte[])dimValue.getBytes(StandardCharsets.UTF_8)).substring(0, 16).toLowerCase();
        }
        return "";
    }
}

