/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.util.Tuple2;
import kd.bos.exception.KDBizException;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class CalculateUtils<T extends Number> {
    private static final Log logger = LogFactory.getLog(CalculateUtils.class);
    public static final Pattern ELEMENT_PATTERN = Pattern.compile("\\[(.*?)\\]");
    List<Map<String, T>> dataCacheLists;
    private Function<String, T> ifNullFunction = null;
    Map<String, T> dataCache;
    Map<String, String> numberCalcformulars;
    Map<String, String> legitimateCalcformulars;
    private Set<String> hasParsedNumber = new HashSet<String>();

    public CalculateUtils(Map<String, T[]> map, int top) {
        if (!map.isEmpty()) {
            this.dataCacheLists = new ArrayList<Map<String, T>>(top);
            for (int i = 0; i < top; ++i) {
                HashMap<String, T> cacheMap = new HashMap<String, T>((int)((float)map.size() / 0.75f) + 1);
                for (Map.Entry<String, T[]> entry : map.entrySet()) {
                    String key = entry.getKey();
                    Number value = ((Number[])entry.getValue())[i];
                    cacheMap.put("A" + key, value);
                }
                this.dataCache = cacheMap;
                this.dataCacheLists.add(cacheMap);
            }
        }
    }

    public CalculateUtils(Map<String, T> ... maps) {
        if (maps.length > 0) {
            this.dataCacheLists = new ArrayList<Map<String, T>>(maps.length);
            for (Map<String, T> map : maps) {
                HashMap<String, T> cacheMap = new HashMap<String, T>((int)((float)map.size() / 0.75f) + 1);
                for (Map.Entry<String, T> entry : map.entrySet()) {
                    String key = entry.getKey();
                    Number value = (Number)entry.getValue();
                    cacheMap.put("A" + key, value);
                }
                this.dataCache = cacheMap;
                this.dataCacheLists.add(cacheMap);
            }
        }
    }

    public List<T> calculate(String calcformular) {
        return this.calculate(calcformular, null);
    }

    public List<T> calculate(String calcformular, Function<T, T> function) {
        if (StringUtils.isEmpty((String)calcformular) || CollectionUtils.isEmpty(this.dataCacheLists)) {
            logger.error("calcformular is null or dataCacheLists is empty");
            throw new KDBizException("calcformular is null or dataCacheLists is empty");
        }
        String[] split = calcformular.split("\\s+");
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            String str = s.replaceAll("\\s+", "").replaceAll("\\[", "A").replaceAll("]", "");
            sb.append(str);
        }
        ArrayList<Number> returnList = new ArrayList<Number>(this.dataCacheLists.size());
        String strCalcformular = sb.toString();
        for (Map<String, T> map : this.dataCacheLists) {
            Number ts;
            try {
                Object obj = FormulaEngine.runFormula((String)strCalcformular, map);
                if (obj instanceof Number) {
                    ts = (Number)obj;
                    if (function != null) {
                        ts = (Number)function.apply(ts);
                    }
                } else {
                    logger.error(String.format("\u8ba1\u7b97\u516c\u5f0f\u7f3a\u5c11\u503c\u3002calcformular=%s,data=%s,return=%s", strCalcformular, JSONObject.toJSONString(map), obj == null ? "null" : obj.toString()));
                    ts = null;
                }
            }
            catch (RunFormulaException e) {
                logger.error(String.format("\u8ba1\u7b97\u516c\u5f0f\u7f3a\u5c11\u503c\u3002calcformular=%s,data=%s,return=%s", strCalcformular, JSONObject.toJSONString(map), "null"));
                ts = null;
            }
            catch (Exception e) {
                logger.error(String.format("\u516c\u5f0f\u8ba1\u7b97\u5f02\u5e38\u3002calcformular=%s,data=%s", strCalcformular, JSONObject.toJSONString(map)), (Throwable)e);
                ts = null;
            }
            returnList.add(ts);
        }
        return returnList;
    }

    public List<Tuple2<String, List<T>>> calculate(Map<String, String> map) {
        Map<String, String> cacheCalculates = this.depend2Independent(map);
        ArrayList<Tuple2<String, List<T>>> list = new ArrayList<Tuple2<String, List<T>>>(cacheCalculates.size());
        for (Map.Entry<String, String> entry : cacheCalculates.entrySet()) {
            list.add(new Tuple2((Object)entry.getKey(), this.calculate(entry.getValue())));
        }
        return list;
    }

    public Map<String, String> depend2Independent(Map<String, String> map) {
        this.numberCalcformulars = this.calculateMapKeySetA(map);
        this.legitimateCalcformulars = new HashMap<String, String>((int)((float)map.size() / 0.75f) + 1);
        for (Map.Entry<String, String> tuple2 : this.numberCalcformulars.entrySet()) {
            String number = tuple2.getKey();
            try {
                String calcformular = this.parseCalcformular(number);
                this.legitimateCalcformulars.put(number, calcformular);
            }
            catch (KDBizException kdBizException) {
                logger.error(kdBizException.getMessage());
            }
        }
        return this.calculateMapKeyRemoveA(this.legitimateCalcformulars);
    }

    private Map<String, String> calculateMapKeySetA(Map<String, String> map) {
        return this.mapKeyOpera(map, k -> "A" + k);
    }

    private Map<String, String> calculateMapKeyRemoveA(Map<String, String> map) {
        return this.mapKeyOpera(map, k -> k.substring(1));
    }

    private Map<String, String> mapKeyOpera(Map<String, String> map, Function<String, String> function) {
        HashMap<String, String> cacheMap = new HashMap<String, String>((int)((float)map.size() / 0.75f) + 1);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String apply = function.apply(key);
            cacheMap.put(apply, value);
        }
        return cacheMap;
    }

    private String parseCalcformular(String number) {
        this.hasParsedNumber.add(number);
        String calcformulars = this.numberCalcformulars.get(number);
        String numberFormula = this.legitimateCalcformulars.get(number);
        return numberFormula != null ? numberFormula : this.parseElement(calcformulars);
    }

    private String parseElement(String calcformular) {
        Matcher m = ELEMENT_PATTERN.matcher(calcformular);
        while (m.find()) {
            boolean isNeedParentheses = true;
            String needToReplaceStr = m.group(0);
            String calcformularElement = m.group(1);
            String number = "A" + calcformularElement.trim();
            String numberCalcformular = "";
            String numberFormula = this.legitimateCalcformulars.get(number);
            if (numberFormula != null) {
                numberCalcformular = numberFormula;
            } else if (this.dataCache != null && this.dataCache.get(number) != null) {
                numberCalcformular = "[" + number.substring(1) + "]";
                isNeedParentheses = false;
            } else if (this.numberCalcformulars.get(number) != null) {
                if (this.hasParsedNumber.contains(number)) {
                    throw new KDBizException("unresolved number : " + number);
                }
                numberCalcformular = this.parseCalcformular(number);
                this.legitimateCalcformulars.put(number, numberCalcformular);
            } else if (this.dataCache != null && this.ifNullFunction != null) {
                Number value = (Number)this.ifNullFunction.apply(number);
                this.dataCache.put(number, value);
                for (Map<String, T> dataCacheList : this.dataCacheLists) {
                    if (dataCacheList == null) continue;
                    dataCacheList.put(number, value);
                }
                isNeedParentheses = false;
                numberCalcformular = "[" + number.substring(1) + "]";
            } else {
                throw new KDBizException("the " + number + " is not defined");
            }
            if (isNeedParentheses) {
                numberCalcformular = "(" + numberCalcformular + ")";
            }
            calcformular = calcformular.replace(needToReplaceStr, numberCalcformular);
        }
        return calcformular;
    }

    public static String format(String formula, Function<String, String> formatFunctiion) {
        StringBuilder newCaculation = new StringBuilder();
        String[] split = formula.trim().split("[+\\-\\*/\\(\\)\\s]+");
        for (int i = 0; i < split.length; ++i) {
            String forulaItem = split[i];
            if ("".equals(forulaItem)) continue;
            String newNumber = formatFunctiion.apply(forulaItem);
            String afterReplace = formula.replaceFirst(forulaItem, newNumber);
            int index = afterReplace.indexOf(newNumber) + newNumber.length();
            newCaculation.append(afterReplace.substring(0, index));
            formula = afterReplace.substring(index);
        }
        if (formula.length() > 0) {
            newCaculation.append(formula);
        }
        return newCaculation.toString();
    }

    public static String format(String formula) {
        return CalculateUtils.format(formula, forulaItem -> "[" + forulaItem + "]");
    }

    public static String formulaItemFormat(String item) {
        return CalculateUtils.formulaItemFormat(item, false);
    }

    public static String formulaItemFormat(String item, boolean isEscape) {
        String escape = "";
        String escape1 = "";
        if (isEscape) {
            escape = "\\\\(?<=\\\\)";
            escape1 = "(?=(?:3_|8_|9_|0_|B_|S_)(?!_))";
        }
        String str = item.replaceAll("_", "__").replaceAll(escape + "-", "_").replaceAll("!", "1_").replaceAll("@", "2_").replaceAll(escape + "/", "3_").replaceAll("\\$", "4_").replaceAll("%", "5_").replaceAll("\\^", "6_").replaceAll("&", "7_").replaceAll(escape + "\\*", "8_").replaceAll(escape + "\\(", "9_").replaceAll(escape + "\\)", "0_").replaceAll("=", "A_").replaceAll(escape + "\\+", "B_").replaceAll("\\{", "C_").replaceAll("}", "D_").replaceAll("\\[", "E_").replaceAll("]", "F_").replaceAll("\\.", "G_").replaceAll(";", "H_").replaceAll("\\\"", "I_").replaceAll("<", "J_").replaceAll(">", "K_").replaceAll("\\?", "L_").replaceAll(",", "M_").replaceAll("'", "N_").replaceAll("~", "O_").replaceAll("`", "P_").replaceAll(":", "Q_").replaceAll(escape + "\\s", "S_").replaceAll("\\|", "T_").replaceAll("\\\\\\\\" + escape1, isEscape ? "R_" : "\\\\\\\\").replaceAll("\\\\", "R_").replaceAll("#", "U_");
        return str;
    }

    public void setIfNullFunction(Function<String, T> ifNullFunction) {
        this.ifNullFunction = ifNullFunction;
    }

    public static Set<String> getElementFromFormula(String formula) {
        String spiltRules = "\\+|-|\\*|/|=|\\(|\\)";
        String[] array = formula.split(spiltRules);
        HashSet<String> numberSet = new HashSet<String>(array.length);
        for (String number : array) {
            if (!StringUtils.isNotEmpty((String)number)) continue;
            numberSet.add(number.trim());
        }
        return numberSet;
    }

    public static String restoreFormulaItem(String item, boolean isEscape) {
        String escape = "";
        String escape1 = "";
        if (isEscape) {
            escape = "\\\\(?<=\\\\)";
            escape1 = "(?=(?:3_|8_|9_|0_|B_|S_)(?!_))";
        }
        String str = item.replaceAll("A_", "=").replaceAll("B_", escape + "\\+").replaceAll("C_", "\\{").replaceAll("D_", "}").replaceAll("E_", "\\[").replaceAll("F_", "]").replaceAll("G_", "\\.").replaceAll("H_", ";").replaceAll("I_", "\\\"").replaceAll("J_", "<").replaceAll("K_", ">").replaceAll("L_", "\\?").replaceAll("M_", ",").replaceAll("N_", "'").replaceAll("O_", "~").replaceAll("P_", "`").replaceAll("Q_", ":").replaceAll("S_", escape + "\\s").replaceAll("T_", "\\|").replaceAll(isEscape ? "R_" : "\\\\\\\\", "\\\\\\\\" + escape1).replaceAll("R_", "\\\\").replaceAll("U_", "#").replaceAll("1_", "!").replaceAll("2_", "@").replaceAll("3_", escape + "/").replaceAll("4_", "\\$").replaceAll("5_", "%").replaceAll("6_", "\\^").replaceAll("7_", "&").replaceAll("8_", escape + "\\*").replaceAll("9_", escape + "\\(").replaceAll("0_", escape + "\\)").replaceAll("_", escape + "-").replaceAll("__", "_");
        return str;
    }
}

