/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.Visitor;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.util.CalculateCondition;
import kd.macc.faf.util.ScriptEngine;

public class ConditionExecutor {
    private static final Log logger = LogFactory.getLog(ConditionExecutor.class);
    private static FunctionManage fm;
    private static ExpressionContext expContext;
    private static final String REGEX = "[+\\-*/]";

    public static Object exeMeasureCondition(Row row, CalculateCondition condition) {
        Set<String> fieldSet = condition.parseProperty();
        HashMap<String, Object> ctx = new HashMap<String, Object>(fieldSet.size());
        for (String field : fieldSet) {
            ctx.put(field, row.get(field));
        }
        condition.tranCondition();
        String conditionScript = condition.getConditionScript();
        Object result = ScriptEngine.getEngine().runScript(conditionScript, ctx);
        int matchRow = ScriptEngine.getEngine().getIntValue(result, -1);
        if (matchRow == -1) {
            return null;
        }
        String express = condition.getCalculateExpress(matchRow);
        result = ConditionExecutor.getExpressionValue(express, ctx, ConditionExecutor.getFunctionManage());
        return result;
    }

    public static Object exeMeasureCondition(Map<String, Object> ctx, CalculateCondition condition) {
        condition.parseProperty();
        condition.tranCondition();
        String conditionScript = condition.getConditionScript();
        Object result = ScriptEngine.getEngine().runScript(conditionScript, ctx);
        int matchRow = ScriptEngine.getEngine().getIntValue(result, -1);
        if (matchRow == -1) {
            return null;
        }
        String express = condition.getCalculateExpress(matchRow);
        result = ConditionExecutor.getExpressionValue(express, ctx, ConditionExecutor.getFunctionManage());
        return result;
    }

    public static Object exeMeasureCondition(RowX rowX, CalculateCondition condition, RowMeta rowMeta) {
        Set<String> fieldSet = condition.parseProperty();
        HashMap<String, Object> ctx = new HashMap<String, Object>(fieldSet.size());
        for (String field : fieldSet) {
            ctx.put(field, rowX.get(rowMeta.getFieldIndex(field)));
        }
        condition.tranCondition();
        String conditionScript = condition.getConditionScript();
        Object result = ScriptEngine.getEngine().runScript(conditionScript, ctx);
        int matchRow = ScriptEngine.getEngine().getIntValue(result, -1);
        if (matchRow == -1) {
            return null;
        }
        String express = condition.getCalculateExpress(matchRow);
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(express);
        if (matcher.find()) {
            for (String field : fieldSet) {
                if (!express.contains(field)) continue;
                try {
                    ctx.put(field, new BigDecimal(rowX.get(rowMeta.getFieldIndex(field)) == null ? "0" : rowX.get(rowMeta.getFieldIndex(field)).toString()));
                }
                catch (NumberFormatException e) {
                    logger.info("macc-faf conditionExecutor: NumberFormatException" + e.getMessage());
                    return BigDecimal.ZERO;
                }
            }
        }
        result = ConditionExecutor.getExpressionValue(express, ctx, ConditionExecutor.getFunctionManage());
        return result;
    }

    public static Object getExpressionValue(String expression, Map<String, Object> variableMap, FunctionManage funcLib) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        Expr expr = FormulaEngine.parseFormula((String)expression);
        UDFunctionVisitor funVisitor = new UDFunctionVisitor();
        expr.accept((Visitor)funVisitor);
        HashSet funcs = new HashSet();
        funcs.addAll(funVisitor.getFuncNames());
        ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>();
        for (String funcName : funcs) {
            if (!funcLib.getFuncMap().containsKey(funcName)) continue;
            BOSUDFunction instance = ((BOSUDFunction)funcLib.getFuncMap().get(funcName)).getInstance(expContext);
            instances.add(instance);
        }
        BOSUDFunction[] functions = instances.toArray(new BOSUDFunction[instances.size()]);
        return FormulaEngine.execExcelFormula((Expr)expr, variableMap, (UDFunction[])functions);
    }

    public static FunctionManage getFunctionManage() {
        if (fm == null) {
            fm = FunctionManage.get();
        }
        return fm;
    }

    static {
        expContext = new BOSExpressionContext(null);
    }
}

