/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.DesignerData;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.devportal.util.PageBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.RefProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.util.CustomizedFormBuilderInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class CustomizedDynamicFormBuilderUtil {
    private static final Log logger = LogFactory.getLog(CustomizedDynamicFormBuilderUtil.class);
    private static final String ISVCHECKRESULT = "isvcheckresult";
    private static final String MDL_DEVPORTALUTIL_BUILDNEWPAGE = "mdl_DevportalUtil_buildNewPage";
    private static final String SUCCESS = "success";
    private static final String ERRORS = "errors";
    private static final String MESSAGE = "message";
    private static final String FI_PA_COMMON = "fi_pa_common";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BOS_DEVPORTAL_UNITRELFORM = "bos_devportal_unitrelform";
    private static final String BIZAPP = "bizapp";
    private static final String BIZUNIT = "bizunit";
    private static final String FORMID = "formid";
    private static final String FORMNAME = "formname";
    private static final String DUPLICATEENTRY = "Duplicate entry";
    private static final String FORMNUMBER = "formNumber";
    private static final String IFNEWPAGE = "ifNewPage";

    public static CustomizedFormBuilderInfo initializedNewCustomizedFormMeta(CustomizedFormBuilderInfo formBuilderInfo) {
        EntityMetadata entityMeta;
        FormMetadata formMeta;
        if (formBuilderInfo == null) {
            throw new IllegalArgumentException("CustomizedFormBuilderInfo Cannot be Null!");
        }
        if (formBuilderInfo.formNumber == null || formBuilderInfo.bizAppId == null) {
            throw new IllegalArgumentException("Form Number or BizAppID is Null!");
        }
        IFormTemplate formTemplate = formBuilderInfo.formTemplate = FormTemplateFactory.createTemplate((String)formBuilderInfo.formModelType);
        boolean needCreateNewForm = false;
        needCreateNewForm = MetadataDao.checkNumber((String)formBuilderInfo.formNumber) ? !CustomizedDynamicFormBuilderUtil.loadFormModelMeta(formBuilderInfo) : true;
        if (needCreateNewForm) {
            LocaleString formDisplayName = new LocaleString();
            String formName = formBuilderInfo.formName;
            formDisplayName.setLocaleValue(formName);
            formDisplayName.setLocaleValue_zh_CN(formName);
            formDisplayName.setLocaleValue_en(formName);
            formDisplayName.setLocaleValue_zh_TW(formName);
            formDisplayName.setItem("GLang", (Object)formName);
            formMeta = formBuilderInfo.formMeta = formTemplate.getFormMetadata();
            formMeta.setBizappId(formBuilderInfo.bizAppId);
            formMeta.setKey(formBuilderInfo.formNumber);
            formMeta.setName(formDisplayName);
            formMeta.setIsv(ISVService.getISVInfo().getId());
            formMeta.setIsvSign(ISVService.getIsvSign((String)formBuilderInfo.formNumber));
            formMeta.setDevType("0");
            entityMeta = formBuilderInfo.entityMeta = formTemplate.getEntityMetadata();
            if (!entityMeta.getItems().isEmpty() && entityMeta.getItems().get(0) instanceof BaseEntity) {
                BaseEntity baseEntity = (BaseEntity)entityMeta.getItems().get(0);
                baseEntity.setNumberFieldId(formBuilderInfo.formNumber);
                baseEntity.setNameFieldId(formBuilderInfo.formName);
                baseEntity.setName(new LocaleString(formBuilderInfo.formName));
            }
            entityMeta.setBizappId(formBuilderInfo.bizAppId);
            entityMeta.setEnabled(true);
            entityMeta.setId(formMeta.getId());
            entityMeta.setKey(formBuilderInfo.formNumber);
            entityMeta.setName(formDisplayName);
            entityMeta.setIsv(ISVService.getISVInfo().getId());
            entityMeta.setIsvSign(ISVService.getIsvSign((String)formBuilderInfo.formNumber));
            MainEntity mainEntity = entityMeta.getRootEntity();
            mainEntity.setId(entityMeta.getId());
            mainEntity.setKey(formBuilderInfo.formNumber);
            mainEntity.setTableName("t_" + formBuilderInfo.formNumber);
            mainEntity.setName(formDisplayName);
            mainEntity.getBusinessControl().setEnableImport(false);
            if (kd.bos.util.StringUtils.isNotEmpty((String)formBuilderInfo.bizAppId)) {
                DynamicObject bizapp = BusinessDataServiceHelper.loadSingle((Object)formBuilderInfo.bizAppId, (String)"bos_devportal_bizapp");
                formBuilderInfo.dbRoute = bizapp.getString("dbroute");
                mainEntity.setdbRoute(formBuilderInfo.dbRoute);
            }
            formMeta.createIndex();
            entityMeta.createIndex();
            formMeta.setEntityId(formMeta.getId());
        } else {
            formBuilderInfo.dbRoute = formBuilderInfo.mainEntity.getdbRoute();
            formMeta = formBuilderInfo.formMeta;
            entityMeta = formBuilderInfo.entityMeta;
        }
        formMeta.bindEntityMetadata(entityMeta);
        return formBuilderInfo;
    }

    public static CustomizedFormBuilderInfo createCustomizedFormBuilderInfo(String formNumber, String formName, String bizAppId, String formModelType) {
        return CustomizedDynamicFormBuilderUtil.initializedNewCustomizedFormMeta(new CustomizedFormBuilderInfo(formNumber, formName, bizAppId, formModelType));
    }

    public static boolean loadFormModelMeta(CustomizedFormBuilderInfo formBuilderInfo) {
        boolean result = true;
        try {
            String metaid = MetadataDao.getIdByNumber((String)formBuilderInfo.formNumber, (MetaCategory)MetaCategory.Entity);
            formBuilderInfo.entityMeta = (EntityMetadata)MetadataDao.readMeta((String)metaid, (MetaCategory)MetaCategory.Entity);
            formBuilderInfo.formMeta = (FormMetadata)MetadataDao.readMeta((String)metaid, (MetaCategory)MetaCategory.Form);
            formBuilderInfo.mainEntity = formBuilderInfo.entityMeta.getRootEntity();
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    protected static String arrayToString(Object[] srcArray, boolean skipEmpty, char delimeter) {
        StringBuilder buf = new StringBuilder();
        for (Object obj : srcArray) {
            String strBuf;
            if (obj == null) {
                if (skipEmpty) continue;
                strBuf = "";
            } else {
                strBuf = obj.toString().trim();
            }
            buf.append(delimeter).append(strBuf);
        }
        return buf.toString().substring(1);
    }

    protected static String arrayToString(Object[] srcArray) {
        return CustomizedDynamicFormBuilderUtil.arrayToString(srcArray, true, ',');
    }

    public static int createTableIndex(String dbRouterKey, String indexName, String tableName, String ... fields) {
        if (dbRouterKey == null || indexName == null || tableName == null || fields == null || fields.length < 1) {
            return -1;
        }
        DBRoute dbRouter = DBRoute.of((String)dbRouterKey);
        if (!DB.exitsIndex((DBRoute)dbRouter, (String)tableName, (String)indexName)) {
            DB.execute((DBRoute)dbRouter, (String)String.format("create index %s on %s (%s);", indexName, tableName, CustomizedDynamicFormBuilderUtil.arrayToString(fields)));
            return 1;
        }
        return 0;
    }

    public static Map<String, Object> SaveEntityPage(CustomizedFormBuilderInfo formBuilderInfo, Boolean ifNewPage) {
        Throwable throwable;
        TXHandle tx;
        String formId;
        HashMap<String, Object> message;
        block25: {
            HashMap<String, Object> hashMap;
            block26: {
                block27: {
                    StringBuilder errorMsg;
                    message = new HashMap<String, Object>();
                    formId = null;
                    if (Boolean.TRUE.equals(ifNewPage) && StringUtils.isNotBlank((CharSequence)(errorMsg = PageBuilder.validateNameAndNumber((String)formBuilderInfo.formNumber, (ILocaleString)new LocaleString(formBuilderInfo.formName), (boolean)false)).toString())) {
                        message.put(ISVCHECKRESULT, Boolean.FALSE);
                        message.put(MESSAGE, errorMsg.toString());
                        return message;
                    }
                    tx = TX.required((String)MDL_DEVPORTALUTIL_BUILDNEWPAGE);
                    throwable = null;
                    Map save = new DesignerData().save(formBuilderInfo.buildFormDesignerDataMap("zh_CN"));
                    if (save.get(SUCCESS) == null || ((Boolean)save.get(SUCCESS)).booleanValue() || save.get(ERRORS) == null) break block25;
                    message.put(SUCCESS, Boolean.FALSE);
                    message.put(MESSAGE, ((ErrorInfo)((ArrayList)save.get(ERRORS)).get(0)).getError());
                    hashMap = message;
                    if (tx == null) break block26;
                    if (throwable == null) break block27;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block26;
                }
                tx.close();
            }
            return hashMap;
        }
        try {
            try {
                DynamicObject dObject;
                formId = formBuilderInfo.getFormMeta().getId();
                AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"CustomizedDynamicFormBuilderUtil_0", (String)"macc-faf-common", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u52a8\u6001\u521b\u5efa\u5143\u6570\u636e", (String)"CustomizedDynamicFormBuilderUtil_1", (String)"macc-faf-common", (Object[])new Object[0]));
                if (Boolean.TRUE.equals(ifNewPage)) {
                    dObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVPORTAL_UNITRELFORM);
                } else {
                    QFilter filter = new QFilter("form", "=", (Object)formId);
                    dObject = BusinessDataServiceHelper.loadSingle((String)BOS_DEVPORTAL_UNITRELFORM, (QFilter[])filter.toArray());
                    if (dObject == null) {
                        dObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVPORTAL_UNITRELFORM);
                    }
                }
                if (dObject != null) {
                    dObject.set(BIZAPP, (Object)formBuilderInfo.getBizAppId());
                    dObject.set(BIZUNIT, (Object)(kd.bos.util.StringUtils.isEmpty((String)formBuilderInfo.getBizUnitId()) ? "2XF5B1YXIBCY" : formBuilderInfo.getBizUnitId()));
                    dObject.set("form", (Object)formId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                    AppUtils.addLog((String)BOS_FORMMETA, (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"CustomizedDynamicFormBuilderUtil_0", (String)"macc-faf-common", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u8868\u5355\u548c\u529f\u80fd\u5206\u7ec4\u7684\u5173\u8054\u5173\u7cfb", (String)"CustomizedDynamicFormBuilderUtil_2", (String)"macc-faf-common", (Object[])new Object[0]));
                }
                message.put(FORMID, formId);
                message.put(FORMNAME, formBuilderInfo.getFormName());
                message.put(SUCCESS, Boolean.TRUE);
                message.put(MESSAGE, ResManager.loadKDString((String)"\u521b\u5efa\u6210\u529f\u3002", (String)"CustomizedDynamicFormBuilderUtil_3", (String)"macc-faf-common", (Object[])new Object[0]));
            }
            catch (NullPointerException exception) {
                logger.error((Throwable)exception);
                tx.markRollback();
                message.put(SUCCESS, Boolean.FALSE);
                String msg = ExceptionUtils.getStackTrace((Throwable)exception);
                if (msg.contains(DUPLICATEENTRY)) {
                    msg = String.format(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u7f16\u53f7\u3010%1$s\u3011\u5728\u8fd0\u884c\u671f\u8868\u4e2d\u5b58\u5728\u5783\u573e\u5143\u6570\u636e\uff0c\u8bf7\u5148\u624b\u52a8\u6e05\u9664\u3002\u8be6\u60c5\uff1a%2$s", (String)"CustomizedDynamicFormBuilderUtil_4", (String)"macc-faf-common", (Object[])new Object[0]), formId, msg);
                }
                message.put(MESSAGE, msg);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                message.put(SUCCESS, Boolean.FALSE);
                String msg = ExceptionUtils.getStackTrace((Throwable)e);
                if (e.getMessage().contains(DUPLICATEENTRY)) {
                    msg = String.format(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u7f16\u53f7\u3010%1$s\u3011\u5728\u8fd0\u884c\u671f\u8868\u4e2d\u5b58\u5728\u5783\u573e\u5143\u6570\u636e\uff0c\u8bf7\u5148\u624b\u52a8\u6e05\u9664\u3002\u8be6\u60c5\uff1a%2$s", (String)"CustomizedDynamicFormBuilderUtil_4", (String)"macc-faf-common", (Object[])new Object[0]), formId, msg);
                }
                message.put(MESSAGE, msg);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        message.put(FORMNUMBER, formBuilderInfo.getFormNumber());
        message.put(IFNEWPAGE, ifNewPage);
        return message;
    }

    public static ErrorInfo createTableIndexs(CustomizedFormBuilderInfo formBuilderInfo) {
        if (formBuilderInfo.getTableIndexMap() != null && !formBuilderInfo.getTableIndexMap().isEmpty()) {
            try {
                DynamicObject entityInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityinfo", (String)"tablename", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)formBuilderInfo.getFormNumber())});
                if (entityInfo != null && kd.bos.util.StringUtils.isNotEmpty((String)entityInfo.getString("tablename"))) {
                    String tableName = entityInfo.getString("tablename");
                    for (Map.Entry<String, String> en : formBuilderInfo.getTableIndexMap().entrySet()) {
                        String value = en.getValue();
                        String[] splits = value.split(",");
                        if (kd.bos.util.StringUtils.isEmpty((String)en.getValue())) continue;
                        CustomizedDynamicFormBuilderUtil.createTableIndex(formBuilderInfo.dbRoute, en.getKey(), tableName, splits);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new ErrorInfo(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7d22\u5f15\u5931\u8d25: %s", (String)"CustomizedDynamicFormBuilderUtil_5", (String)"macc-faf-common", (Object[])new Object[0]), e.getMessage()));
            }
        }
        return null;
    }

    public static boolean checkDesignerDataSaveResult(CustomizedFormBuilderInfo builderInfo, Map<String, Object> saveResult, boolean throwException) {
        String errInfos;
        boolean saveStatus = (Boolean)saveResult.getOrDefault(SUCCESS, Boolean.FALSE);
        boolean ifNewPage = (Boolean)saveResult.getOrDefault(IFNEWPAGE, Boolean.FALSE);
        String string = errInfos = saveResult.get(MESSAGE) == null ? "" : saveResult.get(MESSAGE).toString();
        if (saveStatus) {
            ErrorInfo indexError = CustomizedDynamicFormBuilderUtil.createTableIndexs(builderInfo);
            if (indexError != null) {
                saveResult.computeIfAbsent(MESSAGE, n -> indexError.getError());
            }
        } else if (ifNewPage && kd.bos.util.StringUtils.isNotEmpty((String)errInfos) && throwException) {
            if (saveResult.get(FORMNUMBER) != null && kd.bos.util.StringUtils.isNotEmpty((String)saveResult.get(FORMNUMBER).toString())) {
                String sql = "SELECT FID FROM T_META_FORMDESIGN WHERE FNUMBER = ?";
                Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, saveResult.get(FORMNUMBER))};
                try {
                    List formPKs = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
                        ArrayList<String> list = new ArrayList<String>(1);
                        while (rs.next()) {
                            list.add(rs.getString(1));
                        }
                        return list;
                    });
                    if (formPKs != null && !formPKs.isEmpty()) {
                        CustomizedDynamicFormBuilderUtil.deleteForm((String)formPKs.get(0), builderInfo.getBizUnitId(), builderInfo.getBizAppId());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new KDException(new ErrorCode("checkDesignerDataSaveResult", errInfos), new Object[]{errInfos});
        }
        if (!saveStatus && throwException) {
            throw new KDException(new ErrorCode("checkDesignerDataSaveResult", errInfos), new Object[]{errInfos});
        }
        return saveStatus;
    }

    public static boolean checkDesignerDataSaveResult(Map<String, Object> saveResult) {
        return CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult(null, saveResult, false);
    }

    public static void setFieldAp(FieldAp fieldAp, AbstractElement field, String panelid, int index) {
        CustomizedDynamicFormBuilderUtil.setFieldAp(fieldAp, field, panelid);
        fieldAp.setIndex(index);
    }

    public static void setFieldAp(FieldAp fieldAp, AbstractElement field, String panelid, String lockConfigString) {
        fieldAp.setId(field.getId());
        fieldAp.setFieldId(field.getId());
        fieldAp.setKey(field.getKey());
        fieldAp.setName(field.getName());
        fieldAp.setField((Field)field);
        fieldAp.setParentId(panelid);
        fieldAp.setLock(lockConfigString);
    }

    public static void setFieldAp(FieldAp fieldAp, AbstractElement field, String panelid) {
        CustomizedDynamicFormBuilderUtil.setFieldAp(fieldAp, field, panelid, "submit,audit,edit");
    }

    public static FieldAp createBasePropFields(Class<? extends Field> fieldTypeClass, String fieldNumber, String fieldName, String basePropEntityName, String parentId, EntityMetadata entityMeta, String basePanelId, int fieldIndex, String assistTypeId, List<RefProp> refProps) {
        Field field;
        try {
            field = fieldTypeClass.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
        field.setEnableNull(fieldTypeClass.isAssignableFrom(DecimalField.class));
        if (fieldTypeClass.isAssignableFrom(DecimalField.class)) {
            ((DecimalField)field).setPrecision(38);
        }
        field.setId(Uuid8.generateShortUuid());
        field.setKey(fieldNumber);
        field.setFieldName("f" + fieldNumber);
        field.setName(new LocaleString(fieldName));
        field.setParentId(parentId);
        field.setEntityMetadata(entityMeta);
        field.setMustInput(true);
        if (kd.bos.util.StringUtils.isNotEmpty((String)basePropEntityName)) {
            if (BasedataField.class.equals(fieldTypeClass)) {
                BasedataField basedataField = (BasedataField)field;
                basedataField.setDisplayProp("name");
                basedataField.setBaseEntityId(MetadataDao.getIdByNumber((String)basePropEntityName, (MetaCategory)MetaCategory.Entity));
                if (refProps != null) {
                    basedataField.getRefProps().addAll(refProps);
                }
            } else if (AssistantField.class.equals(fieldTypeClass) && kd.bos.util.StringUtils.isNotEmpty((String)assistTypeId)) {
                ((AssistantField)field).setDisplayProp("name");
                ((AssistantField)field).setAsstTypeId(assistTypeId);
            }
        }
        entityMeta.getItems().add(field);
        FieldAp filedAp = new FieldAp();
        CustomizedDynamicFormBuilderUtil.setFieldAp(filedAp, (AbstractElement)field, basePanelId, fieldIndex);
        return filedAp;
    }

    public static Set<String> getEntityProperties(String entityNumber, Set<String> includePropNames, boolean lowcase, Class ... includePropDataTypes) {
        LinkedHashSet<String> resultList = new LinkedHashSet<String>();
        HashSet<Class> dataTypeFilter = new HashSet<Class>();
        if (includePropDataTypes != null) {
            dataTypeFilter.addAll(Arrays.asList(includePropDataTypes));
        }
        boolean needPropNameFilter = includePropNames != null && !includePropNames.isEmpty();
        boolean needPropDataTypeFilter = !dataTypeFilter.isEmpty();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (IDataEntityProperty prop : entityType.getProperties()) {
            String propNumber = prop.getName();
            boolean needAdd = false;
            if (!needPropNameFilter && !needPropDataTypeFilter) {
                needAdd = true;
            } else {
                needAdd = !needPropDataTypeFilter || dataTypeFilter.contains(prop.getPropertyType());
                if (needAdd) {
                    boolean bl = needAdd = !needPropNameFilter || includePropNames.contains(propNumber);
                }
            }
            if (!needAdd) continue;
            resultList.add(lowcase ? propNumber.toLowerCase() : propNumber);
        }
        return resultList;
    }

    public static Set<String> getEntityProperties(String entityNumber, Set<String> includePropNames, Class ... includePropDataTypes) {
        return CustomizedDynamicFormBuilderUtil.getEntityProperties(entityNumber, includePropNames, true, includePropDataTypes);
    }

    public static void deleteForm(String targetEntityNumber, boolean dropR3) {
        List formPKs;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
        String sql = "SELECT FID FROM T_META_FORMDESIGN WHERE FNUMBER = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)targetEntityNumber)};
        try {
            formPKs = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
                ArrayList<String> list = new ArrayList<String>(1);
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                return list;
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            logger.error(msg + "\n" + e.getMessage());
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (entityType != null) {
            try {
                boolean dropResult;
                if (dropR3) {
                    try {
                        dropResult = !DB.execute((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)String.format("select 1 from %s_r3;", entityType.getAlias()));
                    }
                    catch (Exception e) {
                        dropResult = false;
                    }
                    if (dropResult) {
                        dropResult = !DB.execute((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)String.format("drop table %s_r3;", entityType.getAlias()));
                        logger.info(String.format("drop table %s_r3; Result = %s", entityType.getAlias(), dropResult));
                    }
                }
                dropResult = !DB.execute((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)String.format("drop table %s;", entityType.getAlias()));
                logger.info(String.format("drop table %s; Result = %s", entityType.getAlias(), dropResult));
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
                throw ex;
            }
        }
        if (formPKs != null && !formPKs.isEmpty()) {
            if (entityType != null && "faf".equals(entityType.getAppId())) {
                CustomizedDynamicFormBuilderUtil.deleteForm((String)formPKs.get(0), "2XF5B1YXIBCY", "2UK0B8T0A=WJ");
            } else {
                CustomizedDynamicFormBuilderUtil.deleteForm((String)formPKs.get(0), "2A=FHWYEOC9I", "RPHRHCNZ0Z2");
            }
        }
    }

    public static void deleteForm(String formId, String unitId, String appId) {
        Map result = DevportalUtil.deletePage((String)formId, (String)unitId, (Boolean)Boolean.FALSE, (String)appId, (String)"0", (String)"PAGE_TYPE", (String)BOS_FORMMETA);
        if (!(result == null || result.get(MESSAGE) == null || result.get(SUCCESS) != null && ((Boolean)result.get(SUCCESS)).booleanValue())) {
            logger.error("deleteForm\uff1a" + result.get(MESSAGE) + (result.get("rebuildruntimemeta") != null ? ",rebuildruntimemeta:" + result.get("rebuildruntimemeta").toString() : ""));
            throw new KDBizException(result.get(MESSAGE).toString() + (result.get("rebuildruntimemeta") != null ? ",rebuildruntimemeta:" + result.get("rebuildruntimemeta").toString() : ""));
        }
    }

    public static void updateDefaultValue(String tableNumber, String fieldNumber, String dbRouteKey) {
        try {
            if (kd.bos.util.StringUtils.isNotEmpty((String)fieldNumber)) {
                Set fieldNumbers = Arrays.stream(fieldNumber.split(",")).collect(Collectors.toSet());
                StringBuilder updateSql = new StringBuilder("update t_").append(tableNumber).append(" set ");
                int i = 1;
                for (String number : fieldNumbers) {
                    if (i < fieldNumbers.size()) {
                        updateSql.append(" f").append(number).append(" = 0,");
                    } else {
                        updateSql.append(" f").append(number).append(" = 0;");
                    }
                    ++i;
                }
                DB.execute((DBRoute)DBRoute.of((String)dbRouteKey), (String)updateSql.toString());
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static boolean judgeExistField(String entityNumber, String fieldNumber) {
        CustomizedFormBuilderInfo builderInfo = CustomizedDynamicFormBuilderUtil.createCustomizedFormBuilderInfo(entityNumber, "", "2UK0B8T0A=WJ", "BaseFormModel");
        EntityMetadata entityMeta = builderInfo.getEntityMeta();
        List items = entityMeta.getItems();
        return items.stream().map(AbstractElement::getKey).anyMatch(k -> k.equals(fieldNumber));
    }
}

