/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.entity.property.RefProp;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.StringUtils;
import kd.macc.faf.util.CustomizedDynamicFormBuilderUtil;

public class CustomizedFormBuilderInfo
implements Serializable {
    private static final long serialVersionUID = 3353447205684514804L;
    protected IFormTemplate formTemplate;
    protected String formNumber;
    protected String formName;
    protected FormMetadata formMeta;
    protected EntityMetadata entityMeta;
    protected MainEntity mainEntity;
    protected String entityMetaId;
    protected String formModelType;
    protected String dbRoute;
    protected boolean isDeveloper;
    protected String bizAppId;
    protected String bizUnitId;
    protected Map<String, String> tableIndexMap;
    private boolean changed = false;

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public CustomizedFormBuilderInfo(String formNumber, String formName, String bizAppId) {
        this(formNumber, formName, bizAppId, "BillFormModel");
    }

    public CustomizedFormBuilderInfo(String formNumber, String formName, String bizAppId, String formModelType) {
        this.formNumber = formNumber;
        this.formName = formName;
        this.formModelType = formModelType;
        this.bizAppId = bizAppId;
    }

    public String toString() {
        return "CustomizedFormBuilderInfo [formTemplate=" + this.formTemplate + ", formNumber=" + this.formNumber + ", formName=" + this.formName + ", formMeta=" + this.formMeta + ", entityMeta=" + this.entityMeta + ", mainEntity=" + this.mainEntity + ", entityMetaId=" + this.entityMetaId + ", formModelType=" + this.formModelType + ", dbRoute=" + this.dbRoute + ", isDeveloper=" + this.isDeveloper + ", bizAppId=" + this.bizAppId + "]";
    }

    public Map<String, Object> buildFormDesignerDataMap(String lang) {
        return this.formMeta.buildDesignMeta(lang);
    }

    public FormAp getFormRootAp() {
        return this.formMeta != null ? this.formMeta.getRootAp() : null;
    }

    public FieldAp addDateField(String fieldNumber, String fieldName, String defaultValue) {
        FieldAp ap = this.addField(DateField.class, fieldNumber, fieldName, null);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            ((DateField)ap.getField()).setDefValue(defaultValue);
        }
        return ap;
    }

    public FieldAp addDecimalField(String fieldNumber, String fieldName, String defaultValue) {
        FieldAp ap = this.addField(DecimalField.class, fieldNumber, fieldName, null);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            ((DecimalField)ap.getField()).setDefValue(new BigDecimal(defaultValue));
        }
        return ap;
    }

    public FieldAp addTextField(String fieldNumber, String fieldName, int maxLength, String defaultValue) {
        FieldAp ap = this.addField(TextField.class, fieldNumber, fieldName, null);
        TextField textField = (TextField)ap.getField();
        textField.setMaxLength(maxLength);
        textField.setMinLength(0);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            textField.setDefValue(defaultValue);
        }
        return ap;
    }

    public FieldAp addBigIntField(String fieldNumber, String fieldName, String defaultValue) {
        FieldAp ap = this.addField(BigIntField.class, fieldNumber, fieldName, null);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            ((BigIntField)ap.getField()).setDefValue(new BigDecimal(defaultValue));
        }
        return ap;
    }

    public FieldAp addIntegerField(String fieldNumber, String fieldName, String defaultValue) {
        FieldAp ap = this.addField(IntegerField.class, fieldNumber, fieldName, null);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            ((IntegerField)ap.getField()).setDefValue(new BigDecimal(defaultValue));
        }
        return ap;
    }

    public FieldAp addComboField(String fieldNumber, String fieldName, String defaultValue, Map<String, String> itemMap) {
        FieldAp ap = this.addField(ComboField.class, fieldNumber, fieldName, null);
        ComboField comboField = (ComboField)ap.getField();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(itemMap.size());
        int i = 0;
        for (Map.Entry<String, String> item : itemMap.entrySet()) {
            comboItems.add(new ComboItem(i++, new LocaleString(item.getKey()), item.getValue()));
        }
        comboField.setItems(comboItems);
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            comboField.setDefValue(defaultValue);
        }
        return ap;
    }

    public FieldAp addField(Class<? extends Field> fieldTypeClass, String fieldNumber, String fieldName, String basePropEntityName) {
        int fieldIndex = this.formMeta != null && this.formMeta.getItems() != null ? this.formMeta.getItems().size() : 0;
        return CustomizedDynamicFormBuilderUtil.createBasePropFields(fieldTypeClass, fieldNumber, fieldName, basePropEntityName, this.getFormRootAp().getId(), this.entityMeta, this.getFormRootAp().getId(), fieldIndex, null, null);
    }

    public FieldAp addField(Class<? extends Field> fieldTypeClass, String fieldNumber, String fieldName, String basePropEntityName, String assistTypeId, List<RefProp> refProps) {
        int fieldIndex = this.formMeta != null && this.formMeta.getItems() != null ? this.formMeta.getItems().size() : 0;
        return CustomizedDynamicFormBuilderUtil.createBasePropFields(fieldTypeClass, fieldNumber, fieldName, basePropEntityName, this.getFormRootAp().getId(), this.entityMeta, this.getFormRootAp().getId(), fieldIndex, assistTypeId, refProps);
    }

    public String getFormNumber() {
        return this.formNumber;
    }

    public String getFormName() {
        return this.formName;
    }

    public FormMetadata getFormMeta() {
        return this.formMeta;
    }

    public EntityMetadata getEntityMeta() {
        return this.entityMeta;
    }

    public void setDbRoute(String dbRoute) {
        this.dbRoute = dbRoute;
    }

    public void setDeveloper(boolean isDeveloper) {
        this.isDeveloper = isDeveloper;
    }

    public String getBizAppId() {
        return this.bizAppId;
    }

    public String getBizUnitId() {
        return this.bizUnitId;
    }

    public void setBizUnitId(String bizUnitId) {
        this.bizUnitId = bizUnitId;
    }

    public Map<String, String> getTableIndexMap() {
        return this.tableIndexMap;
    }

    public void setTableIndexMap(Map<String, String> tableIndexMap) {
        this.tableIndexMap = tableIndexMap;
    }

    public String getDbRoute() {
        return this.dbRoute;
    }
}

