/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class DimensionDyUtil {
    public static Tuple2<String, QFilter[]> getDimensionSourceNumberFromDimension(DynamicObject dynamicObject) {
        String entity;
        if (dynamicObject == null) {
            return null;
        }
        DynamicObject dimensionsource = null;
        String dimensiontype = dynamicObject.getString("dimensiontype");
        DimensionTypeEnum anEnum = DimensionTypeEnum.getEnum(dimensiontype);
        QFilter[] qFilters = null;
        String name = dynamicObject.getString("name");
        if (anEnum == DimensionTypeEnum.DATABASE || anEnum == DimensionTypeEnum.PERIOD) {
            dimensionsource = dynamicObject.getDynamicObject("dimensionsource");
            if (dimensionsource == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\uff08%s\uff09\u672a\u8bbe\u7f6e\u7ef4\u5ea6\u6765\u6e90\u3002", (String)"DimensionDyUtil_0", (String)"macc-faf-common", (Object[])new Object[0]), name));
            }
            entity = dimensionsource.getString("number");
            String typefield = dynamicObject.getString("typefield");
            Object group = dynamicObject.get("group_id");
            if (StringUtils.isNotEmpty((CharSequence)typefield) && group != null) {
                qFilters = new QFilter[]{new QFilter(typefield, "=", group)};
            }
        } else if (anEnum == DimensionTypeEnum.ASSISTANTDATA) {
            dimensionsource = dynamicObject.getDynamicObject("assistantsource");
            if (dimensionsource == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\uff08%s\uff09\u672a\u8bbe\u7f6e\u7ef4\u5ea6\u6765\u6e90\u3002", (String)"DimensionDyUtil_0", (String)"macc-faf-common", (Object[])new Object[0]), name));
            }
            entity = "bos_assistantdata_detail";
            qFilters = new QFilter[]{new QFilter("group", "=", (Object)dimensionsource.getLong("id"))};
        } else {
            return null;
        }
        return new Tuple2((Object)entity, qFilters);
    }

    public static DimensionTypeEnum getDimensionTypeFromNess(Long modelId, DimensionNecessityEnum dimensionNecessityEnum) {
        Map<DimensionNecessityEnum, DimensionTypeEnum> dimensiontype1 = DimensionDyUtil.loopDoDimensionNecessity(modelId, (DynamicObject dynamicObject) -> {
            String dimensiontype = (String)dynamicObject.get("dimensiontype");
            DimensionTypeEnum anEnum = DimensionTypeEnum.getEnum(dimensiontype);
            return anEnum;
        });
        return dimensiontype1.get((Object)dimensionNecessityEnum);
    }

    public static DimensionTypeEnum getDimensionTypeCodeFromNess(Long modelId, DimensionNecessityEnum dimensionNecessityEnum) {
        Map<DimensionNecessityEnum, DimensionTypeEnum> dimensiontype1 = DimensionDyUtil.loopDoDimensionNecessity(modelId, (DynamicObject dynamicObject) -> {
            String dimensiontype = (String)dynamicObject.get("dimensiontype");
            DimensionTypeEnum anEnum = DimensionTypeEnum.getCode(dimensiontype);
            return anEnum;
        });
        return dimensiontype1.get((Object)dimensionNecessityEnum);
    }

    public static DimensionTypeEnum getDimensionTypeCodeFromNess(DynamicObject dynamicObjects, DimensionNecessityEnum dimensionNecessityEnum) {
        Map<DimensionNecessityEnum, DimensionTypeEnum> dimensiontype1 = DimensionDyUtil.loopDoDimensionNecessity(dynamicObjects, (DynamicObject dynamicObject) -> {
            String dimensiontype = (String)dynamicObject.get("dimensiontype");
            DimensionTypeEnum anEnum = DimensionTypeEnum.getCode(dimensiontype);
            return anEnum;
        });
        return dimensiontype1.get((Object)dimensionNecessityEnum);
    }

    public static <T> Map<DimensionNecessityEnum, T> loopDoDimensionNecessity(Long modelId, Function<DynamicObject, T> function) {
        DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        return DimensionDyUtil.loopDoDimensionNecessity(dynamicObjects, function);
    }

    public static <T> Map<DimensionNecessityEnum, T> loopDoDimensionNecessity(DynamicObject dynamicObjects, Function<DynamicObject, T> function) {
        if (dynamicObjects == null) {
            return Collections.emptyMap();
        }
        HashMap<DimensionNecessityEnum, T> map = new HashMap<DimensionNecessityEnum, T>(3);
        DynamicObjectCollection dimension_entry = dynamicObjects.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dynamicObject : dimension_entry) {
            String necessity_dim = dynamicObject.getString("necessity_dim");
            DynamicObject dimension = dynamicObject.getDynamicObject("dimension");
            DimensionNecessityEnum anEnum = DimensionNecessityEnum.getEnum(necessity_dim);
            if (anEnum == null) continue;
            T apply = function.apply(dimension);
            map.put(anEnum, apply);
        }
        return map;
    }
}

