/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.formula.platform.api.FuncInfo;
import kd.bos.formula.platform.api.IFormulaFunctions;
import kd.bos.kscript.KScriptException;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;

public class FAFFormulaFunctions
implements IFormulaFunctions {
    private Map<String, FAFFuncInfo> funcInfo = new LinkedHashMap<String, FAFFuncInfo>();

    public FAFFormulaFunctions() {
        Method[] methods;
        for (Method method : methods = this.getClass().getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            int modifiers = method.getModifiers();
            int parameterCount = method.getParameterCount();
            Class<?> returnType = method.getReturnType();
            if (modifiers != 2 || parameterCount != 1 || returnType != Object.class || (parameterTypes = method.getParameterTypes()).length != 1 || parameterTypes[0] != List.class) continue;
            this.funcInfo.put(method.getName().toLowerCase(), new FAFFuncInfo(method.getName(), "", "", "OTHER", "", method));
        }
    }

    public boolean existFunction(String funcName) {
        if (funcName == null) {
            return false;
        }
        return this.funcInfo.containsKey(funcName.toLowerCase());
    }

    public String[] getAllFuncNames() {
        return this.funcInfo.keySet().toArray(new String[0]);
    }

    public String getFuncCategory(String funcName) {
        if (funcName == null || !this.funcInfo.containsKey(funcName)) {
            return null;
        }
        return this.funcInfo.get(funcName).getFuncCatetory();
    }

    public String getFuncDesc(String funcName) {
        if (funcName == null || !this.funcInfo.containsKey(funcName)) {
            return null;
        }
        return this.funcInfo.get(funcName).getFuncDesc();
    }

    public String getFuncCaption(String funcName) {
        if (funcName == null || !this.funcInfo.containsKey(funcName)) {
            return null;
        }
        return this.funcInfo.get(funcName).getFuncCaption();
    }

    public String getFuncFormula(String funcName) {
        if (funcName == null || !this.funcInfo.containsKey(funcName)) {
            return null;
        }
        return this.funcInfo.get(funcName).getFuncFormula();
    }

    public String getParaFormId(String funcName) {
        if (funcName == null || !this.funcInfo.containsKey(funcName)) {
            return null;
        }
        return this.funcInfo.get(funcName).getParaFormId();
    }

    public Object evalFunction(String funcName, List list) throws KScriptException {
        if (funcName == null) {
            throw new KScriptException("funcName is null");
        }
        FAFFuncInfo funcInfo = this.funcInfo.get(funcName.toLowerCase());
        if (funcInfo == null) {
            throw new KScriptException(String.format("%s function not found!", funcName));
        }
        try {
            Method method = funcInfo.getMethod();
            return method.invoke((Object)this, list);
        }
        catch (Exception ex) {
            throw new KScriptException(ex.toString(), (Throwable)ex);
        }
    }

    private Object newArray(List param) {
        return param;
    }

    private Object arrayIn(List param) throws KScriptException {
        if (param.size() != 2) {
            throw new KScriptException("parameters error");
        }
        Object o = param.get(0);
        o = o instanceof OrmLocaleValue ? o.toString() : o;
        Object checkList = param.get(1);
        if (checkList instanceof List) {
            return ((List)checkList).contains(o);
        }
        throw new KScriptException("parameters error");
    }

    private DateFormat getDateFormat() {
        return KDDateFormatUtils.getDateFormat();
    }

    private DateFormat getDateTimeFormat() {
        return KDDateFormatUtils.getDateTimeFormat();
    }

    private Object parseDate(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        String dateStr = String.valueOf(param.get(0));
        try {
            return this.getDateFormat().parse(dateStr);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Object parseDateTime(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        String dateStr = String.valueOf(param.get(0));
        try {
            return this.getDateTimeFormat().parse(dateStr);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Object isToday(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        Object o = param.get(0);
        DateFormat dateFormat = this.getDateFormat();
        String checkDate = dateFormat.format(KDDateUtils.today());
        String paramDate = "";
        if (o instanceof Date) {
            paramDate = dateFormat.format((Date)o);
        } else {
            try {
                paramDate = dateFormat.format(dateFormat.parse(String.valueOf(o)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return checkDate.equals(paramDate);
    }

    private Object isYesterday(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        Object o = param.get(0);
        DateFormat dateFormat = this.getDateFormat();
        String checkDate = dateFormat.format(KDDateUtils.addDays((Date)KDDateUtils.today(), (int)-1));
        String paramDate = "";
        if (o instanceof Date) {
            paramDate = dateFormat.format((Date)o);
        } else {
            try {
                paramDate = dateFormat.format(dateFormat.parse(String.valueOf(o)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return checkDate.equals(paramDate);
    }

    private Object isTomorrow(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        Object o = param.get(0);
        DateFormat dateFormat = this.getDateFormat();
        String checkDate = dateFormat.format(KDDateUtils.addDays((Date)KDDateUtils.today(), (int)1));
        String paramDate = "";
        if (o instanceof Date) {
            paramDate = dateFormat.format((Date)o);
        } else {
            try {
                paramDate = dateFormat.format(dateFormat.parse(String.valueOf(o)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return checkDate.equals(paramDate);
    }

    private Object checkDate(Object o, Date startDate, Date endDate) {
        DateFormat dateFormat = this.getDateFormat();
        Date paramDate = null;
        if (o instanceof Date) {
            paramDate = (Date)o;
        } else {
            try {
                paramDate = dateFormat.parse(String.valueOf(o));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (paramDate == null) {
            return Boolean.FALSE;
        }
        return startDate.getTime() <= paramDate.getTime() && paramDate.getTime() < endDate.getTime();
    }

    private Object isThisWeek(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        Object o = param.get(0);
        Date startDate = KDDateUtils.getTheWeekStart((int)0);
        Date endDate = KDDateUtils.getTheWeekEnd((int)0);
        return this.checkDate(o, startDate, endDate);
    }

    private Object isLastWeek(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        Object o = param.get(0);
        Date startDate = KDDateUtils.getTheWeekStart((int)-1);
        Date endDate = KDDateUtils.getTheWeekEnd((int)-1);
        return this.checkDate(o, startDate, endDate);
    }

    private Object isThisMonth(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        Object o = param.get(0);
        Date startDate = KDDateUtils.getTheMonthStart((int)0);
        Date endDate = KDDateUtils.getTheMonthEnd((int)0);
        return this.checkDate(o, startDate, endDate);
    }

    private Object isLastMonth(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        Object o = param.get(0);
        Date startDate = KDDateUtils.getTheMonthStart((int)-1);
        Date endDate = KDDateUtils.getTheMonthEnd((int)-1);
        return this.checkDate(o, startDate, endDate);
    }

    private Object isNextWeek(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        Object o = param.get(0);
        Date startDate = KDDateUtils.getTheWeekStart((int)1);
        Date endDate = KDDateUtils.getTheWeekEnd((int)1);
        return this.checkDate(o, startDate, endDate);
    }

    private Object isNextMonth(List param) throws KScriptException {
        if (param.size() != 1) {
            throw new KScriptException("parameters error");
        }
        Object o = param.get(0);
        Date startDate = KDDateUtils.getTheMonthStart((int)1);
        Date endDate = KDDateUtils.getTheMonthEnd((int)1);
        return this.checkDate(o, startDate, endDate);
    }

    private Object dateDiff(List param) throws KScriptException {
        if (param == null) {
            throw new KScriptException("parameters error");
        }
        if (param.size() < 2) {
            throw new KScriptException("parameters error");
        }
        if (param.size() > 2) {
            throw new KScriptException("parameters error");
        }
        if (param.get(0) == null || param.get(1) == null) {
            return null;
        }
        if (!(param.get(0) instanceof String) && !(param.get(0) instanceof Date) || !(param.get(1) instanceof String) && !(param.get(1) instanceof Date)) {
            throw new KScriptException("parameter value is error");
        }
        Date date1 = null;
        date1 = param.get(0) instanceof Date ? (Date)param.get(0) : FAFFormulaFunctions.convert2Date((String)param.get(0));
        Date date2 = null;
        date2 = param.get(1) instanceof Date ? (Date)param.get(1) : FAFFormulaFunctions.convert2Date((String)param.get(1));
        if (date1 == null || date2 == null) {
            throw new KScriptException("parameters error");
        }
        return TimeUnit.DAYS.convert(date1.getTime() - date2.getTime(), TimeUnit.MILLISECONDS);
    }

    private Object compareDate(List param) throws KScriptException {
        if (param == null) {
            throw new KScriptException("parameters is null");
        }
        if (param.size() != 3) {
            throw new KScriptException("parameters count must be 3");
        }
        if (param.get(0) == null || param.get(1) == null || param.get(2) == null) {
            return null;
        }
        String compareFlag = (String)param.get(2);
        if (!(compareFlag.equals("==") || compareFlag.equals(">") || compareFlag.equals("<") || compareFlag.equals("!=") || compareFlag.equals(">=") || compareFlag.equals("<="))) {
            throw new KScriptException("No 3 parameter is not a comparison operator.");
        }
        String param1 = FAFFormulaFunctions.formatToString(param.get(0));
        String param2 = FAFFormulaFunctions.formatToString(param.get(1));
        int compareResult = param1.compareTo(param2);
        boolean result = false;
        switch (compareFlag) {
            case "==": {
                result = compareResult == 0;
                break;
            }
            case ">": {
                result = compareResult > 0;
                break;
            }
            case "<": {
                result = compareResult < 0;
                break;
            }
            case "!=": {
                result = compareResult != 0;
                break;
            }
            case ">=": {
                result = compareResult >= 0;
                break;
            }
            case "<=": {
                result = compareResult <= 0;
            }
        }
        return result;
    }

    private Object compareBigDecimal(List param) throws KScriptException {
        if (param == null) {
            throw new KScriptException("parameters is null");
        }
        if (param.size() != 3) {
            throw new KScriptException("parameters count must be 3");
        }
        if (param.get(0) == null || param.get(1) == null || param.get(2) == null) {
            return null;
        }
        String compareFlag = (String)param.get(2);
        if (!(compareFlag.equals("==") || compareFlag.equals(">") || compareFlag.equals("<") || compareFlag.equals("!=") || compareFlag.equals(">=") || compareFlag.equals("<="))) {
            throw new KScriptException("No 3 parameter is not a comparison operator.");
        }
        BigDecimal param1 = FAFFormulaFunctions.formatToBigDecimal(param.get(0));
        BigDecimal param2 = FAFFormulaFunctions.formatToBigDecimal(param.get(1));
        int compareResult = param1.compareTo(param2);
        boolean result = false;
        switch (compareFlag) {
            case "==": {
                result = compareResult == 0;
                break;
            }
            case ">": {
                result = compareResult > 0;
                break;
            }
            case "<": {
                result = compareResult < 0;
                break;
            }
            case "!=": {
                result = compareResult != 0;
                break;
            }
            case ">=": {
                result = compareResult >= 0;
                break;
            }
            case "<=": {
                result = compareResult <= 0;
            }
        }
        return result;
    }

    private static Date convert2Date(String dateStr) {
        Date date1 = null;
        try {
            date1 = KDDateFormatUtils.getDateTimeFormat().parse(dateStr);
        }
        catch (ParseException ignore) {
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMdd");
            try {
                date1 = dateformat.parse(dateStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date1;
    }

    private static String formatToString(Object dateParam) {
        if (dateParam instanceof Date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            return simpleDateFormat.format(dateParam);
        }
        if (dateParam instanceof String) {
            String strDate = (String)dateParam;
            strDate = strDate.replaceAll("\\-|/", "");
            return strDate;
        }
        return dateParam.toString();
    }

    private static BigDecimal formatToBigDecimal(Object param) {
        if (param instanceof BigDecimal) {
            return (BigDecimal)param;
        }
        if (param instanceof String) {
            return new BigDecimal((String)param);
        }
        return new BigDecimal(param.toString());
    }

    private static class FAFFuncInfo
    extends FuncInfo {
        private Method method;

        FAFFuncInfo(String name, String caption, String formula, String category, String desc, Method method) {
            super(name, caption, formula, category, desc);
            this.method = method;
        }

        Method getMethod() {
            return this.method;
        }
    }
}

