/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.engine.model.FAFWorkTaskMeta;
import kd.macc.faf.engine.task.IDataAbstractWorkTask;
import kd.macc.faf.engine.task.impl.FAFWorkTaskFactory;
import kd.macc.faf.enums.FAFSyncLogStatusEnum;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.model.impl.IDataMapEntry;

public class FAFTableUtil {
    private static final Log logger = LogFactory.getLog(FAFTableUtil.class);

    public static IDataMapEntry<FAFSyncLogStatusEnum, String> createOrDropTable(Long analysisModelId, FAFWorkTaskTypeEnum taskEnum, String tableNumber, String tableName, Boolean reCreate, boolean onlyDetail) {
        boolean dropTableResult;
        if (taskEnum != FAFWorkTaskTypeEnum.Create_Table_Task && taskEnum != FAFWorkTaskTypeEnum.Drop_Table_Task || analysisModelId == null || analysisModelId == 0L || StringUtils.isBlank((CharSequence)tableNumber)) {
            return new IDataMapEntry<FAFSyncLogStatusEnum, String>(FAFSyncLogStatusEnum.FAILURE, ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5408\u6cd5\u3002", (String)"FAFTableUtil_0", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        tableNumber = tableNumber.toLowerCase();
        if (reCreate.booleanValue() && !(dropTableResult = FAFTableUtil.createOrDropTable(analysisModelId, FAFWorkTaskTypeEnum.Drop_Table_Task, tableNumber, tableName, false))) {
            return new IDataMapEntry<FAFSyncLogStatusEnum, String>(FAFSyncLogStatusEnum.FAILURE, ResManager.loadKDString((String)"\u5220\u8868\u5931\u8d25\u3002", (String)"FAFTableUtil_1", (String)"macc-faf-common", (Object[])new Object[0]));
        }
        Long taskId = analysisModelId;
        FAFWorkTaskMeta taskMeta = new FAFWorkTaskMeta(analysisModelId.toString(), taskId, analysisModelId, taskEnum, true, tableNumber, tableName);
        taskMeta.setOnlyDetailTable(onlyDetail);
        try {
            IDataAbstractWorkTask workTask = FAFWorkTaskFactory.createPAWorkTask(taskEnum.getValue(), taskMeta, false);
            return (IDataMapEntry)workTask.call();
        }
        catch (Exception e) {
            logger.error(taskEnum == FAFWorkTaskTypeEnum.Create_Table_Task ? "\u521b\u5efa" : "\u5220\u9664\u8868\u7684\u540c\u6b65\u4efb\u52a1\u63d0\u4ea4\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    public static boolean createOrDropTable(Long analysisModelId, FAFWorkTaskTypeEnum taskEnum, String tableNumber, String tableName, Boolean reCreate) {
        IDataMapEntry<FAFSyncLogStatusEnum, String> result = FAFTableUtil.createOrDropTable(analysisModelId, taskEnum, tableNumber, tableName, reCreate, false);
        return result != null && FAFSyncLogStatusEnum.SUCCESS == result.getKey();
    }
}

