/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.macc.faf.util.IDataValueUtil;
import org.apache.commons.beanutils.BeanUtilsBean2;
import org.apache.commons.beanutils.ContextClassLoaderLocal;

public class IDataBeanUtil
extends BeanUtilsBean2 {
    private static final ContextClassLoaderLocal<IDataBeanUtil> BEANS_BY_CLASSLOADER = new ContextClassLoaderLocal<IDataBeanUtil>(){

        protected IDataBeanUtil initialValue() {
            return new IDataBeanUtil();
        }
    };

    public static IDataBeanUtil getInstance() {
        return (IDataBeanUtil)((Object)BEANS_BY_CLASSLOADER.get());
    }

    public static void setInstance(IDataBeanUtil newInstance) {
        BEANS_BY_CLASSLOADER.set((Object)newInstance);
    }

    public <A> Field[] getAllNestedFields(Class targetBean) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (targetBean != null) {
            Field[] currentBeanFields = targetBean.getDeclaredFields();
            if (currentBeanFields != null) {
                fieldList.addAll(Arrays.asList(currentBeanFields));
            }
            targetBean = targetBean.getSuperclass();
        }
        return fieldList.toArray(new Field[1]);
    }

    public <A extends Annotation> Field[] getAllNestedAnnotationFields(Class targetBean, Class<A> annotationClass) {
        if (targetBean == null || annotationClass == null) {
            return null;
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (targetBean != null) {
            Field[] currentBeanFields = this.getAnnotationFields(targetBean, annotationClass);
            if (currentBeanFields != null) {
                fieldList.addAll(Arrays.asList(currentBeanFields));
            }
            targetBean = targetBean.getSuperclass();
        }
        return fieldList.toArray(new Field[1]);
    }

    public <A extends Annotation> Field[] getAnnotationFields(Class targetBean, Class<A> annotationClass) {
        if (targetBean == null || annotationClass == null) {
            return null;
        }
        Field[] fields = targetBean.getDeclaredFields();
        if (fields == null || fields.length < 1) {
            return null;
        }
        fields = new Field[fields.length];
        int i = 0;
        for (Field field : targetBean.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            fields[i++] = field;
        }
        Field[] result = null;
        if (i > 0) {
            result = new Field[i];
            System.arraycopy(fields, 0, result, 0, i);
        }
        return result;
    }

    public <A extends Annotation> Field getFirstAnnotationField(Class targetBean, Class<A> annotationClass) {
        Field[] fields = this.getAnnotationFields(targetBean, annotationClass);
        return fields == null || fields.length < 1 ? null : fields[0];
    }

    public <T> Map<String, T> addChildItemToMap(Object targetObject, Object targetObjectId, Map<String, T> targetMap, T childItem, String keyPropertyName, String parentPropertyName, String parentIdPropertyName) throws KDBizException {
        if (childItem == null) {
            return targetMap;
        }
        if (targetMap == null) {
            targetMap = new LinkedHashMap<String, T>();
        }
        try {
            targetMap.put(String.valueOf(this.getSimpleProperty(childItem, keyPropertyName)), childItem);
            if (parentPropertyName != null) {
                this.setProperty(childItem, parentPropertyName, targetObject);
            }
            if (parentIdPropertyName != null) {
                this.setProperty(childItem, parentIdPropertyName, targetObjectId);
            }
            return targetMap;
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getLocalizedMessage()), new Object[0]);
        }
    }

    public static Object invokeGetMethod(Object sourceObj, String propertyName) {
        if (sourceObj == null || propertyName == null) {
            return null;
        }
        try {
            Method method = sourceObj.getClass().getMethod("get" + propertyName, new Class[0]);
            return method.invoke(sourceObj, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object invokeSetMethod(Object sourceObj, String propertyName, Object ... params) {
        if (sourceObj == null || propertyName == null) {
            return null;
        }
        try {
            Class[] classes = null;
            if (params != null && params.length > 0) {
                classes = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    classes[i] = params[i].getClass();
                }
            }
            Method method = sourceObj.getClass().getMethod("set" + propertyName, classes);
            return method.invoke(sourceObj, params);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Method getMethod(Class srcClass, String methodName) {
        if (srcClass == null || methodName == null) {
            return null;
        }
        try {
            return srcClass.getMethod(methodName, new Class[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Method getMethod(Object sourceObj, String methodName) {
        if (sourceObj == null) {
            return null;
        }
        return IDataBeanUtil.getMethod(sourceObj.getClass(), methodName);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Class[%s] not support parameterTypes[%s] Constructor!", clazz, Arrays.toString(parameterTypes)), ex);
        }
    }

    public static <T> T getClassNewInstance(Class<T> classType, Object ... objects) {
        T result;
        if (classType == null) {
            return null;
        }
        try {
            if (objects != null && objects.length > 0) {
                Class[] paramTypes = new Class[objects.length];
                for (int i = 0; i < objects.length; ++i) {
                    paramTypes[i] = objects[i].getClass();
                }
                result = IDataBeanUtil.getConstructor(classType, paramTypes).newInstance(objects);
            } else {
                result = classType.newInstance();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Class[%s] not support parameterTypes[%s] Constructor!", classType, Arrays.toString(objects)), ex);
        }
        return result;
    }

    public static <T> Class<T> getClassByName(String classFullName) {
        if (classFullName == null) {
            return null;
        }
        try {
            return Class.forName(classFullName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Invalid Class Name: %s", classFullName), ex);
        }
    }

    public static <T> Class<T> getClassByName(Object[] valueArray, int accessIndex) {
        return IDataBeanUtil.getClassByName(IDataValueUtil.getString(valueArray, accessIndex));
    }
}

