/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class IDataDateUtil {
    public static final String yyyyMMddHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static final String yyyy_MM_dd_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
    public static final String yyyyMMdd = "yyyyMMdd";

    private static final SimpleDateFormat getDateFormat() {
        return IDataDateUtil.getDateFormat(yyyyMMdd);
    }

    private static final SimpleDateFormat getDateFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static Integer dateToInteger(Date sourceDate) {
        if (sourceDate == null) {
            return null;
        }
        return Integer.valueOf(IDataDateUtil.getDateFormat().format(sourceDate));
    }

    public static String dateToString(Date sourceDate, String pattern) {
        if (sourceDate == null) {
            return null;
        }
        return IDataDateUtil.getDateFormat(pattern).format(sourceDate);
    }

    public static String dateToString(Date sourceDate) {
        return IDataDateUtil.dateToString(sourceDate, yyyyMMdd);
    }

    public static Date stringToDate(String source, String pattern) {
        if (source == null) {
            return null;
        }
        try {
            return IDataDateUtil.getDateFormat(pattern).parse(source);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date stringToDate(String source) {
        return IDataDateUtil.stringToDate(source, yyyyMMdd);
    }

    public static Date truncateDateTime(Date source) {
        if (source == null) {
            return source;
        }
        try {
            SimpleDateFormat formatter = IDataDateUtil.getDateFormat();
            return formatter.parse(formatter.format(source));
        }
        catch (ParseException e) {
            return IDataDateUtil.truncateDate(source);
        }
    }

    public static long getTimeInDay(Date sourceDt) {
        if (sourceDt == null) {
            return -1L;
        }
        return sourceDt.getTime() - IDataDateUtil.truncateDateTime(sourceDt).getTime();
    }

    public static Date getDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day);
        return IDataDateUtil.truncateDateTime(calendar.getTime());
    }

    public static Date getCurrentDate() {
        return IDataDateUtil.truncateDateTime(new Date());
    }

    public static Calendar truncateCalendarTime(Calendar calendar) {
        calendar.clear(11);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        calendar.clear(15);
        calendar.clear(16);
        return calendar;
    }

    public static Date getDateTime(int year, int month, int day, int hour, int min, int sec) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, hour, min, sec);
        calendar.clear(14);
        return calendar.getTime();
    }

    public static int getDateValue(int field, Date sourceDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(sourceDate);
        return calendar.get(field);
    }

    public static Date appendtTime(Date sourceDate, boolean maxTime) {
        return IDataDateUtil.appendtTime(Calendar.getInstance(), sourceDate, maxTime);
    }

    public static Date appendtTime(Calendar calendar, Date sourceDate, boolean maxTime) {
        if (sourceDate != null) {
            calendar.setTime(sourceDate);
        }
        calendar.set(11, maxTime ? 23 : 0);
        calendar.set(12, maxTime ? 59 : 0);
        calendar.set(13, maxTime ? 59 : 0);
        calendar.clear(14);
        return calendar.getTime();
    }

    public static Date appendtTime(Date sourceDate) {
        return IDataDateUtil.appendtTime(sourceDate, false);
    }

    public static Date truncateDate(Date sourceDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        return IDataDateUtil.truncateDate(calendar, sourceDate);
    }

    protected static Date truncateDate(Calendar calendar, Date sourceDate) {
        calendar.setTime(sourceDate);
        calendar.clear(11);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        return calendar.getTime();
    }

    protected static long truncateDateTime(Calendar calendar, Date sourceDate) {
        return IDataDateUtil.truncateDate(calendar, sourceDate).getTime();
    }

    public static boolean isDateInRange(Date checkDate, Date startRange, Date endRange) {
        if (checkDate == null) {
            return false;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        long checkTime = IDataDateUtil.truncateDateTime(calendar, checkDate);
        long startTime = IDataDateUtil.truncateDateTime(calendar, startRange);
        long endTime = IDataDateUtil.truncateDateTime(calendar, endRange);
        return checkTime >= startTime && checkTime <= endTime;
    }

    public static int getMonthPeriodDayCnt(Date sourceDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(sourceDate);
        return calendar.getActualMaximum(5);
    }

    public static int getDayOfMonth(Date sourceDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(sourceDate);
        return calendar.get(5);
    }

    public static String getTimeDiff(Date endDate, Date nowDate) {
        return IDataDateUtil.getTimeDiff(endDate.getTime() - nowDate.getTime());
    }

    public static String getTimeDiff(long diff) {
        long day = diff / 86400000L;
        long hour = diff / 3600000L - day * 24L;
        long min = diff / 60000L - day * 24L * 60L - hour * 60L;
        long s = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long ms = diff - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        StringBuilder executeTime = new StringBuilder();
        executeTime.append(hour <= 9L ? "0" + hour : Long.valueOf(hour)).append(':');
        executeTime.append(min <= 9L ? "0" + min : Long.valueOf(min)).append(':');
        executeTime.append(s <= 9L ? "0" + s : Long.valueOf(s)).append(':');
        executeTime.append(ms < 9L ? "00" + ms : (ms < 99L ? "0" + ms : "" + ms));
        return executeTime.toString();
    }
}

