/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.algox;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FlatMapFunction;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.macc.faf.algox.FAFJoinLinkInfo;
import kd.macc.faf.algox.FAFSQLBuilder;
import kd.macc.faf.algox.XDbOutput;
import kd.macc.faf.datasync.func.FillDimHashFlatMapFunction;
import kd.macc.faf.summary.FAFSummaryDataDTO;
import kd.macc.faf.util.AnalysisModelHashUtil;

public class FAFAlgoX {
    private static final Log logger = LogFactory.getLog(FAFAlgoX.class);

    public static OrmInput createOrmInput(FAFJoinLinkInfo link) {
        return new OrmInput("pa.algox.link" + link.getEntityName(), link.getEntityName(), link.getSelectFields(), link.getQfilters());
    }

    public static DataSetX fillModelDimHash(FAFSummaryDataDTO dto, DataSetX modelDataSetX, boolean isDetail) {
        if (!dto.isModelContainsDimHash()) {
            return modelDataSetX;
        }
        modelDataSetX = modelDataSetX.flatMap((FlatMapFunction)new FillDimHashFlatMapFunction(modelDataSetX.getRowMeta(), AnalysisModelHashUtil.queryModelHashDimension((Long)dto.getmodelId())));
        DataSetX dsXfilterUpdate = modelDataSetX.filter("collectstatus = 99");
        FAFSQLBuilder refUpdateDimHashSQL = null;
        refUpdateDimHashSQL = isDetail ? dto.getUpdateDetailDimHashSQL() : dto.getUpdateSummaryDimHashSQL();
        XDbOutput updateOutput = new XDbOutput("fias", refUpdateDimHashSQL.toUpdateSQL(), refUpdateDimHashSQL.getRowMeta());
        dsXfilterUpdate.select(new String[]{"dimhash", "id", dto.getOrgNumber(), dto.getPeriodNumber()}).output((Output)updateOutput);
        String collectStatus = isDetail ? "0" : "1";
        return modelDataSetX.filter("collectstatus = " + collectStatus);
    }

    public static void fillModelDimHash(FAFSummaryDataDTO dto, QFilter modelFilter, boolean isDetail) {
        if (!dto.isModelContainsDimHash()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        String entityName = null;
        String updateSql = null;
        if (isDetail) {
            entityName = dto.getDetailEntityName();
            updateSql = dto.getUpdateDetailDimHashSQL().toUpdateSQL();
        } else {
            updateSql = dto.getUpdateSummaryDimHashSQL().toUpdateSQL();
            entityName = dto.getEntityName();
        }
        int batchSize = 5000;
        ArrayList<Object[]> params = new ArrayList<Object[]>(batchSize);
        List<String> modelHashDimensionNumberList = dto.getModelHashDimensionNumberList();
        QFilter dimhashEmptyFilter = new QFilter("dimhash", "=", (Object)" ");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryEmptyDimHash", (String)entityName, (String)("id," + String.join((CharSequence)",", dto.getFields_dimension())), (QFilter[])new QFilter[]{modelFilter, dimhashEmptyFilter}, null);){
            for (Row row : ds) {
                params.add(new Object[]{AnalysisModelHashUtil.calculateDimHash((Row)row, modelHashDimensionNumberList), row.getLong("id"), row.getLong(dto.getOrgNumber()), row.getLong(dto.getPeriodNumber())});
                if (params.size() != batchSize) continue;
                FAFAlgoX.executeBatchDB(updateSql, params);
            }
        }
        FAFAlgoX.executeBatchDB(updateSql, params);
        long costTime = System.currentTimeMillis() - startTime;
        if (costTime > 1000L) {
            logger.info("fill model {} data's dimhash cost {}ms", (Object)entityName, (Object)costTime);
        }
    }

    public static void executeBatchDB(String sql, List<Object[]> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fias"), (String)sql, params);
        params.clear();
    }

    public static QFilter[] parallelQFilters(int parallel, QFilter[] qFilters) {
        if (qFilters == null || qFilters.length == 0 || parallel <= qFilters.length) {
            return qFilters;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(parallel);
        if (parallel % qFilters.length == 0) {
            int factor = parallel / qFilters.length;
            for (QFilter qFilter : qFilters) {
                for (int i = 0; i < factor; ++i) {
                    qFilterList.add(new QFilter(String.format("id%%%d", factor), "=", (Object)i).and(qFilter));
                }
            }
        } else {
            int i;
            int factor = parallel - qFilters.length + 1;
            for (i = 0; i < factor; ++i) {
                qFilterList.add(new QFilter(String.format("id%%%d", factor), "=", (Object)i).and(qFilters[0]));
            }
            for (i = 1; i < qFilters.length; ++i) {
                qFilterList.add(qFilters[i]);
            }
        }
        return qFilterList.toArray(new QFilter[0]);
    }
}

