/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.algox;

import java.util.Arrays;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.JoinFunction;
import kd.bos.algox.RowX;
import kd.macc.faf.algox.FAFJoinLinkInfo;

public class FAFJoinLinkFunction
extends JoinFunction {
    private static final long serialVersionUID = 1L;
    private final RowMeta leftRowMeta;
    private final RowMeta newRowMeta;

    public FAFJoinLinkFunction(RowMeta leftRowMeta, FAFJoinLinkInfo link) {
        this.leftRowMeta = leftRowMeta;
        Field[] linkFields = link.getLinkFields();
        Field[] leftFields = leftRowMeta.getFields();
        Field[] fields = Arrays.copyOf(leftFields, leftFields.length + linkFields.length);
        System.arraycopy(linkFields, 0, fields, leftFields.length, linkFields.length);
        this.newRowMeta = new RowMeta(fields);
    }

    public RowX join(RowX leftRow, RowX rightRow) {
        int i;
        RowX rowX = new RowX(this.newRowMeta.getFieldCount());
        for (i = 0; i < this.leftRowMeta.getFieldCount(); ++i) {
            rowX.set(i, leftRow.get(i));
        }
        if (rightRow != null) {
            for (i = this.leftRowMeta.getFieldCount(); i < this.newRowMeta.getFieldCount(); ++i) {
                rowX.set(i, rightRow.get(i - this.leftRowMeta.getFieldCount() + 1));
            }
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

