/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.asynctask.model;

import java.math.BigDecimal;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.macc.faf.asynctask.model.ModelUpgradeModelDTO;
import kd.macc.faf.asynctask.model.ModelUpgradeSystemDTO;
import kd.macc.faf.enums.ModelUpgradeStatusEnum;

public class ModelUpgradeProcessManager {
    private final Long totalUpgradeCount;
    private final AtomicLong executedUpgradeCount = new AtomicLong();

    private ModelUpgradeProcessManager(Long totalUpgradeCount) {
        this.totalUpgradeCount = totalUpgradeCount;
    }

    public static ModelUpgradeProcessManager getInstance(ModelUpgradeSystemDTO modelUpgradeSystemDTO) {
        long totalCount = 0L;
        Set upgradingModelDTOs = modelUpgradeSystemDTO.getUpgradeModelDTOList().stream().filter(model -> ModelUpgradeStatusEnum.UPGRADING == model.getUpgradeStatus()).collect(Collectors.toSet());
        for (ModelUpgradeModelDTO upgradeModelDTO : upgradingModelDTOs) {
            totalCount += (long)upgradeModelDTO.getUpgradeTotalCount();
        }
        return new ModelUpgradeProcessManager(totalCount);
    }

    public int addAndGetProgress(long count) {
        this.executedUpgradeCount.addAndGet(count);
        return new BigDecimal(this.getExecutedUpgradeCount()).divide(new BigDecimal(this.totalUpgradeCount), 2, 4).multiply(new BigDecimal(100)).intValue();
    }

    public long getExecutedUpgradeCount() {
        return this.executedUpgradeCount.get();
    }

    public long getTotalUpgradeCount() {
        return this.totalUpgradeCount;
    }
}

