/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.macc.faf.bservice.ExcuteCacheInfo;
import kd.macc.faf.cache.DistributeCache;
import kd.macc.faf.cache.IDataCacheModule;

public class ExecuteCache {
    private static final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FAF);
    private final String requestId;
    private ExcuteCacheInfo info;

    private ExecuteCache(String requestId) {
        this.requestId = requestId;
    }

    public static ExcuteCacheInfo getCache(String requestId) {
        return new ExecuteCache(requestId).getCache();
    }

    public static synchronized void save(String requestId, ExcuteCacheInfo mCache) {
        ExcuteCacheInfo cacheInfo = ExecuteCache.getCache(requestId);
        cacheInfo.setTaskCount(mCache.getTaskCount());
        cacheInfo.setMessage(mCache.getMessage());
        cacheInfo.setErroMessage(mCache.getErroMessage());
        cacheInfo.setTipMessage(mCache.getTipMessage());
        cacheInfo.getSuccessList().addAll(mCache.getSuccessList());
        cacheInfo.getFailList().addAll(mCache.getFailList());
        cacheInfo.refreshProgress();
        cacheInfo.setProgress(mCache.getProgress());
        String jsonString = SerializationUtils.toJsonString((Object)cacheInfo);
        cache.put(String.format("request_execute:%s", requestId), (Object)jsonString);
    }

    private ExcuteCacheInfo getCache() {
        if (this.info == null) {
            String cache_json = cache.get(String.format("request_execute:%s", this.requestId));
            if (StringUtils.isNotEmpty((CharSequence)cache_json)) {
                this.info = (ExcuteCacheInfo)SerializationUtils.fromJsonString((String)cache_json, ExcuteCacheInfo.class);
            } else {
                this.info = new ExcuteCacheInfo();
                this.info.setRequestId(this.requestId);
            }
        }
        return this.info;
    }
}

