/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice.check;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.faf.bservice.check.DataCheckResultEnum;
import kd.macc.faf.bservice.check.DataCheckRunModeEnum;

public class DataCheckBusinessHelper {
    public static Set<Long> queryModelSet(Long systemId, String periodDimension) {
        QFilter filter = new QFilter("analysis_system", "=", (Object)systemId).and("tablenumber", "!=", (Object)Character.valueOf(' ')).and("tablenumber", "is not null", null).and("enable", "=", (Object)Character.valueOf('1')).and("dimension_entry.necessity_dim", "=", (Object)"1").and("dimension_entry.dimension.dimensionsource", "in", (Object)new String[]{periodDimension});
        LinkedHashSet<Long> set = new LinkedHashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_model", (String)"pa_analysismodel", (String)"id,number", (QFilter[])filter.toArray(), (String)"number asc");){
            for (Row row : dataSet) {
                set.add(row.getLong("id"));
            }
        }
        return set;
    }

    public static Set<Long> queryCheckRuleList(Long modelPkvalue, Long useOrgId, Set<String> runModeSet) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"faf_datacheckrule", Collections.singletonList(useOrgId), (boolean)false);
        filter.and(new QFilter("model", "=", (Object)modelPkvalue));
        if (runModeSet != null && !runModeSet.isEmpty()) {
            filter.and(new QFilter("runMode", "in", runModeSet));
        }
        filter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.queryPrimaryKeys((String)"faf_datacheckrule", (QFilter[])filter.toArray(), null, (int)100000).stream().mapToLong(value -> (Long)value).boxed().collect(Collectors.toSet());
    }

    public static DynamicObject[] queryCheckRuleDynamicObjectList(Long modelPkvalue, Long useOrgId, String runMode) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"faf_datacheckrule", Collections.singletonList(useOrgId), (boolean)false);
        filter.and(new QFilter("model", "=", (Object)modelPkvalue));
        if (StringUtils.isNotEmpty((CharSequence)runMode)) {
            filter.and(new QFilter("runMode", "=", (Object)runMode));
        }
        filter.and("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.load((String)"faf_datacheckrule", (String)"id,number,name,entryentity.checked,entryentity.promptmode,entryentity.tipstext,entryentity.checkcondition_tag", (QFilter[])filter.toArray(), null, (int)100000);
    }

    public static boolean exsitNotExecuteRuleList(List<Object> rulePkIds) {
        QFilter qFilter = new QFilter("id", "in", rulePkIds);
        qFilter.and(new QFilter("enable", "=", (Object)"0").or("runMode", "=", (Object)DataCheckRunModeEnum.AUTO_BY_REPLENISH_DATA.getCode()));
        return QueryServiceHelper.exists((String)"faf_datacheckrule", (QFilter[])qFilter.toArray());
    }

    public static boolean exsitPassReport(Object[] pkvalues) {
        QFilter qFilter = new QFilter("id", "in", (Object)pkvalues);
        qFilter.and("checkresult", "=", (Object)DataCheckResultEnum.PASS.getCode());
        return QueryServiceHelper.exists((String)"faf_datacheckreport", (QFilter[])qFilter.toArray());
    }

    public static boolean exsitRunModeReport(Object[] pkvalues, String runMode) {
        QFilter qFilter = new QFilter("id", "in", (Object)pkvalues);
        qFilter.and("runmode", "=", (Object)runMode);
        return QueryServiceHelper.exists((String)"faf_datacheckreport", (QFilter[])qFilter.toArray());
    }
}

