/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice.check;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.bservice.check.DataCheckReport;
import kd.macc.faf.bservice.check.DataCheckResultEnum;
import kd.macc.faf.bservice.check.DataCheckRule;
import kd.macc.faf.bservice.check.DataCheckRuleCondition;
import kd.macc.faf.bservice.check.ICheckReportCallBack;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.helper.DLockHelper;

public class DataCheckReportRunnable
implements Runnable {
    private static final Log logger = LogFactory.getLog(DataCheckReportRunnable.class);
    private final DataSyncModel model;
    private final DataCheckReport report;
    private final Date startTime;
    private DLock dLock;
    private ICheckReportCallBack callBack;
    private StringBuilder logText;

    public DataCheckReportRunnable(DataSyncModel model, DataCheckReport checkReport) {
        this.model = model;
        this.report = checkReport;
        this.startTime = new Date();
    }

    public DataCheckReportRunnable(DataCheckReport checkReport) {
        this.model = checkReport.getModel();
        this.report = checkReport;
        this.startTime = new Date();
    }

    @Override
    public void run() {
        this.update();
    }

    public void update() {
        DynamicObject dynamicObject = this.report.getDynamic();
        DataCheckRule rule = this.report.getCheckRule();
        DynamicObject execInfoRow = null;
        try {
            this.logText = new StringBuilder();
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
            int level = 1;
            collection.clear();
            List<DataCheckRuleCondition> conditionList = rule.getRuleConditionList();
            for (int i = 0; i < conditionList.size(); ++i) {
                DataCheckRuleCondition ruleCondition = conditionList.get(i);
                if (ruleCondition.isChecked()) {
                    ruleCondition.refresh(this.report);
                    DynamicObject addNew = collection.addNew();
                    addNew.set("checkcondition", (Object)ruleCondition.getCheckconditionDesc());
                    addNew.set("checkcondition_tag", (Object)ruleCondition.getCheckconditionTagText());
                    addNew.set("checkconditionid", (Object)ruleCondition.getCheckconditionId());
                    String conditioncheckresult = ruleCondition.getConditioncheckresult();
                    int conditionLevel = Integer.parseInt(conditioncheckresult);
                    if (conditionLevel > level) {
                        level = conditionLevel;
                    }
                    addNew.set("conditioncheckresult", (Object)conditioncheckresult);
                    addNew.set("tipstext", (Object)ruleCondition.getTipstext());
                    String checklog = ruleCondition.getChecklog();
                    if (!StringUtils.isNotEmpty((CharSequence)checklog)) continue;
                    this.logText.append(checklog).append("\n");
                    continue;
                }
                LocalDateTime now = LocalDateTime.now();
                String timetext = now.toLocalDate().toString() + " " + now.toLocalTime().toString();
                this.logText.append(String.format(ResManager.loadKDString((String)"%1$s - \u201c\u7b2c%2$s\u884c\u6821\u9a8c\u6761\u4ef6\u201d\u672a\u542f\u7528\uff1b", (String)"DataCheckReportRunnable_0", (String)"macc-faf-business", (Object[])new Object[0]), timetext, i + 1)).append("\n");
            }
            dynamicObject.set("checkresult", (Object)level);
            execInfoRow = this.createExecInfoRow(dynamicObject);
            execInfoRow.set("execstatus", (Object)"1");
            this.fillLogText(execInfoRow);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.report.getDynamic()});
            this.onFinish();
        }
        catch (Exception ex) {
            if (ex instanceof KDException) {
                this.logText.append(ex.getMessage()).append("\n");
            } else {
                for (StackTraceElement element : ex.getStackTrace()) {
                    this.logText.append(element).append("\n");
                }
            }
            dynamicObject.set("checkresult", (Object)DataCheckResultEnum.FAIL.getCode());
            if (execInfoRow == null) {
                execInfoRow = this.createExecInfoRow(dynamicObject);
            }
            execInfoRow.set("execstatus", (Object)"2");
            this.fillLogText(execInfoRow);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.onFail(ex);
        }
    }

    private DynamicObject createExecInfoRow(DynamicObject dynamicObject) {
        DynamicObjectCollection execentryentity = dynamicObject.getDynamicObjectCollection("execentryentity");
        DynamicObjectType exectype = execentryentity.getDynamicObjectType();
        DynamicObject execInfoRow = (DynamicObject)exectype.createInstance();
        execInfoRow.set("execstarttime", (Object)this.startTime);
        Date endTime = new Date();
        execInfoRow.set("execendtime", (Object)endTime);
        execInfoRow.set("durationtext", (Object)FAFUtils.calcDurationText((Date)this.startTime, (Date)endTime));
        execentryentity.add(0, execInfoRow);
        for (int i = 0; i < execentryentity.size(); ++i) {
            ((DynamicObject)execentryentity.get(i)).set("seq", (Object)(i + 1));
        }
        if (execentryentity.size() > 20) {
            execentryentity.remove(execentryentity.size() - 1);
        }
        return execInfoRow;
    }

    private void fillLogText(DynamicObject execInfoRow) {
        String logtext = this.logText.toString();
        if (!logtext.isEmpty()) {
            execInfoRow.set("loginfo", (Object)logtext.substring(0, Math.min(200, logtext.length() - 1)));
            execInfoRow.set("loginfo_tag", (Object)logtext);
        }
    }

    private void onFinish() {
        this.getCallBack().onFinish(this.report);
    }

    private void onFail(Exception ex) {
        this.getCallBack().onFail(this.report, ex.getMessage());
    }

    public ICheckReportCallBack getCallBack() {
        if (this.callBack == null) {
            this.callBack = new ICheckReportCallBack(){};
        }
        return this.callBack;
    }

    public void setCallBack(ICheckReportCallBack callBack) {
        this.callBack = callBack;
    }

    private boolean lock() {
        String mopLockKey = DLockHelper.getMOPLockKey((Long)((Long)this.model.getPkValue()), (Long)this.report.getOrgId(), (Long)this.report.getPeriodId());
        this.dLock = DLock.create((String)mopLockKey);
        if (this.dLock.tryLock(1000L)) {
            if (DLockHelper.existsMLock((String)this.model.getEntitynumber_d())) {
                this.dLock.unlock();
                logger.info("faf-data-check: runnable lock fail, model number:{},org:{},peirod:{}", new Object[]{this.model.getNumber(), this.report.getOrgId(), this.report.getPeriodId()});
            } else {
                return true;
            }
        }
        return false;
    }

    private void unlock() {
        if (this.dLock != null) {
            this.dLock.close();
        }
    }
}

