/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice.check;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.macc.faf.bservice.BusinessDynamic;
import kd.macc.faf.bservice.BusinessDynamicFactory;
import kd.macc.faf.bservice.check.DataCheckRuleCondition;
import kd.macc.faf.datasync.exec.data.DataSyncModel;

public class DataCheckRule
extends BusinessDynamic {
    private static final long serialVersionUID = -9138563125878076402L;
    private final DataSyncModel model;
    private final Map<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>();
    private final Map<Long, DynamicObject> periodMap = new HashMap<Long, DynamicObject>();

    public DataCheckRule(DynamicObject dynamic) {
        super(dynamic);
        this.model = BusinessDynamicFactory.createDataSyncModel(dynamic.getLong("model_id"));
    }

    public List<DataCheckRuleCondition> getRuleConditionList() {
        DynamicObjectCollection entryentity = this.getDynamic().getDynamicObjectCollection("entryentity");
        return entryentity.stream().map(dynamicObject -> new DataCheckRuleCondition(this, (DynamicObject)dynamicObject)).collect(Collectors.toList());
    }

    public Map<Long, DataCheckRuleCondition> getRuleConditionMap() {
        DynamicObjectCollection entryentity = this.getDynamic().getDynamicObjectCollection("entryentity");
        return entryentity.stream().map(dynamicObject -> new DataCheckRuleCondition(this, (DynamicObject)dynamicObject)).collect(Collectors.toMap(DataCheckRuleCondition::getCheckconditionId, d -> d));
    }

    public DynamicObject createReportDynamicObject(String batchNo, Long org, Long period) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"faf_datacheckreport");
        dynamicObject.set("batchno", (Object)batchNo);
        dynamicObject.set("id", (Object)DB.genGlobalLongId());
        dynamicObject.set("billNo", (Object)this.createReportBillNo());
        dynamicObject.set("system", this.model.getDynamic().get("analysis_system"));
        dynamicObject.set("model", (Object)this.model.getDynamic());
        dynamicObject.set("runmode", (Object)this.getRunmode());
        dynamicObject.set("checkrule", (Object)this.getDynamic());
        if (!this.orgMap.containsKey(org)) {
            this.orgMap.put(org, BusinessDataServiceHelper.loadSingleFromCache((Object)org, (String)"bos_org", (String)"id,number,name"));
        }
        dynamicObject.set("checkorg", (Object)this.orgMap.get(org));
        if (!this.periodMap.containsKey(period)) {
            this.periodMap.put(period, BusinessDataServiceHelper.loadSingleFromCache((Object)period, (String)"bd_period", (String)"id,number,name"));
        }
        dynamicObject.set("checkperiod", (Object)this.periodMap.get(period));
        dynamicObject.set("checkresult", (Object)"0");
        return dynamicObject;
    }

    private String getRunmode() {
        return this.getDynamic().getString("runMode");
    }

    private String createReportBillNo() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"faf_datacheckreport");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, null);
        if (codeRule == null) {
            return String.format("CheckReport-" + DB.genStringId((String)"faf_datacheckreport"), new Object[0]);
        }
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dynamicObject);
    }

    public DataSyncModel getModel() {
        return this.model;
    }

    public DataCheckRuleCondition getDataCheckRuleCondition(Long checkconditionId) {
        return this.getRuleConditionMap().get(checkconditionId);
    }
}

