/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice.check;

import java.time.LocalDateTime;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.bservice.BusinessDynamic;
import kd.macc.faf.bservice.check.DataCheckReport;
import kd.macc.faf.bservice.check.DataCheckResultEnum;
import kd.macc.faf.bservice.check.DataCheckRule;
import kd.macc.faf.dataquery.func.DataDetailFilterFunction;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.util.CustomizedDynamicFormBuilderUtil;

public class DataCheckRuleCondition
extends BusinessDynamic {
    private static final long serialVersionUID = -9138563125878076402L;
    private final DataCheckRule checkRule;
    private boolean checkpass = false;
    private String checklog = "";

    public DataCheckRuleCondition(DataCheckRule checkRule, DynamicObject dynamic) {
        super(dynamic);
        this.checkRule = checkRule;
    }

    public void refresh(DataCheckReport report) {
        try {
            boolean existField;
            DataSyncModel syncModel = this.checkRule.getModel();
            QFilter qFilter = new QFilter(syncModel.getOrgNumber(), "=", (Object)report.getOrgId()).and(syncModel.getPeriodNumber(), "=", (Object)report.getPeriodId());
            qFilter.and(this.getConditionQFilter());
            boolean bl = this.checkpass = !QueryServiceHelper.exists((String)this.getEntitynumber(), (QFilter[])qFilter.toArray());
            if (!this.checkpass && (existField = CustomizedDynamicFormBuilderUtil.judgeExistField((String)this.getEntitynumber(), (String)"_markpass"))) {
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DataCheckRuleCondition", (String)this.getEntitynumber(), (String)"id, _markpass_tag", (QFilter[])qFilter.toArray(), null);){
                    DataDetailFilterFunction function = new DataDetailFilterFunction(dataSet.getRowMeta(), this.getDynamic().getLong("id"));
                    boolean hasRow = false;
                    for (Row row : dataSet) {
                        if (!function.test(row)) continue;
                        hasRow = true;
                        break;
                    }
                    if (!hasRow) {
                        this.checkpass = true;
                    }
                }
            }
            LocalDateTime now = LocalDateTime.now();
            String timetext = now.toLocalDate().toString() + " " + now.toLocalTime().toString();
            this.checklog = String.format(ResManager.loadKDString((String)"%1$s - \u201c\u7b2c%2$s\u884c\u6821\u9a8c\u6761\u4ef6\u201d\u5b8c\u6210\u6821\u9a8c\uff1b", (String)"DataCheckRuleCondition_0", (String)"macc-faf-business", (Object[])new Object[0]), timetext, this.getDynamic().get("seq"));
        }
        catch (Exception ex) {
            this.checklog = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6821\u9a8c\u6761\u4ef6\uff0c\u6267\u884c\u5931\u8d25\uff1a%2$s", (String)"DataCheckRuleCondition_1", (String)"macc-faf-business", (Object[])new Object[0]), this.getDynamic().get("seq"), ex.getMessage());
            this.checkpass = false;
            throw new KDBizException((Throwable)ex, new ErrorCode("DATA-CHECK-RULE-REFRESH-1", this.checklog), new Object[0]);
        }
    }

    public boolean isChecked() {
        return this.getDynamic().getBoolean("checked");
    }

    public String getCheckconditionDesc() {
        return this.getDynamic().getString("checkconditiondesc");
    }

    public String getCheckconditionJson() {
        return this.getDynamic().getString("checkcondition_tag");
    }

    public String getCheckconditionTagText() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("promptmode", this.getDynamic().getString("promptmode"));
        map.put("tipstext", this.getDynamic().getString("tipstext"));
        map.put("checkcondition_tag", this.getCheckconditionJson());
        return SerializationUtils.toJsonString(map);
    }

    public Long getCheckconditionId() {
        return (Long)this.getDynamic().getPkValue();
    }

    public String getConditioncheckresult() {
        if (this.checkpass) {
            return DataCheckResultEnum.PASS.getCode();
        }
        return this.getDynamic().getString("promptmode");
    }

    public String getTipstext() {
        if (this.checkpass) {
            return "";
        }
        return this.getDynamic().getString("tipstext");
    }

    public String getChecklog() {
        return this.checklog;
    }

    public String getEntitynumber() {
        DataSyncModel model = this.checkRule.getModel();
        return model.getEntitynumber();
    }

    public QFilter getConditionQFilter() {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)this.getCheckconditionJson(), FilterCondition.class);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntitynumber());
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }
}

