/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.bservice.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.macc.faf.bservice.BusinessDynamicFactory;
import kd.macc.faf.bservice.ExcuteCacheInfo;
import kd.macc.faf.bservice.ExecuteCache;
import kd.macc.faf.bservice.check.DataCheckBusinessHelper;
import kd.macc.faf.bservice.check.DataCheckReport;
import kd.macc.faf.bservice.check.DataCheckReportRunnable;
import kd.macc.faf.bservice.check.DataCheckRule;
import kd.macc.faf.bservice.check.DataCheckRuleExecParams;
import kd.macc.faf.bservice.check.ICheckReportCallBack;
import kd.macc.faf.datasync.exec.data.DataSyncModel;

public class DataCheckRuleExecutor
implements Runnable {
    private static final Log logger = LogFactory.getLog(DataCheckRuleExecutor.class);
    private static final int MAX_THREAD = 3;
    private final Semaphore semaphore = new Semaphore(3, true);
    private final String requestId;
    private final DataCheckRuleExecParams params;
    private final DataSyncModel model;
    private final List<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
    private Map<Long, Set<Long>> orgMapRuleSet;
    private Map<Long, DataCheckRule> ruleMap;

    private DataCheckRuleExecutor(DataCheckRuleExecParams params) {
        this.params = params;
        this.requestId = DB.genGlobalLongId() + "";
        this.model = BusinessDynamicFactory.createDataSyncModel(params.getModelPkvalue());
        this.valid();
    }

    public static DataCheckRuleExecutor create(DataCheckRuleExecParams params) {
        return new DataCheckRuleExecutor(params);
    }

    private void init() {
        List orgList = this.params.getOrgList();
        this.orgMapRuleSet = new LinkedHashMap<Long, Set<Long>>(orgList.size());
        List ruleList = this.params.getDataCheckRuleList();
        HashSet<Long> ruleSet = !ruleList.isEmpty() ? new HashSet(ruleList) : new HashSet<Long>();
        for (Long org : orgList) {
            Set<Long> permRuleIds = DataCheckBusinessHelper.queryCheckRuleList(this.params.getModelPkvalue(), org, this.params.getFilterRunMode());
            if (!ruleList.isEmpty()) {
                permRuleIds.retainAll(ruleList);
            } else {
                ruleSet.addAll(permRuleIds);
            }
            this.orgMapRuleSet.put(org, permRuleIds);
        }
        this.ruleMap = new HashMap<Long, DataCheckRule>(ruleSet.size());
        for (Long ruleId : ruleSet) {
            this.ruleMap.put(ruleId, BusinessDynamicFactory.createDataCheckRule(ruleId));
        }
    }

    private void valid() {
        this.model.getEntitynumber();
    }

    @Override
    public void run() {
        this.dynamicObjects.clear();
        List periodList = this.params.getPeriodList();
        for (Object period : periodList) {
            Set<Map.Entry<Long, Set<Long>>> entries = this.getOrgMapRuleSet().entrySet();
            for (Map.Entry<Long, Set<Long>> entry : entries) {
                Long org = entry.getKey();
                Set<Long> ruleSet = entry.getValue();
                for (Long ruleId : ruleSet) {
                    DataCheckRule rule = this.getRuleMap().get(ruleId);
                    DynamicObject reportDynamicObject = rule.createReportDynamicObject(this.params.getBatchNo(), org, (Long)period);
                    reportDynamicObject.set("creator", (Object)this.params.getOperator());
                    this.dynamicObjects.add(reportDynamicObject);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])this.dynamicObjects.toArray(new DynamicObject[0]));
        ExcuteCacheInfo mCache = new ExcuteCacheInfo();
        mCache.setTaskCount(this.dynamicObjects.size());
        ExecuteCache.save(this.requestId, mCache);
        for (DynamicObject dynamicObject : this.dynamicObjects) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.execRefreshReport(dynamicObject);
        }
        try {
            this.semaphore.acquire(3);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ExcuteCacheInfo mCache1 = new ExcuteCacheInfo();
        mCache1.setMessage(String.format(ResManager.loadKDString((String)"\u5168\u90e8\u6267\u884c\u5b8c\u6210\uff0c\u5171\u751f\u6210\u6570\u636e\u6821\u9a8c\u62a5\u544a %s \u4efd\u3002", (String)"DataCheckRuleExecutor_0", (String)"macc-faf-business", (Object[])new Object[0]), mCache.getTaskCount()));
        mCache1.setProgress(100);
        ExecuteCache.save(this.requestId, mCache1);
    }

    public ErrorCode execute() {
        try {
            this.run();
        }
        catch (Exception ex) {
            logger.info("faf-datacheck exec erro", (Object)ex);
            return new ErrorCode("fail", ex.getMessage());
        }
        return new ErrorCode("success", "success");
    }

    public ErrorCode syncExecute() {
        try {
            ThreadPools.executeOnce((String)"DataCheckRuleExecutor", (Runnable)this);
        }
        catch (Exception ex) {
            logger.info("faf-datacheck exec erro", (Object)ex);
            return new ErrorCode("fail", ex.getMessage());
        }
        return new ErrorCode("success", "success");
    }

    private void execRefreshReport(DynamicObject dynamicObject) {
        DataCheckReport checkReport = BusinessDynamicFactory.createDataCheckReport(dynamicObject);
        DataCheckReportRunnable runnable = new DataCheckReportRunnable(this.model, checkReport);
        runnable.setCallBack(new ICheckReportCallBack(){

            @Override
            public void onFinish(DataCheckReport report) {
                ExcuteCacheInfo mCache = new ExcuteCacheInfo();
                mCache.addSuccess(String.format(ResManager.loadKDString((String)"%s \u6267\u884c\u5b8c\u6210\u3002", (String)"DataCheckRuleExecutor_1", (String)"macc-faf-business", (Object[])new Object[0]), report.toString()));
                ExecuteCache.save(DataCheckRuleExecutor.this.requestId, mCache);
                DataCheckRuleExecutor.this.sendMessage(report, null);
                DataCheckRuleExecutor.this.semaphore.release();
            }

            @Override
            public void onFail(DataCheckReport report, String message) {
                ExcuteCacheInfo mCache = new ExcuteCacheInfo();
                mCache.addFail(String.format(ResManager.loadKDString((String)"%1$s \u6267\u884c\u53d1\u751f\u9519\u8bef\uff1a%2$s\u3002", (String)"DataCheckRuleExecutor_2", (String)"macc-faf-business", (Object[])new Object[0]), report.toString(), message));
                ExecuteCache.save(DataCheckRuleExecutor.this.requestId, mCache);
                DataCheckRuleExecutor.this.sendMessage(report, message);
                DataCheckRuleExecutor.this.semaphore.release();
            }
        });
        ThreadPools.executeOnce((String)"DataCheckRuleExecutor", (Runnable)runnable);
    }

    private void sendMessage(DataCheckReport report, String message) {
        Long creatorId = report.getCreatorId();
        if (creatorId == null || !this.params.getSendMessage().booleanValue()) {
            return;
        }
        String title = String.format(ResManager.loadKDString((String)"\u3010\u6570\u636e\u6821\u9a8c\u7ed3\u679c\u901a\u77e5\u3011\u6821\u9a8c\u7ed3\u679c\uff1a%1$s\uff0c\u6821\u9a8c\u89c4\u5219\uff1a%2$s", (String)"DataCheckRuleExecutor_3", (String)"macc-faf-business", (Object[])new Object[0]), report.getCheckResult().getText(), report.getCheckRule().getNumber());
        String content = StringUtils.isEmpty((CharSequence)message) ? String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\u5df2\u6267\u884c\u5b8c\u6210%2$s\u7684\u6570\u636e\u6821\u9a8c\uff0c\u6821\u9a8c\u89c4\u5219\u4e3a%3$s\uff0c\u8bf7\u70b9\u51fb\u6d88\u606f\u8d85\u94fe\u63a5\u67e5\u770b\u62a5\u544a\u8be6\u60c5\uff0c\u6216\u524d\u5f80\u76c8\u5229\u80fd\u529b\u5206\u6790-\u6570\u636e\u6821\u9a8c-\u6570\u636e\u6821\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u770b\u62a5\u544a\u3002", (String)"DataCheckRuleExecutor_4", (String)"macc-faf-business", (Object[])new Object[0]), report.getDynamic().getString("checkorg.name"), report.getDynamic().getString("checkperiod.name"), report.getDynamic().getString("checkrule.number")) : String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\u7684\u6570\u636e\u6821\u9a8c\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6821\u9a8c\u89c4\u5219\u4e3a%2$s\uff0c\u8bf7\u70b9\u51fb\u6d88\u606f\u8d85\u94fe\u63a5\u67e5\u770b\u62a5\u544a\u8be6\u60c5\uff0c\u6216\u524d\u5f80\u76c8\u5229\u80fd\u529b\u5206\u6790-\u6570\u636e\u6821\u9a8c-\u6570\u636e\u6821\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u770b\u62a5\u544a\u3002", (String)"DataCheckRuleExecutor_5", (String)"macc-faf-business", (Object[])new Object[0]), report.getDynamic().getString("checkorg.name"), report.getDynamic().getString("checkrule.number"));
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setEntityNumber("faf_datacheckreport");
        messageInfo.setTag(ResManager.loadKDString((String)"\u901a\u77e5", (String)"DataCheckRuleExecutor_6", (String)"macc-faf-business", (Object[])new Object[0]));
        messageInfo.setMessageTitle((ILocaleString)new LocaleString(title));
        messageInfo.setMessageContent((ILocaleString)new LocaleString(content));
        messageInfo.setContentUrl(String.format("%1$s/index.html?formId=faf_datacheckreport&pkId=%2$s", UrlService.getDomainContextUrl(), report.getPkValue()));
        ArrayList<Long> receivers = new ArrayList<Long>();
        receivers.add(creatorId);
        messageInfo.setUserIds(receivers);
        messageInfo.setNotifyType(MessageChannels.MC.getNumber());
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public List<DynamicObject> getDynamicObjects() {
        return this.dynamicObjects;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getBatchNo() {
        return this.params.getBatchNo();
    }

    public Map<Long, Set<Long>> getOrgMapRuleSet() {
        if (this.orgMapRuleSet == null) {
            this.init();
        }
        return this.orgMapRuleSet;
    }

    public Map<Long, DataCheckRule> getRuleMap() {
        if (this.ruleMap == null) {
            this.init();
        }
        return this.ruleMap;
    }
}

