/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataquery.dto;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.enums.DataQueryTypeEnum;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.helper.OrgHelper;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.DateUtil;
import kd.macc.faf.util.DimensionDyUtil;

public class FAFDataQueryModelDTO {
    private Long anaSystemId;
    private Long anaModelId;
    private String tableNumber;
    Map<DimensionNecessityEnum, DynamicObject> dimensionNecessityEnumDynamicObjectMap;
    private Map<String, List<String>> dimensionNumberFieldNumbersMap;
    private Map<String, List<String>> dimensionNumberFieldNamesMap;
    private List<String> measureNumbers;
    private ReportQueryParam queryParam;
    private DataQueryTypeEnum dataQueryTypeEnum;

    private FAFDataQueryModelDTO() {
    }

    public static FAFDataQueryModelDTO buildOf(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        long anaSystemId = 0L;
        FilterItemInfo anaSystemItem = filterInfo.getFilterItem("anasystem");
        if (anaSystemItem != null && anaSystemItem.getValue() != null) {
            anaSystemId = ((DynamicObject)anaSystemItem.getValue()).getLong("id");
        }
        long anaModelId = 0L;
        FilterItemInfo anaModelItem = filterInfo.getFilterItem("anamodel");
        if (anaModelItem != null && anaModelItem.getValue() != null) {
            anaModelId = ((DynamicObject)anaModelItem.getValue()).getLong("id");
        }
        String dataType = null;
        FilterItemInfo dataTypeItem = filterInfo.getFilterItem("datatype");
        if (dataTypeItem != null) {
            dataType = (String)filterInfo.getFilterItem("datatype").getValue();
        }
        DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)anaModelId, (String)"pa_analysismodel");
        LinkedHashMap<String, List<String>> dimensionNumberFieldNumbersMap = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> dimensionNumberFieldNamesMap = new LinkedHashMap<String, List<String>>();
        for (DynamicObject dimensionEntry : anaModel.getDynamicObjectCollection("dimension_entry")) {
            DynamicObject dimension = dimensionEntry.getDynamicObject("dimension");
            String dimensionNumber = dimension.getString("number");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            List<Object> fieldNumberList = new ArrayList(8);
            List<Object> fieldNameList = new ArrayList(8);
            if (DimensionTypeEnum.DATABASE == dimensionTypeEnum || DimensionTypeEnum.ASSISTANTDATA == dimensionTypeEnum) {
                fieldNumberList = Stream.of(dimensionEntry.getString("field_number_tag").split(",")).collect(Collectors.toList());
                fieldNameList = Stream.of(dimensionEntry.getString("field_name").split(",")).collect(Collectors.toList());
            }
            dimensionNumberFieldNumbersMap.put(dimensionNumber, fieldNumberList);
            dimensionNumberFieldNamesMap.put(dimensionNumber, fieldNameList);
        }
        List<String> measureNumbers = anaModel.getDynamicObjectCollection("measure_entry").stream().map(entry -> entry.getDynamicObject("measure").getString("number")).collect(Collectors.toList());
        FAFDataQueryModelDTO fafDataQueryModelDTO = new FAFDataQueryModelDTO();
        fafDataQueryModelDTO.setAnaSystemId(anaSystemId);
        fafDataQueryModelDTO.setAnaModelId(anaModelId);
        fafDataQueryModelDTO.setTableNumber(anaModel.getString("tablenumber"));
        fafDataQueryModelDTO.setDimensionNumberFieldNumbersMap(dimensionNumberFieldNumbersMap);
        fafDataQueryModelDTO.setDimensionNumberFieldNamesMap(dimensionNumberFieldNamesMap);
        fafDataQueryModelDTO.setMeasureNumbers(measureNumbers);
        fafDataQueryModelDTO.setQueryParam(queryParam);
        fafDataQueryModelDTO.setDataQueryTypeEnum(DataQueryTypeEnum.getEnumByCode((String)dataType));
        return fafDataQueryModelDTO;
    }

    public String getQueryTableEntityNumber() {
        switch (this.dataQueryTypeEnum) {
            case SUMMARY: {
                return AnalysisModelUtil.buildEntityNumber((String)this.tableNumber);
            }
            case DETAIL: {
                return AnalysisModelUtil.buildDetailEntityNumber((String)this.tableNumber);
            }
        }
        return null;
    }

    public String getQueryFieldsInfo() {
        StringBuilder fieldsInfo = new StringBuilder();
        fieldsInfo.append("id").append(',');
        if (this.dataQueryTypeEnum == DataQueryTypeEnum.DETAIL) {
            fieldsInfo.append("importbatch").append(',');
            fieldsInfo.append("sourceformid").append(',');
            fieldsInfo.append("sourcebillid").append(',');
        }
        for (Map.Entry<String, List<String>> dimensionEntry : this.dimensionNumberFieldNumbersMap.entrySet()) {
            String dimensionNumber = dimensionEntry.getKey();
            List<String> dimensionFields = dimensionEntry.getValue();
            if (CollectionUtils.isEmpty(dimensionFields)) {
                fieldsInfo.append(dimensionNumber).append(',');
                continue;
            }
            for (String dimensionField : dimensionFields) {
                if (!StringUtils.isNotBlank((CharSequence)dimensionField)) continue;
                fieldsInfo.append(String.format("%1$s.%2$s", dimensionNumber, dimensionField)).append(',');
            }
        }
        for (String measureNumber : this.measureNumbers) {
            fieldsInfo.append(measureNumber).append(',');
        }
        return fieldsInfo.substring(0, fieldsInfo.length() - 1);
    }

    public QFilter[] getQueryFilter() {
        FilterItemInfo filterItem;
        QFilter commFilter;
        Map commFilterMap;
        ArrayList<QFilter> queryFilters = new ArrayList<QFilter>();
        FilterInfo filterInfo = this.queryParam.getFilter();
        DynamicObject periodDimension = this.getNecessaryDimensionOfModel(DimensionNecessityEnum.PERIOD);
        String periodNumber = periodDimension.getString("number");
        DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)periodDimension.getString("dimensiontype"));
        switch (dimensionType) {
            case DATABASE: 
            case PERIOD: 
            case ASSISTANTDATA: {
                DynamicObject period;
                FilterItemInfo periodItem = filterInfo.getFilterItem(this.getPeriodFilterNumberByDimension(periodDimension));
                if (periodItem == null || (period = (DynamicObject)periodItem.getValue()) == null) break;
                queryFilters.add(new QFilter(periodNumber, "=", (Object)period.getLong("id")));
                break;
            }
            case DATE: {
                Date endDate;
                FilterItemInfo endDateItem;
                Date startDate;
                FilterItemInfo startDateItem = filterInfo.getFilterItem("startdate");
                if (startDateItem != null && (startDate = (Date)startDateItem.getValue()) != null) {
                    queryFilters.add(new QFilter(periodNumber, ">=", (Object)startDate));
                }
                if ((endDateItem = filterInfo.getFilterItem("enddate")) == null || (endDate = (Date)endDateItem.getValue()) == null) break;
                queryFilters.add(new QFilter(periodNumber, "<", (Object)DateUtil.getNextDay((Date)endDate, (int)1)));
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u4e2d\u6807\u8bb0\u7684\u65f6\u95f4\u671f\u95f4\u5fc5\u8981\u7ef4\u5ea6\u7684\u7c7b\u578b\u76ee\u524d\u53ea\u652f\u6301\u57fa\u7840\u8d44\u6599\u3001\u671f\u95f4\u7ef4\u5ea6\u3001\u8f85\u52a9\u8d44\u6599\u3001\u65f6\u95f4", (String)"FAFDataQueryModelDTO_0", (String)"macc-faf-business", (Object[])new Object[0]));
            }
        }
        DynamicObject orgDimension = this.getNecessaryDimensionOfModel(DimensionNecessityEnum.ORG);
        FilterItemInfo orgItem = filterInfo.getFilterItem("org");
        if (orgItem != null) {
            DynamicObjectCollection orgDys = (DynamicObjectCollection)orgItem.getValue();
            if (!CollectionUtils.isEmpty((Collection)orgDys)) {
                queryFilters.add(new QFilter(orgDimension.getString("number"), "in", orgDys.stream().map(org -> org.getLong("id")).collect(Collectors.toList())));
            } else {
                OrgHelper.PermOrgResult permOrgResult = OrgHelper.getPermOrgSet((String)"faf_data_query", (String)"faf");
                if (!permOrgResult.hasAllOrgPerm()) {
                    queryFilters.add(new QFilter(orgDimension.getString("number"), "in", (Object)permOrgResult.getPermOrgs()));
                }
            }
        }
        if (!CollectionUtils.isEmpty((Map)(commFilterMap = filterInfo.getCommFilter())) && (commFilter = (QFilter)commFilterMap.get(AnalysisModelUtil.buildEntityNumber((String)this.tableNumber))) != null) {
            queryFilters.add(commFilter);
        }
        if (this.dataQueryTypeEnum == DataQueryTypeEnum.DETAIL && (filterItem = filterInfo.getFilterItem("detailids")) != null && StringUtils.isNotBlank((Object)filterItem.getValue())) {
            queryFilters.add(new QFilter("id", "in", JSON.parseObject((String)((String)filterItem.getValue()), Long[].class)));
        }
        return CollectionUtils.isEmpty(queryFilters) ? null : queryFilters.toArray(new QFilter[0]);
    }

    private String getPeriodFilterNumberByDimension(DynamicObject periodDimension) {
        String periodSourceNumber;
        switch (periodSourceNumber = periodDimension.getDynamicObject("dimensionsource").getString("number")) {
            case "bd_period": {
                periodSourceNumber = "bdperiod";
                break;
            }
            case "pa_analysisperiod": {
                periodSourceNumber = "paperiod";
                break;
            }
            default: {
                throw new KDBizException("error period sourceType");
            }
        }
        return periodSourceNumber;
    }

    public DynamicObject getNecessaryDimensionOfModel(DimensionNecessityEnum dimensionNecessityEnum) {
        if (CollectionUtils.isEmpty(this.dimensionNecessityEnumDynamicObjectMap)) {
            this.dimensionNecessityEnumDynamicObjectMap = DimensionDyUtil.loopDoDimensionNecessity((Long)this.anaModelId, dimension -> dimension);
        }
        return this.dimensionNecessityEnumDynamicObjectMap.get(dimensionNecessityEnum);
    }

    public Long getAnaSystemId() {
        return this.anaSystemId;
    }

    public void setAnaSystemId(Long anaSystemId) {
        this.anaSystemId = anaSystemId;
    }

    public Long getAnaModelId() {
        return this.anaModelId;
    }

    public void setAnaModelId(Long anaModelId) {
        this.anaModelId = anaModelId;
    }

    public String getTableNumber() {
        return this.tableNumber;
    }

    public void setTableNumber(String tableNumber) {
        this.tableNumber = tableNumber;
    }

    public Map<String, List<String>> getDimensionNumberFieldNumbersMap() {
        return this.dimensionNumberFieldNumbersMap;
    }

    public void setDimensionNumberFieldNumbersMap(Map<String, List<String>> dimensionNumberFieldNumbersMap) {
        this.dimensionNumberFieldNumbersMap = dimensionNumberFieldNumbersMap;
    }

    public Map<String, List<String>> getDimensionNumberFieldNamesMap() {
        return this.dimensionNumberFieldNamesMap;
    }

    public void setDimensionNumberFieldNamesMap(Map<String, List<String>> dimensionNumberFieldNamesMap) {
        this.dimensionNumberFieldNamesMap = dimensionNumberFieldNamesMap;
    }

    public List<String> getMeasureNumbers() {
        return this.measureNumbers;
    }

    public void setMeasureNumbers(List<String> measureNumbers) {
        this.measureNumbers = measureNumbers;
    }

    public ReportQueryParam getQueryParam() {
        return this.queryParam;
    }

    public void setQueryParam(ReportQueryParam queryParam) {
        this.queryParam = queryParam;
    }

    public DataQueryTypeEnum getDataQueryTypeEnum() {
        return this.dataQueryTypeEnum;
    }

    public void setDataQueryTypeEnum(DataQueryTypeEnum dataQueryTypeEnum) {
        this.dataQueryTypeEnum = dataQueryTypeEnum;
    }
}

