/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataquery.func;

import java.io.IOException;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.framework.gray.LongIdSet;
import kd.bos.framework.gray.LongIdSetFactory;

public class DataDetailMarkPassMapFunction
extends MapFunction {
    private static final long serialVersionUID = -2967331791052499516L;
    private final Long conditionId;
    private final Integer markPassIndex;
    private final String idSetSer;

    public DataDetailMarkPassMapFunction(RowMeta rowMeta, Long conditionId) {
        this.sourceRowMeta = rowMeta;
        this.conditionId = conditionId;
        this.markPassIndex = rowMeta.getFieldIndex("_markpass_tag", false);
        LongIdSet longIdSet = LongIdSetFactory.createLong();
        longIdSet.add(conditionId.longValue());
        try {
            this.idSetSer = LongIdSetFactory.seriablize((LongIdSet)longIdSet);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowX map(RowX rowX) {
        if (this.markPassIndex == -1) return rowX;
        String markPass = rowX.getString(this.markPassIndex.intValue());
        if (StringUtils.isNotEmpty((CharSequence)markPass)) {
            try {
                LongIdSet longIdSet = LongIdSetFactory.deSeriablize((String)markPass);
                if (longIdSet.exist(this.conditionId.longValue())) return rowX;
                longIdSet.add(this.conditionId.longValue());
                String idSer = LongIdSetFactory.seriablize((LongIdSet)longIdSet);
                rowX.set(this.markPassIndex.intValue(), (Object)idSer);
                return rowX;
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
        } else {
            rowX.set(this.markPassIndex.intValue(), (Object)this.idSetSer);
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }
}

