/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataquery.func;

import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.orm.util.CollectionUtils;

public class FAFQingAnalysisEnumDimensionMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private final RowMeta rowMeta;
    private final Map<String, Map<Object, String>> enumDimensionDataMap;

    public FAFQingAnalysisEnumDimensionMapFunction(RowMeta rowMeta, Map<String, Map<Object, String>> enumDimensionDataMap) {
        this.enumDimensionDataMap = enumDimensionDataMap;
        Field[] fields = rowMeta.getFields();
        Field[] newField = new Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            newField[i] = fields[i];
            if (!enumDimensionDataMap.containsKey(fields[i].getName())) continue;
            newField[i].setDataType((DataType)DataType.StringType);
        }
        this.rowMeta = new RowMeta(newField);
    }

    public Object[] map(Row row) {
        Object[] rowValues = ((AbstractRow)row).values();
        Field[] fields = this.rowMeta.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Map<Object, String> enumItemMap = this.enumDimensionDataMap.get(fields[i].getName());
            if (CollectionUtils.isEmpty(enumItemMap)) continue;
            Object enumKey = rowValues[i];
            rowValues[i] = enumItemMap.getOrDefault(enumKey, String.valueOf(enumKey));
        }
        return rowValues;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

