/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataquery.func;

import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.datatype.DateType;

public class FAFReportDateTimeFormatFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final List<Integer> offsetTimeStampField = new ArrayList<Integer>(4);

    public FAFReportDateTimeFormatFunction(RowMeta rowMeta) {
        this.setSourceRowMeta(rowMeta);
        int index = 0;
        for (Field field : rowMeta.getFields()) {
            DataType dataType = field.getDataType();
            if (dataType == DateType.DateType || dataType == DateType.TimestampType) {
                this.offsetTimeStampField.add(index);
            }
            ++index;
        }
    }

    public Object[] map(Row row) {
        Object[] rowValues = ((AbstractRow)row).values();
        for (Integer offset : this.offsetTimeStampField) {
            Object rowValue = rowValues[offset];
            if (rowValue == null) continue;
            rowValues[offset.intValue()] = ((Timestamp)rowValue).toLocalDateTime().format(this.dateFormatter);
        }
        return rowValues;
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = super.getSourceRowMeta();
        Field[] fields = sourceRowMeta.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field oldField = fields[i];
            if (!this.offsetTimeStampField.contains(i)) continue;
            oldField.setDataType((DataType)DataType.StringType);
        }
        return new RowMeta(fields);
    }
}

