/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dataquery.func;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.helper.FAFMeasureHelper;

public class FAFReportPrecisionFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Integer> precisionMap;

    public FAFReportPrecisionFunction(RowMeta rowMeta, Long anaModelId) {
        this.setSourceRowMeta(rowMeta);
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)anaModelId, (String)"pa_analysismodel");
        List measureNumberList = analysisModel.getDynamicObjectCollection("measure_entry").stream().map((? super T x) -> x.getDynamicObject("measure").getString("number")).collect(Collectors.toList());
        Map measureScaleMap = FAFMeasureHelper.getMeasureScaleMap((Long)analysisModel.getLong("analysis_system_id"), measureNumberList);
        this.precisionMap = measureScaleMap.entrySet().stream().collect(Collectors.toMap(entry -> this.sourceRowMeta.getFieldIndex((String)entry.getKey(), false), Map.Entry::getValue));
    }

    public Object[] map(Row row) {
        Object[] rowValues = ((AbstractRow)row).values();
        if (this.precisionMap != null) {
            for (Map.Entry<Integer, Integer> entry : this.precisionMap.entrySet()) {
                Integer index = entry.getKey();
                if (index == -1) continue;
                if (rowValues[index] instanceof BigDecimal) {
                    rowValues[index.intValue()] = ((BigDecimal)rowValues[index]).setScale((int)entry.getValue(), RoundingMode.HALF_UP);
                    continue;
                }
                rowValues[index.intValue()] = new BigDecimal(rowValues[index] == null ? "0" : rowValues[index].toString()).setScale((int)entry.getValue(), RoundingMode.HALF_UP);
            }
        }
        return rowValues;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }
}

