/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.dataquery.IDataQuery;
import kd.macc.faf.dataquery.dto.ModelDynamicVO;
import kd.macc.faf.dataquery.dto.TraceInfo;
import kd.macc.faf.enums.DataStatusEnum;

public class AnalysisModelDataQuery
implements IDataQuery {
    private static final String ALGO_KEY = "FAF-AnalysisModelDataQuery";
    private final ModelDynamicVO modelVo;

    public AnalysisModelDataQuery(Long modelId) {
        this.modelVo = new ModelDynamicVO(modelId);
    }

    public ModelDynamicVO getModelVo() {
        return this.modelVo;
    }

    @Override
    public TraceInfo trace(Long detailId) {
        TraceInfo traceInfo = new TraceInfo();
        String entityname_d = this.modelVo.getEntityname_D();
        String fields = "datastatus,execlogid,subexeclogid,execparentbillid,sourcebillid";
        QFilter qFilter = new QFilter("id", "=", (Object)detailId);
        DynamicObject dynDetail = QueryServiceHelper.queryOne((String)entityname_d, (String)fields, (QFilter[])qFilter.toArray());
        String datastatus = dynDetail.getString("datastatus");
        Long execparentbillid = dynDetail.getLong("execparentbillid");
        Long execlogid = dynDetail.getLong("execlogid");
        DataStatusEnum statusEnum = DataStatusEnum.getEnum((String)datastatus);
        if (statusEnum.eq((Object)DataStatusEnum.WRITE_OFF)) {
            traceInfo.setSourceEntityname(this.modelVo.getEntityname_D());
            traceInfo.setMergeData(false);
            traceInfo.setSourceId(execparentbillid);
            DynamicObject executionLog = QueryServiceHelper.queryOne((String)statusEnum.getSubExecEntityname(), (String)"detailtime", (QFilter[])new QFilter("id", "=", (Object)execlogid).toArray());
            if (executionLog != null) {
                Long executionTime = executionLog.getLong("detailtime");
                traceInfo.setExecTime(executionTime);
            }
            traceInfo.setTargetEntityname(this.modelVo.getEntityname_D());
            traceInfo.getTargetQfilters().add(qFilter);
        } else {
            traceInfo.setSourceEntityname(this.modelVo.getEntityname());
            traceInfo.setMergeData(true);
            traceInfo.setSourceId(execparentbillid);
            Long subexeclogid = dynDetail.getLong("subexeclogid");
            DynamicObject dynexecparent = QueryServiceHelper.queryOne((String)statusEnum.getSubExecEntityname(), (String)"detailtime", (QFilter[])new QFilter("id", "=", (Object)subexeclogid).toArray());
            if (dynexecparent != null) {
                Long executionTime = dynexecparent.getLong("detailtime");
                traceInfo.setExecTime(executionTime);
            }
            QFilter filter = new QFilter("execparentbillid", "=", (Object)execparentbillid).and("execlogid", "=", (Object)execlogid).and("subexeclogid", "=", (Object)subexeclogid);
            traceInfo.setTargetEntityname(this.modelVo.getEntityname_D());
            traceInfo.getTargetQfilters().add(filter);
        }
        return traceInfo;
    }

    @Override
    public TraceInfo traceSummary(Long summaryId) {
        TraceInfo traceInfo = new TraceInfo();
        return traceInfo;
    }

    public DataSet queryTraceDataSet(TraceInfo trace) {
        return null;
    }
}

