/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.macc.faf.datasource.dto.MemberScope;
import kd.macc.faf.datasource.ext.BCMMemberScopeEnum;

public class DimensionFetchScope
implements Serializable {
    private static final long serialVersionUID = -3823589726904770159L;
    private String dimNumber;
    private List<MemberScope> members;

    public String getDimNumber() {
        return this.dimNumber;
    }

    public void setDimNumber(String dimNumber) {
        this.dimNumber = dimNumber;
    }

    public void setMembers(List<MemberScope> members) {
        this.members = members;
    }

    public List<MemberScope> getMembers() {
        if (this.members == null) {
            this.members = new ArrayList<MemberScope>();
        }
        return this.members;
    }

    public String toDescText() {
        List<MemberScope> scopes = this.getMembers();
        String text = scopes.stream().limit(3L).map(scope -> scope.getName() + "\uff1a" + BCMMemberScopeEnum.getEnum(scope.getScope()).getText()).collect(Collectors.joining("\uff1b"));
        String substring = text.substring(0, Math.min(text.length(), 200));
        if (scopes.size() > 3 || text.length() > 200) {
            substring = substring + "...";
        }
        return substring;
    }

    public String toTagText() {
        List<MemberScope> scopes = this.getMembers();
        if (scopes.isEmpty()) {
            return "";
        }
        return SerializationUtils.toJsonString((Object)this);
    }
}

