/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource.dynamic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.datasource.dto.DimensionFetchScope;
import kd.macc.faf.datasource.dto.MemberScope;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasync.exec.input.bcm.BcmApiFilter;
import kd.macc.faf.enums.OlapFromServiceEnum;

public class BcmDataSource
extends DataSource {
    private static final long serialVersionUID = -4879621848977277880L;
    private final List<DimensionFetchScope> fetchScopes = new ArrayList<DimensionFetchScope>();
    private String modelNum;
    private List<BcmApiFilter> filters;
    private List<MemberScope> scenarios;

    public BcmDataSource(DynamicObject dynamicObject) {
        super(dynamicObject);
        this.init();
    }

    private void init() {
        boolean synctype = this.getDynamic().getBoolean("synctype");
        if (synctype) {
            DynamicObjectCollection entryentity = this.getDynamic().getDynamicObjectCollection("entryentityfilterapi");
            for (DynamicObject dynamic : entryentity) {
                DimensionFetchScope scope;
                String textfilterTag = dynamic.getString("textfilter_tag");
                String dimNumber = dynamic.getString("bcmdimension.number");
                if ("Scenario".equals(dimNumber)) {
                    scope = (DimensionFetchScope)SerializationUtils.fromJsonString((String)textfilterTag, DimensionFetchScope.class);
                    this.scenarios = scope.getMembers();
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)textfilterTag)) continue;
                scope = (DimensionFetchScope)SerializationUtils.fromJsonString((String)textfilterTag, DimensionFetchScope.class);
                scope.setDimNumber(dimNumber);
                this.fetchScopes.add(scope);
            }
            if (this.scenarios == null || this.scenarios.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\uff08%1$s\uff09\u8bf7\u8f93\u5165\u60c5\u666f\u7ef4\u5ea6\u7684\u53d6\u6570\u8303\u56f4\u3002", (String)"BcmDataSource_0", (String)"macc-faf-business", (Object[])new Object[0]), this.getDynamic().getString("number")));
            }
        }
    }

    public String getModelNum() {
        if (this.modelNum == null) {
            Map<String, Object> settingMap = this.getParamsSettingMap();
            Object sytemPkvalue = settingMap.get("system");
            QFilter qFilter = new QFilter("id", "=", sytemPkvalue);
            try (DataSet dataSet = ORM.create().queryDataSet("BcmDataSource_orm", "bcm_model", "number", qFilter.toArray(), null, 1);){
                Iterator iterator = dataSet.iterator();
                if (iterator.hasNext()) {
                    String string = this.modelNum = ((Row)iterator.next()).getString("number");
                    return string;
                }
            }
            throw new KDBizException("BcmDataSource not find modelNum");
        }
        return this.modelNum;
    }

    public Object getImportSystemId() {
        Map<String, Object> settingMap = this.getParamsSettingMap();
        return settingMap.get("system");
    }

    public List<String> getScenarioMembers() {
        return this.scenarios.stream().map(MemberScope::getNumber).collect(Collectors.toList());
    }

    public List<BcmApiFilter> getFilters() {
        if (this.filters == null) {
            this.generatorFilters();
        }
        return this.filters;
    }

    private void generatorFilters() {
        HashMap<String, BcmApiFilter> filterMap = new HashMap<String, BcmApiFilter>();
        for (DimensionFetchScope fetchScope : this.fetchScopes) {
            String dimNumber = fetchScope.getDimNumber();
            List<MemberScope> members = fetchScope.getMembers();
            for (MemberScope member : members) {
                String scope = member.getScope();
                String number = member.getNumber();
                String key = dimNumber + "_" + scope;
                BcmApiFilter filter = (BcmApiFilter)filterMap.get(key);
                if (filter == null) {
                    BcmApiFilter newFilter = new BcmApiFilter(dimNumber, scope);
                    newFilter.getVal().add(number);
                    filterMap.put(key, newFilter);
                    continue;
                }
                filter.getVal().add(number);
            }
        }
        this.filters = new ArrayList(filterMap.values());
    }

    private Map<String, Object> getParamsSettingMap() {
        String setting = this.getDynamic().getString("paramsrc_tag");
        if (ObjectUtils.isEmpty((Object)setting)) {
            throw new KDBizException("datasource setting params is empty.");
        }
        return (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
    }

    @Override
    public String getEntityNumber() {
        return OlapFromServiceEnum.BCM.getCode();
    }
}

