/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource.dynamic;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.FlexProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasource.dynamic.FlexSourceField;

public class EntityDataSource
extends DataSource {
    private static final long serialVersionUID = 1L;
    private final Map<Object, Map<String, FlexSourceField>> flexFieldMap = new HashMap<Object, Map<String, FlexSourceField>>(2);
    private Map<String, DynamicObject> comassistMap;
    private MainEntityType entityType;
    private Map<String, FlexProp> flexMap;

    public EntityDataSource(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    @Override
    public List<QFilter> getQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        String conditionJson = this.getDynamic().getString("entityfilter_tag");
        if (StringUtils.isEmpty((CharSequence)conditionJson)) {
            return list;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
        MainEntityType number = EntityMetadataCache.getDataEntityType((String)this.getEntityNumber());
        FilterBuilder filterBuilder = new FilterBuilder(number, filterCondition);
        filterBuilder.buildFilter(false);
        QFilter qFilter = filterBuilder.getQFilter();
        if (qFilter != null) {
            list.add(qFilter);
        }
        return list;
    }

    @Override
    public String getEntityNumber() {
        return this.getDynamic().getString("entity_number_id");
    }

    public MainEntityType getMainEntityType() {
        String entityNumber = this.getEntityNumber();
        if (this.entityType == null && StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            this.entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        return this.entityType;
    }

    public IDataEntityProperty getFieldType(String sourceNumber) {
        if (sourceNumber != null) {
            String[] split = sourceNumber.split("\\.");
            MainEntityType mainEntityType = this.getMainEntityType();
            if (mainEntityType != null && split.length > 0) {
                return (IDataEntityProperty)mainEntityType.getAllFields().get(split[split.length - 1]);
            }
        }
        return null;
    }

    public Map<String, FlexProp> getFlexFieldSourceMap() {
        if (this.flexMap == null) {
            this.flexMap = new HashMap<String, FlexProp>();
            String entityNumber = this.getEntityNumber();
            if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                Collection properties = dataEntityType.getAllFields().values();
                for (IDataEntityProperty property : properties) {
                    if (!(property instanceof FlexProp)) continue;
                    FlexProp prop = (FlexProp)property;
                    AbstractMap.SimpleEntry path = FAFUtils.getPathPropertyName((IDataEntityProperty)property);
                    this.flexMap.put((String)path.getKey(), prop);
                }
            }
        }
        return this.flexMap;
    }

    public Map<String, FlexSourceField> getFlexPropertyMap(FlexProp flexProp) {
        Map<String, FlexSourceField> sourceFieldMap = this.flexFieldMap.get(flexProp.getFlexTypeId());
        if (sourceFieldMap == null) {
            HashMap<String, FlexSourceField> map = new HashMap<String, FlexSourceField>();
            long flexid = flexProp.getFlexTypeId();
            try (DataSet dataSet = ORM.create().queryDataSet("faf.datasource.flex_property", "bos_flex_property", "flexid,number,name,flexfield,valuetype,valuesource,assistanttype,manuallydatatype", new QFilter("flexid", "=", (Object)flexid).toArray());){
                for (Row row : dataSet) {
                    FlexSourceField field = new FlexSourceField(flexProp);
                    field.setNumber(row.getString("number"));
                    field.setName(row.getString("name"));
                    field.setFlexfield(row.getString("flexfield"));
                    field.setValuetype(row.getString("valuetype"));
                    field.setValuesource(row.getString("valuesource"));
                    field.setAssistanttype(row.getLong("assistanttype"));
                    field.setDatatype(row.getString("manuallydatatype"));
                    map.put(field.getFlexfield(), field);
                }
            }
            this.flexFieldMap.put(flexProp.getFlexTypeId(), map);
        }
        return this.flexFieldMap.get(flexProp.getFlexTypeId());
    }

    public Map<String, FlexSourceField> getFlexField(String dimensionfield) {
        if (StringUtils.isEmpty((CharSequence)dimensionfield)) {
            return Collections.emptyMap();
        }
        HashMap<String, FlexSourceField> map = new HashMap<String, FlexSourceField>(1);
        Map<String, FlexProp> flexMap = this.getFlexFieldSourceMap();
        Set<Map.Entry<String, FlexProp>> entries = flexMap.entrySet();
        for (Map.Entry<String, FlexProp> entry : entries) {
            String flexKey = entry.getKey();
            if (!dimensionfield.startsWith(flexKey + "_f")) continue;
            String foooxx = dimensionfield.substring(flexKey.length() + 1);
            FlexProp flexProp = flexMap.get(flexKey);
            Map<String, FlexSourceField> flexPropertyMap = this.getFlexPropertyMap(flexProp);
            FlexSourceField field = flexPropertyMap.get(foooxx);
            if (field == null) continue;
            map.put(flexKey, field);
        }
        return map;
    }

    public Map<String, DynamicObject> getComassist(DynamicObject dimensionDyn) {
        if (this.comassistMap == null) {
            this.comassistMap = new LinkedHashMap<String, DynamicObject>();
            try {
                if (Objects.equals("accounttable", dimensionDyn.getString("typefield"))) {
                    DynamicObject accountDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionDyn.get("group_id"), (String)"bd_accounttable");
                    DynamicObjectCollection collection = accountDyn.getDynamicObjectCollection("comassistentry");
                    if (!collection.isEmpty()) {
                        this.comassistMap.put("comassist1", (DynamicObject)collection.get(0));
                    }
                    if (collection.size() > 1) {
                        this.comassistMap.put("comassist2", (DynamicObject)collection.get(1));
                    }
                }
            }
            catch (Exception ex) {
                logger.info("parse comassist dimension erro.", (Object)ex);
            }
        }
        return this.comassistMap;
    }
}

