/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource.dynamic;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.olap.OlapServerBaseMetaInfo;
import kd.macc.faf.olap.driver.OlapRequestParam;
import kd.macc.faf.olap.driver.ParamBuilder;
import kd.macc.faf.olap.driver.RequestFactoryBuilder;

public class EpmDataSource
extends DataSource {
    private static final long serialVersionUID = -5307642069066197967L;
    private String modelNum;

    public EpmDataSource(DynamicObject dynamicObject) {
        super(dynamicObject);
    }

    public String getModelNum() {
        if (this.modelNum == null) {
            Map<String, Object> settingMap = this.getParamsSettingMap();
            Object sytemPkvalue = settingMap.get("system");
            QFilter qFilter = new QFilter("id", "=", sytemPkvalue);
            try (DataSet dataSet = ORM.create().queryDataSet("EpmDataSource_orm", "epm_model", "number", qFilter.toArray(), null, 1);){
                Iterator iterator = dataSet.iterator();
                if (iterator.hasNext()) {
                    String string = this.modelNum = ((Row)iterator.next()).getString("number");
                    return string;
                }
            }
            throw new KDBizException("EpmDataSource not find modelNum");
        }
        return this.modelNum;
    }

    public Object getImportSystemId() {
        Map<String, Object> settingMap = this.getParamsSettingMap();
        return settingMap.get("system");
    }

    private Map<String, Object> getParamsSettingMap() {
        String setting = this.getDynamic().getString("paramsrc_tag");
        if (ObjectUtils.isEmpty((Object)setting)) {
            throw new KDBizException("datasource setting params is empty.");
        }
        return (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
    }

    public Set<Long> getAllEpmDimensionIds() {
        OlapFromServiceEnum olapFromServiceEnum = OlapFromServiceEnum.getEnum((String)this.getType().getCode());
        if (olapFromServiceEnum == null) {
            return Collections.emptySet();
        }
        String setting = this.getDynamic().getString("paramsrc_tag");
        OlapRequestParam param1 = ParamBuilder.getParam((OlapFromServiceEnum)olapFromServiceEnum, (String)setting);
        Map allDim = RequestFactoryBuilder.getAllDim((OlapFromServiceEnum)olapFromServiceEnum, param -> param1);
        return allDim.values().stream().map(OlapServerBaseMetaInfo::getId).collect(Collectors.toSet());
    }

    @Override
    public String getEntityNumber() {
        return OlapFromServiceEnum.EPM.getCode();
    }
}

