/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource.dynamic;

import java.io.Serializable;
import java.util.Objects;
import kd.bos.algo.DataType;
import kd.bos.algo.input.OrmInput;
import kd.bos.entity.property.FlexProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;

public class FlexSourceField
implements Serializable {
    private static final long serialVersionUID = -2385297449645912595L;
    private final FlexProp prop;
    private String number;
    private String name;
    private String flexfield;
    private String valuetype;
    private String valuesource;
    private Long assistanttype;
    private String datatype;

    public FlexSourceField(FlexProp prop) {
        this.prop = prop;
    }

    public String getFormNumber() {
        String formNumber;
        if (Objects.equals(this.prop.getFlexTypeId(), 1)) {
            formNumber = "bd_flexauxprop";
        } else if (Objects.equals(this.prop.getFlexTypeId(), 2)) {
            formNumber = "gl_assist";
        } else {
            throw new KDBizException("not support FlexProp " + this.prop.getName());
        }
        if (Objects.equals(this.getValuetype(), "3")) {
            return formNumber + "_txt";
        }
        return formNumber + "_bd";
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFlexfield() {
        return this.flexfield;
    }

    public void setFlexfield(String flexfield) {
        this.flexfield = flexfield;
    }

    public String getValuetype() {
        return this.valuetype;
    }

    public void setValuetype(String valuetype) {
        this.valuetype = valuetype;
    }

    public DataType getDataType() {
        if (Objects.equals(this.getValuetype(), "3")) {
            return DataType.StringType;
        }
        return DataType.LongType;
    }

    public String getValuesource() {
        return this.valuesource;
    }

    public void setValuesource(String valuesource) {
        this.valuesource = valuesource;
    }

    public Long getAssistanttype() {
        return this.assistanttype;
    }

    public void setAssistanttype(Long assistanttype) {
        this.assistanttype = assistanttype;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public FlexProp getProp() {
        return this.prop;
    }

    public OrmInput getOrmInput() {
        String formNumber = this.getFormNumber();
        return new OrmInput("faf-sync-data-flex", formNumber, this.getTableSelectFiled(), new QFilter(this.getTableFlexfieldKey(), "=", (Object)this.getFlexfield()).toArray());
    }

    private String getTableSelectFiled() {
        if (Objects.equals(this.prop.getFlexTypeId(), 1)) {
            return "hg, auxpropval as " + this.getFlexfield();
        }
        if (Objects.equals(this.prop.getFlexTypeId(), 2)) {
            return "hg, assval as " + this.getFlexfield();
        }
        throw new KDBizException("not support FlexProp " + this.prop.getName());
    }

    private String getTableFlexfieldKey() {
        if (Objects.equals(this.prop.getFlexTypeId(), 1)) {
            return "auxproptype";
        }
        if (Objects.equals(this.prop.getFlexTypeId(), 2)) {
            return "asstype";
        }
        throw new KDBizException("not support FlexProp " + this.prop.getName());
    }
}

