/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasource.dynamic.BcmDataSource;
import kd.macc.faf.datasource.dynamic.DataSource;
import kd.macc.faf.datasource.dynamic.EntityDataSource;
import kd.macc.faf.datasource.dynamic.EpmDataSource;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncSchema;
import kd.macc.faf.datasync.exec.impl.BcmSyncSchema;
import kd.macc.faf.datasync.exec.impl.EntitySyncSchema;
import kd.macc.faf.datasync.exec.impl.EpmSyncSchema;
import kd.macc.faf.datasync.exec.impl.GlBalanceSyncSchema;
import kd.macc.faf.datasync.exec.impl.InvSyncSchema;
import kd.macc.faf.enums.DataSourceTypeEnum;

public class BusinessDynamicObjectFactory {
    public static DynamicObject loadDynamicObject(Object object, String entityName) {
        if (object instanceof DynamicObject) {
            return (DynamicObject)object;
        }
        if (object instanceof Long) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)object, (String)entityName);
        }
        throw new KDBizException("create BusinessDynamicObject fail. entityName is " + entityName);
    }

    public static DataSource createDataSource(Object object) {
        DynamicObject dynamic = BusinessDynamicObjectFactory.loadDynamicObject(object, "pa_datasourceconfig");
        DataSourceTypeEnum sourceTypeEnum = DataSourceTypeEnum.getEnum((String)dynamic.getString("datasource_type"));
        if (sourceTypeEnum == DataSourceTypeEnum.BCM) {
            return new BcmDataSource(dynamic);
        }
        if (sourceTypeEnum == DataSourceTypeEnum.EPM) {
            return new EpmDataSource(dynamic);
        }
        return new EntityDataSource(dynamic);
    }

    public static DataSyncDimension createDataSyncDimension(Object object) {
        DynamicObject dynamic = BusinessDynamicObjectFactory.loadDynamicObject(object, "pa_dimension");
        return new DataSyncDimension(dynamic);
    }

    public static DataSyncModel createDataSyncModel(Object object) {
        DynamicObject dynamic = BusinessDynamicObjectFactory.loadDynamicObject(object, "pa_analysismodel");
        return new DataSyncModel(dynamic);
    }

    public static <T extends DataSyncSchema<? extends DataSource>> T createDataSyncSchema(Object object) {
        DynamicObject schemaDynamic = BusinessDynamicObjectFactory.loadDynamicObject(object, "pa_syncdataschema");
        long modelPkvalue = schemaDynamic.getLong("analysismodel_id");
        long datasourcePkvalue = schemaDynamic.getLong("datasource_id");
        if (modelPkvalue == 0L || datasourcePkvalue == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u6216\u5206\u6790\u6a21\u578b\u4e3a\u7a7a\u3002", (String)"BusinessDynamicObjectFactory_0", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        DataSyncModel dataSyncModel = BusinessDynamicObjectFactory.createDataSyncModel(modelPkvalue);
        DataSource dataSource = BusinessDynamicObjectFactory.createDataSource(datasourcePkvalue);
        DataSourceTypeEnum sourceType = dataSource.getType();
        switch (sourceType) {
            case BCM: {
                return (T)((DataSyncSchema)FAFUtils.cast((Object)new BcmSyncSchema(schemaDynamic, dataSyncModel, dataSource)));
            }
            case EPM: {
                return (T)((DataSyncSchema)FAFUtils.cast((Object)new EpmSyncSchema(schemaDynamic, dataSyncModel, dataSource)));
            }
            case INV_PERIODBALANCE: {
                return (T)((DataSyncSchema)FAFUtils.cast((Object)new InvSyncSchema(schemaDynamic, dataSyncModel, dataSource)));
            }
            case GLBALANCE: {
                return (T)((DataSyncSchema)FAFUtils.cast((Object)new GlBalanceSyncSchema(schemaDynamic, dataSyncModel, dataSource)));
            }
            case TEMPPORARY: 
            case VOUCHER: 
            case BIZVOUCHER: {
                return (T)((DataSyncSchema)FAFUtils.cast((Object)new EntitySyncSchema(schemaDynamic, dataSyncModel, dataSource)));
            }
        }
        throw new KDBizException("not support datasource type. sourceType: " + sourceType);
    }
}

