/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.LongType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.algox.FAFExecuteDB;
import kd.macc.faf.algox.FAFJoinLinkInfo;
import kd.macc.faf.algox.FAFSQLBuilder;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.datasync.DimConditionDTO;
import kd.macc.faf.datasync.FAFDataSyncPOJO;
import kd.macc.faf.datasync.exec.data.DataSyncSchema;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.datasync.model.MultiClassDimensionInfo;
import kd.macc.faf.datasync.transformer.DateConversionTransFormer;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.SelectTypeEnum;
import kd.macc.faf.enums.TimeTypeEnum;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.helper.FAFDataSourceConfigHelper;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CalculateCondition;
import kd.macc.faf.util.EntityUtils;
import kd.macc.faf.util.ScriptBuilder;

public class FAFDataSyncDTO {
    private static final Log logger = LogFactory.getLog(FAFDataSyncDTO.class);
    protected final DynamicObject model;
    protected final Object[] orgIds;
    protected final Object[] periodIds;
    private final boolean haveTime;
    private final boolean createStamp;
    private final String timeType;
    private final Date startDate;
    private final Date endDate;
    protected DynamicObject scheme;
    protected Map<String, String> fieldMappings = new HashMap<String, String>(10);
    protected Map<String, String> conditionMap = new HashMap<String, String>(10);
    protected Set<String> selectFieldSet = new HashSet<String>(10);
    protected Map<String, Object> defaultValueMap = new HashMap<String, Object>(10);
    protected String dataSourceNumber;
    protected DataSourceTypeEnum entityType;
    protected QFilter[] qFilter;
    protected String tableNumber;
    protected String collectTableNumber;
    protected Set<String> flexFields = new HashSet<String>(10);
    protected Set<String> subEntryFlexSet = new HashSet<String>(10);
    protected Set<String> assTypeSet = new HashSet<String>(10);
    private String orgNumber;
    private String periodNumber;
    private String entryEntityNumber;
    private final Map<String, Map<String, String>> transFormMap = new HashMap<String, Map<String, String>>(10);
    private Map<String, String> extraIdMap = new HashMap<String, String>(10);
    private MainEntityType billEntity;
    private List<DimConditionDTO> dimConditionDTOS = new ArrayList<DimConditionDTO>(10);
    private Long accountTableId;
    private List<MultiClassDimensionInfo> multiClassDimensionInfoList = new ArrayList<MultiClassDimensionInfo>(10);
    private Set<String> needRemoveField = new HashSet<String>(Arrays.asList("entryentity.subentryentity.flexfield", "entryentity.subentryentity.value"));

    public FAFDataSyncDTO(DynamicObject model, DynamicObject scheme, Object[] orgIds, Object[] periodIds, String timeType, Date startDate, Date endDate) {
        this.model = model;
        this.orgIds = orgIds;
        this.periodIds = periodIds;
        this.tableNumber = "t_" + AnalysisModelUtil.buildDetailEntityNumber((String)model.getString("tablenumber"));
        this.collectTableNumber = "t_" + AnalysisModelUtil.buildEntityNumber((String)model.getString("tablenumber"));
        this.haveTime = EntityMetadataCache.getDataEntityType((String)AnalysisModelUtil.buildDetailEntityNumber((String)model.getString("tablenumber"))).getProperty("createtime") != null;
        this.createStamp = EntityMetadataCache.getDataEntityType((String)AnalysisModelUtil.buildDetailEntityNumber((String)model.getString("tablenumber"))).getProperty("createstamp") != null;
        this.timeType = timeType;
        this.startDate = startDate;
        this.endDate = endDate;
        this.billEntity = EntityMetadataCache.getDataEntityType((String)AnalysisModelUtil.buildEntityNumber((String)model.getString("tablenumber")));
        this.parseModel();
        if (scheme != null) {
            this.scheme = scheme;
            if (scheme.getDynamicObject("datasource").getDynamicObject("entity_number") != null) {
                this.dataSourceNumber = scheme.getDynamicObject("datasource").getDynamicObject("entity_number").getString("number");
            }
            this.entityType = DataSourceTypeEnum.getEnum((String)scheme.getDynamicObject("datasource").getString("datasource_type"));
            this.initSubEntryFlexSet(scheme);
            if (this.entityType != DataSourceTypeEnum.BCM && this.entityType != DataSourceTypeEnum.EPM) {
                this.createFieldMappingsAndConditionMap();
                this.acquireSelectFieldSet();
                this.buildDefaultMap();
            }
        }
    }

    private void createFieldMappingsAndConditionMap() {
        DynamicObjectCollection dimEntry = this.scheme.getDynamicObjectCollection("dimensionmapentry");
        DynamicObjectCollection measureEntry = this.scheme.getDynamicObjectCollection("measuremapentry");
        Map<String, DynamicObject> dynamicObjectMap = dimEntry.stream().collect(Collectors.toMap(dyn -> dyn.getString("dimension.number"), dyn -> dyn));
        for (DynamicObject dim : dimEntry) {
            String dimField = dim.getString("dimensionfield");
            if (!StringUtils.isNotEmpty((CharSequence)dimField)) continue;
            String dimensionNumber = dim.getString("dimension.number");
            this.fieldMappings.put(dimensionNumber, dimField);
            String conditionTag = dim.getString("dimconditionval_tag");
            if (!StringUtils.isNotEmpty((CharSequence)conditionTag)) continue;
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionTag, FilterCondition.class);
            CRCondition crCondition = new CRCondition();
            crCondition.setFilterCondition(filterCondition);
            String condition = crCondition.buildFullFormula(this.billEntity);
            DimConditionDTO dimConditionDTO = new DimConditionDTO(condition, dimensionNumber);
            this.dimConditionDTOS.add(dimConditionDTO);
            for (SimpleFilterRow simpleFilterRow : filterCondition.getFilterRow()) {
                String fieldName = simpleFilterRow.getFieldName();
                if (fieldName.contains(".")) {
                    String[] split = fieldName.split("\\.");
                    String substring = fieldName.substring(fieldName.indexOf(".") + 1);
                    DynamicObject conditionDim = dynamicObjectMap.get(split[0]);
                    String joinKey = conditionDim.getString("dimension.number");
                    String dimType = conditionDim.getString("dimension.dimensiontype");
                    if ("1".equals(dimType)) {
                        String source = conditionDim.getString("dimension.dimensionsource.number");
                        String alias = joinKey + "_condition_" + substring;
                        this.addTansFormMap(source, joinKey, substring + " as " + alias);
                        dimConditionDTO.addFieldMap(fieldName, alias);
                        continue;
                    }
                    if (!"2".equals(dimType)) continue;
                    String alias = joinKey + "_condition_" + substring;
                    this.addTansFormMap("bos_assistantdata_detail", joinKey, substring + " as " + alias);
                    dimConditionDTO.addFieldMap(fieldName, alias);
                    continue;
                }
                dimConditionDTO.addFieldMap(fieldName, fieldName);
            }
        }
        for (DynamicObject measure : measureEntry) {
            String selectType = measure.getString("selecttype");
            if (SelectTypeEnum.CONDITION.getCode().equals(selectType)) {
                String condition = measure.getString("condition_tag");
                this.conditionMap.put(measure.getString("measure.number"), condition);
                continue;
            }
            if (SelectTypeEnum.MEASUREFIELD.getCode().equals(selectType)) {
                this.fieldMappings.put(measure.getString("measure.number"), measure.getString("measurefield"));
                continue;
            }
            if (!SelectTypeEnum.DIMMEASUREFIELD.getCode().equals(selectType)) continue;
            this.fieldMappings.put(measure.getString("measure.number"), measure.getString("dimmeasurefield"));
        }
    }

    public String filterToExpress(FilterCondition filterCondition) {
        ScriptBuilder scriptBuilder = new ScriptBuilder(this.billEntity, filterCondition);
        ScriptBuilder.ValueAndDesc buildScripts = scriptBuilder.buildScript();
        return buildScripts.getValue();
    }

    private void acquireSelectFieldSet() {
        this.selectFieldSet.add("id");
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)this.dataSourceNumber);
        Map allFields = billType.getAllFields();
        Map allEntities = billType.getAllEntities();
        List flexProperty = null;
        flexProperty = EntityMetaHelper.matchFlexProperty((String)this.dataSourceNumber);
        if (DataSourceTypeEnum.BIZVOUCHER == this.entityType) {
            this.selectFieldSet.add("entryentity");
        } else if (DataSourceTypeEnum.VOUCHER == this.entityType) {
            this.selectFieldSet.add("entries");
        }
        for (Map.Entry<String, String> entry : this.fieldMappings.entrySet()) {
            String dimField = entry.getValue();
            String flexField = this.matchFlexField(flexProperty, dimField);
            if (flexField != null) {
                String field;
                String alias;
                String[] flexFieldSplit = flexField.split("\\.");
                String string = alias = flexFieldSplit.length == 2 ? flexFieldSplit[1] : flexFieldSplit[0];
                if (DataSourceTypeEnum.GLBALANCE == this.entityType) {
                    this.selectFieldSet.add(alias);
                } else {
                    this.selectFieldSet.add(flexField + " as " + alias);
                }
                this.flexFields.add(alias);
                String[] assTypeSplit = dimField.split("_");
                if (assTypeSplit.length <= 1) continue;
                if (assTypeSplit[assTypeSplit.length - 1].contains("-")) {
                    field = assTypeSplit[assTypeSplit.length - 1].split("-")[0];
                    String subField = dimField.split("-")[0];
                    this.fieldMappings.put(entry.getKey(), subField);
                    this.addTansFormMap(field, entry.getKey() + "$id", this.createFieldAsAlias(assTypeSplit[assTypeSplit.length - 1].substring(field.length() + 1)));
                    this.extraIdMap.put(entry.getKey() + "$id", subField);
                } else {
                    field = dimField;
                }
                this.assTypeSet.add(field);
                continue;
            }
            if (!dimField.startsWith("dim_")) {
                String selectField = dimField;
                if (DataSourceTypeEnum.TEMPPORARY == this.entityType) {
                    String[] fieldSplit = dimField.split("\\.");
                    if (fieldSplit.length > 1 && allEntities.get(fieldSplit[0]) != null && !this.dataSourceNumber.equals(((EntityType)allEntities.get(fieldSplit[0])).getParent().getName())) {
                        ArrayList<String> entityList = new ArrayList<String>(8);
                        IDataEntityType parentEntity = ((EntityType)allEntities.get(fieldSplit[0])).getParent();
                        while (!this.dataSourceNumber.equals(parentEntity.getName())) {
                            entityList.add(0, parentEntity.getName());
                            parentEntity = parentEntity.getParent();
                        }
                        entityList.add(dimField);
                        selectField = String.join((CharSequence)".", entityList);
                        this.fieldMappings.put(entry.getKey(), selectField);
                        continue;
                    }
                    if (fieldSplit.length > 1 && allEntities.get(fieldSplit[0]) != null && this.dataSourceNumber.equals(((EntityType)allEntities.get(fieldSplit[0])).getParent().getName())) {
                        this.selectFieldSet.add(fieldSplit[0]);
                    }
                }
                if (selectField.contains("-")) {
                    String field = selectField.split("-")[0];
                    this.selectFieldSet.add(field);
                    this.fieldMappings.put(entry.getKey(), field);
                    String[] split = field.split("\\.");
                    IDataEntityProperty property = (IDataEntityProperty)allFields.get(split[split.length - 1]);
                    String baseEntityId = null;
                    if ((DataSourceTypeEnum.VOUCHER == this.entityType || DataSourceTypeEnum.BIZVOUCHER == this.entityType) && (field.contains("comassist1") || field.contains("comassist2"))) {
                        if (this.accountTableId == null) continue;
                        DynamicObject accountTable = BusinessDataServiceHelper.loadSingleFromCache((Object)this.accountTableId, (String)"bd_accounttable");
                        DynamicObjectCollection comassistEntry = accountTable.getDynamicObjectCollection("comassistentry");
                        DynamicObject comassiet = null;
                        if (field.contains("comassist1") && comassistEntry != null && !comassistEntry.isEmpty()) {
                            comassiet = (DynamicObject)comassistEntry.get(0);
                        } else if (field.contains("comassist2") && comassistEntry != null && comassistEntry.size() > 1) {
                            comassiet = (DynamicObject)comassistEntry.get(1);
                        }
                        if (comassiet != null && "1".equals(comassiet.getString("valuesourcetype")) && comassiet.get("valuesource") != null) {
                            baseEntityId = comassiet.getString("valuesource.number");
                        } else if (comassiet != null && "2".equals(comassiet.getString("valuesourcetype"))) {
                            baseEntityId = "bos_assistantdata_detail";
                        }
                    } else if (property instanceof BasedataProp) {
                        baseEntityId = ((BasedataProp)property).getBaseEntityId();
                    }
                    if (!StringUtils.isNotEmpty(baseEntityId)) continue;
                    this.addTansFormMap(baseEntityId, entry.getKey() + "$id", this.createFieldAsAlias(selectField.substring(field.length() + 1)));
                    this.extraIdMap.put(entry.getKey() + "$id", field);
                    continue;
                }
                this.selectFieldSet.add(selectField);
                continue;
            }
            if (!dimField.contains("-")) continue;
            String field = dimField.split("-")[0];
            this.fieldMappings.put(entry.getKey(), field);
            this.extraIdMap.put(entry.getKey() + "$id", field);
            this.addTansFormMap(field.substring("dim_".length()), entry.getKey() + "$id", this.createFieldAsAlias(dimField.substring(field.length() + 1)));
        }
        for (String conditionDesc : this.conditionMap.values()) {
            CalculateCondition condition = new CalculateCondition(this.dataSourceNumber, conditionDesc);
            this.subEntryFlexSet.addAll(condition.GetSubEntryFlexFieldValue());
            this.selectFieldSet.addAll(condition.parseProperty());
        }
        this.selectFieldSet.removeAll(this.needRemoveField);
        this.rebuildTansFormMap();
        this.fieldMappings.putAll(this.extraIdMap);
    }

    private Map<Integer, Set<String>> getLevelMeasureMap() {
        HashMap<Integer, Set<String>> levelMeasureMap = new HashMap<Integer, Set<String>>(3);
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)this.dataSourceNumber);
        Map allFields = billType.getAllFields();
        DynamicObjectCollection measureEntry = this.scheme.getDynamicObjectCollection("measuremapentry");
        for (DynamicObject measure : measureEntry) {
            String selectType = measure.getString("selecttype");
            String measureField = null;
            if (SelectTypeEnum.MEASUREFIELD.getCode().equals(selectType)) {
                measureField = measure.getString("measurefield");
            } else if (SelectTypeEnum.DIMMEASUREFIELD.getCode().equals(selectType)) {
                measureField = measure.getString("dimmeasurefield");
            }
            if (measureField == null) continue;
            int level = 1;
            String[] fieldSplit = measureField.split("\\.");
            if (allFields.get(fieldSplit[fieldSplit.length - 1]) == null) continue;
            if (((IDataEntityProperty)allFields.get(fieldSplit[fieldSplit.length - 1])).getParent() instanceof SubEntryType) {
                level = 3;
            } else if (((IDataEntityProperty)allFields.get(fieldSplit[fieldSplit.length - 1])).getParent() instanceof EntityType && !((IDataEntityProperty)allFields.get(fieldSplit[fieldSplit.length - 1])).getParent().getName().equals(this.dataSourceNumber)) {
                level = 2;
            }
            this.addLevelMeasureMap(levelMeasureMap, level, measureField);
        }
        return levelMeasureMap;
    }

    private void addLevelMeasureMap(Map<Integer, Set<String>> levelMeasureMap, Integer level, String value) {
        if (levelMeasureMap.get(level) == null) {
            levelMeasureMap.put(level, new HashSet<String>(Collections.singletonList(value)));
        } else {
            levelMeasureMap.get(level).add(value);
        }
    }

    private void buildDefaultMap() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.tableNumber.substring(2));
        RowMeta rowMeta = ORM.create().createRowMeta(dataEntityType.getName(), String.join((CharSequence)",", dataEntityType.getAllFields().keySet()));
        DynamicObjectCollection dimMapEntry = this.scheme.getDynamicObjectCollection("dimensionmapentry");
        DynamicObjectCollection measureEntry = this.scheme.getDynamicObjectCollection("measuremapentry");
        for (DynamicObject dimMap : dimMapEntry) {
            String defaultValue;
            if (!StringUtils.isEmpty((CharSequence)dimMap.getString("dimensionfield")) || !StringUtils.isNotEmpty((CharSequence)(defaultValue = dimMap.getString("dimdefaultvalue")))) continue;
            String dimNumber = dimMap.getString("dimension.number");
            if (DataType.LongType.equals((Object)rowMeta.getField(dimNumber).getDataType())) {
                try {
                    this.defaultValueMap.put(dimNumber, Long.parseLong(defaultValue));
                }
                catch (NumberFormatException e) {
                    logger.info("NumberFormatException" + dimNumber + e.getMessage());
                }
                continue;
            }
            if (DataType.TimestampType.equals((Object)rowMeta.getField(dimNumber).getDataType())) {
                try {
                    this.defaultValueMap.put(dimNumber, format.parse(defaultValue));
                }
                catch (ParseException e) {
                    logger.info("ParseException" + dimNumber + e.getMessage());
                }
                continue;
            }
            if (DataType.IntegerType.equals((Object)rowMeta.getField(dimNumber).getDataType())) {
                try {
                    this.defaultValueMap.put(dimNumber, Integer.parseInt(defaultValue));
                }
                catch (NumberFormatException e) {
                    logger.info("NumberFormatException" + dimNumber + e.getMessage());
                }
                continue;
            }
            this.defaultValueMap.put(dimNumber, defaultValue);
        }
        for (DynamicObject measure : measureEntry) {
            String selectType = measure.getString("selecttype");
            if (!"2".equals(selectType)) continue;
            this.defaultValueMap.put(measure.getString("measure.number"), measure.getBigDecimal("measuredefaultvalue"));
        }
    }

    public final void parseModel() {
        DynamicObjectCollection dimEntry = this.model.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dim : dimEntry) {
            if (DimensionNecessityEnum.ORG.getCode().equals(dim.get("necessity_dim"))) {
                this.orgNumber = dim.getDynamicObject("dimension").getString("number");
                continue;
            }
            if (DimensionNecessityEnum.PERIOD.getCode().equals(dim.get("necessity_dim"))) {
                this.periodNumber = dim.getDynamicObject("dimension").getString("number");
                continue;
            }
            if (!DimensionNecessityEnum.ACCOUNT.getCode().equals(dim.get("necessity_dim"))) continue;
            this.accountTableId = dim.getDynamicObject("dimension").getLong("group_id");
        }
    }

    public QFilter[] buildQFilter(boolean selectSubEntry) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        Object dataSyncSchema = BusinessDynamicObjectFactory.createDataSyncSchema(this.scheme);
        if (TimeTypeEnum.DATE.getCode().equals(this.timeType)) {
            qFilterList.addAll(((DataSyncSchema)dataSyncSchema).getParamsQFilters(this.orgIds, this.startDate, this.endDate));
        } else {
            qFilterList.addAll(((DataSyncSchema)dataSyncSchema).getParamsQFilters(this.orgIds, this.periodIds));
        }
        long dataSourceId = this.scheme.getDynamicObject("datasource").getLong("id");
        QFilter dataSourceQFilter = FAFDataSourceConfigHelper.queryOneDataSourceFilterById((Long)dataSourceId);
        if (dataSourceQFilter != null) {
            qFilterList.add(dataSourceQFilter);
        }
        List flexProperty = EntityMetaHelper.matchFlexProperty((String)this.dataSourceNumber);
        DynamicObjectCollection dimMapCollection = this.scheme.getDynamicObjectCollection("dimensionmapentry");
        for (DynamicObject dimMap : dimMapCollection) {
            DynamicObject dimension;
            String typeField;
            String dimField = dimMap.getString("dimensionfield");
            if (!StringUtils.isNotEmpty((CharSequence)dimField) || dimField.startsWith("dim_") || this.matchFlexField(flexProperty, dimField) != null || !StringUtils.isNotEmpty((CharSequence)(typeField = (dimension = (DynamicObject)dimMap.get("dimension")).getString("typefield"))) || "periodtype".equals(typeField)) continue;
            List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)dimension.getString("dimensionsource.number"), (QFilter[])new QFilter[]{new QFilter(typeField, "=", dimension.get("group.id"))}, null, (int)-1);
            qFilterList.add(new QFilter(dimField, "in", (Object)primaryKeys));
        }
        if (selectSubEntry && DataSourceTypeEnum.BIZVOUCHER == this.entityType && !this.subEntryFlexSet.isEmpty()) {
            qFilterList.add(new QFilter("entryentity.subentryentity.flexfield", "in", this.subEntryFlexSet));
        }
        return qFilterList.toArray(new QFilter[0]);
    }

    private void initSubEntryFlexSet(DynamicObject scheme) {
        if (scheme == null) {
            return;
        }
        DynamicObjectCollection dimMapCollection = scheme.getDynamicObjectCollection("dimensionmapentry");
        for (DynamicObject dimMap : dimMapCollection) {
            String dimField = dimMap.getString("dimensionfield");
            if (DataSourceTypeEnum.BIZVOUCHER != this.entityType || !StringUtils.isNotEmpty((CharSequence)dimField) || !dimField.startsWith("dim_")) continue;
            this.subEntryFlexSet.add(dimField.substring("dim_".length()).split("-")[0]);
        }
        DynamicObjectCollection meaMapCollection = scheme.getDynamicObjectCollection("measuremapentry");
        for (DynamicObject obj : meaMapCollection) {
            String dimField = obj.getString("dimmeasurefield");
            if (DataSourceTypeEnum.BIZVOUCHER != this.entityType || !StringUtils.isNotEmpty((CharSequence)dimField) || !dimField.startsWith("dim_")) continue;
            this.subEntryFlexSet.add(dimField.substring("dim_".length()).split("-")[0]);
        }
    }

    public RowMeta buildNewRowMeta() {
        DynamicObjectCollection dimensionEntry = this.model.getDynamicObjectCollection("dimension_entry");
        DynamicObjectCollection measureEntry = this.model.getDynamicObjectCollection("measure_entry");
        HashSet<String> fieldSet = new HashSet<String>(dimensionEntry.size() + measureEntry.size());
        fieldSet.add("id");
        fieldSet.add("sourcebillid");
        for (DynamicObject dimEntry : dimensionEntry) {
            DynamicObject dim = dimEntry.getDynamicObject("dimension");
            fieldSet.add(dim.getString("number"));
        }
        for (DynamicObject meaEntry : measureEntry) {
            DynamicObject measure = meaEntry.getDynamicObject("measure");
            fieldSet.add(measure.getString("number"));
        }
        RowMeta modelRowMeta = FAFDataSyncUtil.getModelRowMeta(AnalysisModelUtil.buildDetailEntityNumber((String)this.model.getString("tablenumber")), fieldSet);
        Set<String> extraIdSet = this.extraIdMap.keySet();
        Field[] fields = modelRowMeta.getFields();
        ArrayList<Field> newFieldList = new ArrayList<Field>(Arrays.asList(fields));
        for (String extraId : extraIdSet) {
            if (!fieldSet.add(extraId)) continue;
            newFieldList.add(new Field(extraId, (DataType)DataType.LongType));
        }
        for (MultiClassDimensionInfo info : this.multiClassDimensionInfoList) {
            if (!info.isIfOriginalField() || fieldSet.contains(info.getItemClassTypeAlias())) continue;
            fieldSet.add(info.getItemClassTypeAlias());
            newFieldList.add(new Field(info.getItemClassTypeAlias(), (DataType)DataType.StringType));
            this.fieldMappings.put(info.getItemClassTypeAlias(), info.getItemClassTypeField());
        }
        return new RowMeta(newFieldList.toArray(new Field[0]));
    }

    public String getInsertSQL(RowMeta rowMeta, String formId) {
        FAFSQLBuilder builder = new FAFSQLBuilder(this.tableNumber);
        for (String fieldName : rowMeta.getFieldNames()) {
            builder.insert("f" + fieldName);
        }
        return builder.insert("fcollectstatus", "0").insert("foperationstatus", "0").insert("fdatastatus", "0").insert("fdel", "0").insert("fsituationtype", "0").insert("foffstatus", "0").insert("fsourceformid", formId).toInsertSQL();
    }

    private String matchFlexField(List<String> flexFields, String dimField) {
        if (flexFields == null) {
            return null;
        }
        for (String flexfield : flexFields) {
            if (!dimField.startsWith(flexfield)) continue;
            return flexfield;
        }
        return null;
    }

    public String getSelectFields() {
        return String.join((CharSequence)",", this.selectFieldSet);
    }

    public QFilter[] buildGlAssistFilter() {
        return new QFilter[]{new QFilter("asstype", "in", this.assTypeSet)};
    }

    public QFilter[] buildGlAssistFilter(String sourceNumber, Set<String> assTypeSet) {
        if (sourceNumber.startsWith("gl_assist")) {
            return new QFilter[]{new QFilter("asstype", "in", assTypeSet)};
        }
        if (sourceNumber.startsWith("bd_flexauxprop")) {
            return new QFilter[]{new QFilter("auxproptype", "in", assTypeSet)};
        }
        return new QFilter[0];
    }

    public Long getModelId() {
        return this.model.getLong("id");
    }

    public Set<String> getFlexFields() {
        return this.flexFields;
    }

    public FAFDataSyncPOJO buildPaDataSyncPOJO() {
        Map<Integer, Set<String>> levelMeasureMap = this.getLevelMeasureMap();
        if (DataSourceTypeEnum.BIZVOUCHER == this.entityType) {
            this.entryEntityNumber = "entryentity";
        } else if (DataSourceTypeEnum.VOUCHER == this.entityType) {
            this.entryEntityNumber = "entries";
        } else if (DataSourceTypeEnum.TEMPPORARY == this.entityType && levelMeasureMap.get(2) != null) {
            Optional first = levelMeasureMap.get(2).stream().findFirst();
            this.entryEntityNumber = first.isPresent() ? ((String)first.get()).split("\\.")[0] : "";
        }
        FAFDataSyncPOJO syncPOJO = new FAFDataSyncPOJO(this.fieldMappings, this.conditionMap, this.defaultValueMap, this.dataSourceNumber, this.flexFields, this.entryEntityNumber, this.subEntryFlexSet, this.scheme.getLong("id"), levelMeasureMap);
        DateConversionTransFormer dateTrans = new DateConversionTransFormer(this.scheme, Arrays.stream(this.periodIds).map(o -> (Long)o).collect(Collectors.toSet()));
        if (StringUtils.isNotEmpty((CharSequence)dateTrans.getTargetField())) {
            syncPOJO.setDateConversionFiled(this.periodNumber);
            syncPOJO.setDateTransFormer(dateTrans);
        }
        return syncPOJO;
    }

    public FAFJoinLinkInfo buildGLAssistJoinLinkInfo(String leftField, String entityNumber) {
        FAFJoinLinkInfo link = new FAFJoinLinkInfo();
        link.setEntityName(entityNumber);
        link.setLeftField(leftField);
        link.setRightField("hg");
        if (entityNumber.startsWith("gl_assist")) {
            link.addLinkField("asstype" + entityNumber, (DataType)DataType.StringType);
            link.addLinkField("assval" + entityNumber, (DataType)(entityNumber.endsWith("txt") ? DataType.StringType : DataType.LongType));
        } else if (entityNumber.startsWith("bd_flexauxprop")) {
            link.addLinkField("auxproptype" + entityNumber, (DataType)DataType.StringType);
            link.addLinkField("auxpropval" + entityNumber, (DataType)(entityNumber.endsWith("txt") ? DataType.StringType : DataType.LongType));
        }
        return link;
    }

    public FAFJoinLinkInfo buildSubEntryJoinLinkInfo(String leftField) {
        FAFJoinLinkInfo link = new FAFJoinLinkInfo();
        link.setEntityName("t_ai_bizvouchersubentry");
        link.setLeftField(leftField);
        link.setRightField("entryid");
        link.addSubLinkField("flexfield", (DataType)DataType.StringType);
        link.addSubLinkField("value", (DataType)DataType.StringType);
        return link;
    }

    public RowMeta buildSubEntryRowMeta() {
        return new RowMeta(new String[]{"entryid", "flexfield", "value"}, new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType});
    }

    public RowMeta buildSubEntryRowMeta(String entityNumber, Set<String> selectFieldSet, DataType idDataType) {
        RowMeta rowMeta = ORM.create().createRowMeta(entityNumber, String.join((CharSequence)",", selectFieldSet));
        ArrayList<String> fields = new ArrayList<String>(selectFieldSet.size() + 1);
        ArrayList<DataType> dataTypeList = new ArrayList<DataType>(selectFieldSet.size() + 1);
        for (String s : selectFieldSet) {
            fields.add(s);
            dataTypeList.add(rowMeta.getField(s).getDataType());
        }
        fields.add(entityNumber);
        dataTypeList.add(idDataType);
        return new RowMeta(fields.toArray(new String[0]), dataTypeList.toArray(new DataType[0]));
    }

    public FAFExecuteDB getRollbackExcuteDBs() {
        FAFSQLBuilder deleteModelData = new FAFSQLBuilder(this.tableNumber).where().in("f" + this.orgNumber, this.orgIds.length).params(this.orgIds);
        if (TimeTypeEnum.PERIOD.getCode().equals(this.timeType)) {
            deleteModelData.in("f" + this.periodNumber, this.periodIds.length).params(this.periodIds);
        } else if (TimeTypeEnum.DATE.getCode().equals(this.timeType)) {
            deleteModelData.betweenAnd("f" + this.periodNumber, (DataType)DataType.TimestampType).params(this.startDate).params(this.endDate);
        }
        String entityName = AnalysisModelUtil.buildEntityNumber((String)this.model.getString("tablenumber"));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (dataEntityType.getProperty("importbatch") != null) {
            logger.info("getRollbackExecuteDBs add filter which importbatch is empty");
            deleteModelData.eq("fimportbatch", "' '");
        }
        return new FAFExecuteDB("fias", deleteModelData.toDeleteSQL(), deleteModelData.getParams());
    }

    public FAFExecuteDB getRollbackCollectExecuteDBs() {
        FAFSQLBuilder delete_model_data = new FAFSQLBuilder(this.collectTableNumber).where().in("f" + this.orgNumber, this.orgIds.length).params(this.orgIds);
        if (TimeTypeEnum.PERIOD.getCode().equals(this.timeType)) {
            delete_model_data.in("f" + this.periodNumber, this.periodIds.length).params(this.periodIds);
        } else if (this.startDate != null && this.endDate != null && TimeTypeEnum.DATE.getCode().equals(this.timeType)) {
            delete_model_data.betweenAnd("f" + this.periodNumber, (DataType)DataType.TimestampType).params(this.startDate, this.endDate);
        }
        FAFExecuteDB execute = new FAFExecuteDB("fias", delete_model_data.toDeleteSQL(), delete_model_data.getParams());
        return execute;
    }

    public FAFExecuteDB getDataAdjustResetExecuteDBs() {
        if (!TimeTypeEnum.PERIOD.getCode().equals(this.timeType)) {
            return null;
        }
        MainEntityType dataAdjustDT = MetadataServiceHelper.getDataEntityType((String)"pa_dataadjust");
        Map fields = dataAdjustDT.getFields();
        FAFSQLBuilder update_dataAdjust = new FAFSQLBuilder(dataAdjustDT.getAlias()).set(((IDataEntityProperty)fields.get("billstatus")).getAlias(), "'A'").set(((IDataEntityProperty)fields.get("adjuststatus")).getAlias(), "'1'").where().eq(((IDataEntityProperty)fields.get("analysismodel")).getAlias(), (DataType)new LongType()).params(this.model.getPkValue()).in(((IDataEntityProperty)fields.get("createorg")).getAlias(), this.orgIds.length).params(this.orgIds).in(((IDataEntityProperty)fields.get("period")).getAlias(), this.periodIds.length).params(this.periodIds);
        return new FAFExecuteDB("fias", update_dataAdjust.toUpdateSQL(), update_dataAdjust.getParams());
    }

    public DynamicObject getModel() {
        return this.model;
    }

    public String getDataSourceNumber() {
        return this.dataSourceNumber;
    }

    public DataSourceTypeEnum getEntityType() {
        return this.entityType;
    }

    public String getTableNumber() {
        return this.tableNumber;
    }

    public boolean isHaveTime() {
        return this.haveTime;
    }

    public Set<Long> getOrgIdSet() {
        return Arrays.stream(this.orgIds).map(x -> Long.parseLong(x.toString())).collect(Collectors.toSet());
    }

    public Set<Long> getPeriodIdSet() {
        return Arrays.stream(this.periodIds).map(x -> Long.parseLong(x.toString())).collect(Collectors.toSet());
    }

    public boolean isCreateStamp() {
        return this.createStamp;
    }

    public DynamicObject getScheme() {
        return this.scheme;
    }

    public Set<String> getSelectFieldSet() {
        return this.selectFieldSet;
    }

    public Object[] getOrgIds() {
        return this.orgIds;
    }

    public Object[] getPeriodIds() {
        return this.periodIds;
    }

    public Map<String, String> getFieldMappings() {
        return this.fieldMappings;
    }

    public Map<String, String> getConditionMap() {
        return this.conditionMap;
    }

    public Map<String, Object> getDefaultValueMap() {
        return this.defaultValueMap;
    }

    public QFilter[] getqFilter() {
        return this.qFilter;
    }

    public String getCollectTableNumber() {
        return this.collectTableNumber;
    }

    public Set<String> getSubEntryFlexSet() {
        return this.subEntryFlexSet;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public String getPeriodNumber() {
        return this.periodNumber;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Set<String> getAssTypeSet() {
        return this.assTypeSet;
    }

    public boolean getSyncType() {
        if (this.entityType == DataSourceTypeEnum.BCM) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"pa_datasourceconfig", (String)"synctype", (QFilter[])new QFilter("id", "=", this.scheme.get("datasource_id")).toArray());
            return dynamicObject.getBoolean("synctype");
        }
        return false;
    }

    public void addTansFormMap(String key, String sourceNumber, String propertyNumber) {
        if (this.transFormMap.get(key) == null) {
            HashMap<String, String> propertyMap = new HashMap<String, String>(5);
            propertyMap.put(sourceNumber, propertyNumber);
            this.transFormMap.put(key, propertyMap);
        } else {
            Map<String, String> sourcePropertyMap = this.transFormMap.get(key);
            if (StringUtils.isNotEmpty((CharSequence)sourcePropertyMap.get(sourceNumber))) {
                boolean exist = Arrays.asList(sourcePropertyMap.get(sourceNumber).split(",")).contains(propertyNumber);
                if (exist) {
                    return;
                }
                sourcePropertyMap.put(sourceNumber, sourcePropertyMap.get(sourceNumber) + "," + propertyNumber);
            } else {
                sourcePropertyMap.put(sourceNumber, propertyNumber);
            }
        }
    }

    public Map<String, Map<String, String>> getTransFormMap() {
        return this.transFormMap;
    }

    public List<DimConditionDTO> getDimConditionDTOS() {
        return this.dimConditionDTOS;
    }

    public void rebuildTansFormMap() {
        HashSet<String> assTypeKeys = new HashSet<String>(this.transFormMap.keySet());
        assTypeKeys.retainAll(this.assTypeSet);
        if (!assTypeKeys.isEmpty()) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_flex_property", (String)"flexfield, valuesource", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", assTypeKeys).and("valuetype", "in", (Object)new String[]{"1", "2"})});
            for (Object dyn : query) {
                String entity = dyn.getString("valuesource");
                Map<String, String> propertyMap = this.transFormMap.get(dyn.getString("flexfield"));
                this.transFormMap.put(entity, propertyMap);
                this.transFormMap.remove(dyn.getString("flexfield"));
            }
        }
        HashSet<String> aiAssType = new HashSet<String>(this.transFormMap.keySet());
        aiAssType.retainAll(this.subEntryFlexSet);
        if (!aiAssType.isEmpty()) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"ai_asstacttype", (String)"flexfiled, datatype, valuesource", (QFilter[])new QFilter[]{new QFilter("flexfiled", "in", aiAssType).and("datatype", "in", (Object)new String[]{"1", "2"})});
            for (DynamicObject dyn : query) {
                String entity = dyn.getString("valuesource");
                Map<String, String> propertyMap = this.transFormMap.get(dyn.getString("flexfiled"));
                String dataType = dyn.getString("datatype");
                String key = "1".equals(dataType) ? entity : "bos_assistantdata_detail";
                if (this.transFormMap.containsKey(key)) {
                    this.transFormMap.get(key).putAll(propertyMap);
                } else {
                    this.transFormMap.put(entity, propertyMap);
                }
                this.transFormMap.remove(dyn.getString("flexfiled"));
            }
        }
        for (Map.Entry<String, Map<String, String>> targtSourceEntry : this.transFormMap.entrySet()) {
            String entityNumber = targtSourceEntry.getKey();
            Map<String, String> targetSource = targtSourceEntry.getValue();
            Map allFields = EntityMetadataCache.getDataEntityType((String)entityNumber).getAllFields();
            for (Map.Entry<String, String> entry : targetSource.entrySet()) {
                String targetAlias = entry.getKey();
                String propName = entry.getValue().split("as")[0].trim();
                if (propName.contains(".")) {
                    String[] split = propName.split("\\.");
                    String baseEntityId = ((BasedataProp)allFields.get(split[0])).getBaseEntityId();
                    Map baseEntityProps = EntityMetadataCache.getDataEntityType((String)baseEntityId).getAllFields();
                    if (!(baseEntityProps.get(split[1]) instanceof ItemClassProp) || !targetAlias.contains("$id")) continue;
                    String dimensionName = targetAlias.substring(0, targetAlias.length() - 3);
                    String dimensionEntity = this.getDimensionEntityName(dimensionName);
                    ItemClassTypeProp typeProp = EntityUtils.getItemClassTypeProp((ItemClassProp)baseEntityProps.get(split[1]));
                    if (dimensionEntity == null || typeProp == null) continue;
                    String typeField = split[0] + "." + typeProp.getName();
                    this.multiClassDimensionInfoList.add(new MultiClassDimensionInfo(targetAlias, dimensionEntity, entityNumber + "itemClassType" + typeField, typeField, entityNumber, false));
                    continue;
                }
                if (!(allFields.get(propName) instanceof ItemClassProp) || !targetAlias.contains("$id")) continue;
                String dimensionName = targetAlias.substring(0, targetAlias.length() - 3);
                String dimensionEntity = this.getDimensionEntityName(dimensionName);
                ItemClassTypeProp typeProp = EntityUtils.getItemClassTypeProp((ItemClassProp)allFields.get(propName));
                if (dimensionEntity == null || typeProp == null) continue;
                String typeField = typeProp.getName();
                this.multiClassDimensionInfoList.add(new MultiClassDimensionInfo(targetAlias, dimensionEntity, entityNumber + "itemClassType" + typeField, typeField, entityNumber, false));
            }
        }
    }

    public String createFieldAsAlias(String selectField) {
        return selectField + " as " + selectField + "_ali_drisuf";
    }

    public void appendSelectFields(List<DataSyncTransfer> dataTransfers) {
        for (DataSyncTransfer transfer : dataTransfers) {
            if (!StringUtils.isNotEmpty((CharSequence)transfer.getSourceFieldTypePropName())) continue;
            this.selectFieldSet.add(transfer.getSourceFieldTypePropName());
            this.multiClassDimensionInfoList.add(new MultiClassDimensionInfo(transfer.getFieldName(), transfer.getTargetFieldEntityname(), transfer.getSourceFieldTypePropName() + "$" + this.dataSourceNumber, transfer.getSourceFieldTypePropName(), this.dataSourceNumber, true));
        }
    }

    public List<MultiClassDimensionInfo> getMultiClassDimensionInfoList() {
        return this.multiClassDimensionInfoList;
    }

    public String getDimensionEntityName(String dimensionNumber) {
        DynamicObjectCollection dimEntry = this.scheme.getDynamicObjectCollection("dimensionmapentry");
        Map<String, DynamicObject> dynamicObjectMap = dimEntry.stream().collect(Collectors.toMap(dyn -> dyn.getString("dimension.number"), dyn -> dyn.getDynamicObject("dimension")));
        DynamicObject dimension = dynamicObjectMap.get(dimensionNumber);
        if ("1".equals(dimension.getString("dimensiontype"))) {
            return dimension.getString("dimensionsource.id");
        }
        return null;
    }
}

