/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algox.AlgoXCallBack;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.macc.faf.algox.FAFExecuteDB;
import kd.macc.faf.cache.DistributeCache;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.datasync.FAFDataSyncDTO;
import kd.macc.faf.datasync.exec.AlgoXExecutor;
import kd.macc.faf.datasync.task.FAFOlapDataProcessTask;
import kd.macc.faf.datasync.task.FAFStandardEntityProcessTask;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.dto.OlapDataExtractingDTO;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.FAFSummarySceneEnum;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.FAFSyncDataSchemeHelper;
import kd.macc.faf.olap.KdOlapServerHelper;
import kd.macc.faf.olap.OlapMultipleSplitSQLBuilder;
import kd.macc.faf.olap.OlapSQLBuilder;
import kd.macc.faf.summary.FAFSummaryDataHelper;

public class FAFDataSyncHelper {
    private static final Log logger = LogFactory.getLog(FAFDataSyncHelper.class);
    protected final AtomicBoolean suspendGetNextTask;
    protected final int threadMax = 6;
    protected final AtomicBoolean ifStartSummaryTask;
    protected DLock dLock;
    protected volatile boolean completeTraversal;
    protected volatile boolean haveFailTask;
    protected String errMessage;
    private Long taskId;
    private DistributeCache cache;
    private AtomicInteger count;

    public FAFDataSyncHelper(Long taskId, DistributeCache cache, DLock dLock) {
        this.taskId = taskId;
        this.cache = cache;
        this.count = new AtomicInteger(0);
        this.dLock = dLock;
        this.suspendGetNextTask = new AtomicBoolean(false);
        this.completeTraversal = false;
        this.ifStartSummaryTask = new AtomicBoolean(true);
        this.haveFailTask = false;
    }

    public boolean syncData(DynamicObject model, DataExtractingDTO dataExtDTO) {
        boolean executeJob = false;
        if (!FAFAnalysisModelHelper.isModelNewVersion((Long)model.getLong("id"))) {
            logger.info("this analysisModel not Update");
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u9700\u8fdb\u884c\u5347\u7ea7\u540e\u518d\u83b7\u53d6\u6570\u636e\u3002", (String)"FAFDataSyncHelper_1", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("analysismodel", "=", (Object)model.getLong("id"));
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection dataSchemeDynColl = QueryServiceHelper.query((String)"pa_syncdataschema", (String)"id", (QFilter[])new QFilter[]{qFilter});
        FAFDataSyncDTO dto = new FAFDataSyncDTO(model, null, dataExtDTO.getOrgIds(), dataExtDTO.getPeriodIds(), dataExtDTO.getTimeType(), dataExtDTO.getStartDate(), dataExtDTO.getEndDate());
        String tips = this.checkValidateOlapQuery(dataExtDTO, dataSchemeDynColl);
        if (StringUtils.isNotEmpty((String)tips)) {
            this.cache.put("FAF|" + this.taskId + "showView", (Object)("showView:" + tips));
        }
        this.deleteModelData(dto);
        logger.info("kd.macc.faf.datasync.FAFDataSyncHelper dataSchemaCount :" + dataSchemeDynColl.size());
        block0: for (DynamicObject schemeObj : dataSchemeDynColl) {
            if (this.haveFailTask) break;
            JobSession session = null;
            DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_syncdataschema", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeObj.getLong("id"))});
            dto = new FAFDataSyncDTO(model, scheme, dataExtDTO.getOrgIds(), dataExtDTO.getPeriodIds(), dataExtDTO.getTimeType(), dataExtDTO.getStartDate(), dataExtDTO.getEndDate());
            DataSourceTypeEnum entityType = dto.getEntityType();
            boolean syncType = dto.getSyncType();
            if (DataSourceTypeEnum.TEMPPORARY == entityType || DataSourceTypeEnum.VOUCHER == entityType || DataSourceTypeEnum.BIZVOUCHER == entityType) {
                Object dataSyncSchema = BusinessDynamicObjectFactory.createDataSyncSchema(scheme);
                session = FAFStandardEntityProcessTask.createSession(entityType, dto, dataSyncSchema);
                executeJob = true;
                this.commitJobSession(session, model, dataExtDTO, dto);
                continue;
            }
            if (DataSourceTypeEnum.BCM == entityType && !syncType || DataSourceTypeEnum.EPM == entityType) {
                OlapDataExtractingDTO extractingDTO = FAFSyncDataSchemeHelper.buildOlapDataExtractingDTO((Long)scheme.getLong("id"), dto.getOrgIdSet(), dto.getPeriodIdSet());
                if (extractingDTO == null) continue;
                extractingDTO.buildExtractingValues();
                if (!KdOlapServerHelper.checkExtractingOlapData((OlapDataExtractingDTO)extractingDTO, (DataExtractingDTO)dataExtDTO)) continue;
                FAFOlapDataProcessTask olapDataProcessTask = FAFOlapDataProcessTask.getInstance();
                OlapMultipleSplitSQLBuilder multipleSplitSQLBuilder = FAFOlapDataProcessTask.getInstance().validateDimMembersAndGetSQlBuilder(extractingDTO);
                Map<String, Map<String, Long>> entityNumberTransIdMap = olapDataProcessTask.getEntityNumberTransIdMap(extractingDTO, multipleSplitSQLBuilder);
                while (multipleSplitSQLBuilder.hasNext() && !this.haveFailTask) {
                    OlapSQLBuilder sqlBuilder = multipleSplitSQLBuilder.next();
                    session = FAFOlapDataProcessTask.getInstance().execute(extractingDTO, model.getLong("id"), sqlBuilder, entityNumberTransIdMap);
                    executeJob = true;
                    this.commitJobSession(session, model, dataExtDTO, dto);
                }
                continue;
            }
            if ((!syncType || DataSourceTypeEnum.BCM != entityType) && DataSourceTypeEnum.GLBALANCE != entityType && DataSourceTypeEnum.INV_PERIODBALANCE != entityType) continue;
            AlgoXExecutor executor = new AlgoXExecutor(model, dataExtDTO);
            executor.exec(scheme);
            if (!executor.isCommit()) continue;
            List<JobSession> sessions = executor.getSessions();
            for (JobSession jobSession : sessions) {
                if (this.haveFailTask) continue block0;
                executeJob = true;
                this.commitJobSession(jobSession, model, dataExtDTO, dto);
            }
        }
        this.completeTraversal = true;
        if (this.haveFailTask) {
            this.deleteModelData(dto);
        } else if (this.count.get() == 0 && this.ifStartSummaryTask.get() && executeJob) {
            this.startSummary(model, dataExtDTO);
        }
        if (!executeJob) {
            FAFDataSyncUtil.updateCacheSuccessMessage(this.cache, this.taskId, ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"FAFDataSyncHelper_2", (String)"macc-faf-business", (Object[])new Object[0]), false);
        }
        return executeJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitJobSession(JobSession session, final DynamicObject model, final DataExtractingDTO dataExtDTO, final FAFDataSyncDTO dto) {
        if (session != null) {
            if (this.suspendGetNextTask.get()) {
                AtomicBoolean atomicBoolean = this.suspendGetNextTask;
                synchronized (atomicBoolean) {
                    try {
                        this.suspendGetNextTask.wait();
                    }
                    catch (InterruptedException e) {
                        this.dLock.unlock();
                        logger.warn("Interrupted!", (Throwable)e);
                        this.cache.put("FAF|" + this.taskId, (Object)("error: InterruptedException " + e.getMessage()));
                        throw new RuntimeException(e);
                    }
                }
            }
            this.count.addAndGet(1);
            this.changeGetNextTaskSuspendStatus(6);
            logger.info("[MACC-FAF] success commitJobSession job count :" + this.count.get());
            session.asyncCommit(2, TimeUnit.HOURS, new AlgoXCallBack(){

                public void onFinished() {
                    FAFDataSyncHelper.this.count.addAndGet(-1);
                    FAFDataSyncHelper.this.changeGetNextTaskSuspendStatus(6);
                    logger.info("[MACC-FAF] jobSession onFinished, residue job: " + FAFDataSyncHelper.this.count.get());
                    if (FAFDataSyncHelper.this.completeTraversal && FAFDataSyncHelper.this.count.get() == 0 && FAFDataSyncHelper.this.cache != null) {
                        if (FAFDataSyncHelper.this.ifStartSummaryTask.get()) {
                            try {
                                FAFDataSyncHelper.this.startSummary(model, dataExtDTO);
                            }
                            catch (Exception e) {
                                FAFDataSyncHelper.this.dLock.unlock();
                                logger.error("MACC-FAF FAFDataSyncHelper SummaryError", (Throwable)e);
                                FAFDataSyncHelper.this.cache.put("FAF|" + FAFDataSyncHelper.this.taskId, (Object)("error: SummaryError" + e.getMessage()));
                            }
                        } else if (FAFDataSyncHelper.this.haveFailTask) {
                            logger.error("MACC-FAF FAFDataSyncHelper haveFail : " + FAFDataSyncHelper.this.errMessage);
                            FAFDataSyncHelper.this.dLock.unlock();
                            FAFDataSyncHelper.this.cache.put("FAF|" + FAFDataSyncHelper.this.taskId, (Object)("error:" + FAFDataSyncHelper.this.errMessage));
                            FAFDataSyncHelper.this.deleteModelData(dto);
                        }
                    }
                }

                public void onFailed(Exception e) {
                    FAFDataSyncHelper.this.count.addAndGet(-1);
                    FAFDataSyncHelper.this.ifStartSummaryTask.set(false);
                    FAFDataSyncHelper.this.haveFailTask = true;
                    FAFDataSyncHelper.this.changeGetNextTaskSuspendStatus(6);
                    logger.error("pa.algox.dataSync.onFailed", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    FAFDataSyncHelper.this.errMessage = e.getMessage();
                    if (e.getCause() != null && e.getCause().getCause() != null) {
                        FAFDataSyncHelper.this.errMessage = e.getCause().getCause().getMessage();
                    }
                    if (FAFDataSyncHelper.this.errMessage != null && FAFDataSyncHelper.this.errMessage.contains("temp_file_limit")) {
                        FAFDataSyncHelper.this.errMessage = ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u6570\u636e\u91cf\u8d85\u51fa\u78c1\u76d8\u7a7a\u95f4\uff0c\u8bf7\u4fee\u6539\u53d6\u6570\u6761\u4ef6\u91cd\u65b0\u53d6\u6570\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"FAFDataSyncHelper_0", (String)"macc-faf-business", (Object[])new Object[0]);
                    }
                    if (e.getCause() instanceof KDException) {
                        FAFDataSyncHelper.this.errMessage = e.getCause().getMessage();
                    }
                    if (FAFDataSyncHelper.this.cache != null && FAFDataSyncHelper.this.count.get() == 0) {
                        FAFDataSyncHelper.this.dLock.unlock();
                        FAFDataSyncHelper.this.cache.put("FAF|" + FAFDataSyncHelper.this.taskId, (Object)("error:" + FAFDataSyncHelper.this.errMessage));
                        FAFDataSyncHelper.this.deleteModelData(dto);
                    }
                }
            });
        }
    }

    protected void changeGetNextTaskSuspendStatus(int threadMax) {
        this.changeGetNextTaskSuspendStatus(this.count.get() >= threadMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeGetNextTaskSuspendStatus(boolean suspend) {
        if (suspend != this.suspendGetNextTask.get()) {
            if (!suspend && this.suspendGetNextTask.compareAndSet(true, false)) {
                AtomicBoolean atomicBoolean = this.suspendGetNextTask;
                synchronized (atomicBoolean) {
                    this.suspendGetNextTask.notifyAll();
                }
            }
            if (suspend) {
                this.suspendGetNextTask.set(true);
            }
        }
    }

    public void deleteModelData(FAFDataSyncDTO dto) {
        FAFExecuteDB executeDB = dto.getRollbackExcuteDBs();
        FAFExecuteDB collectExecuteDBs = dto.getRollbackCollectExecuteDBs();
        if (executeDB != null) {
            DB.execute((DBRoute)executeDB.getDbRoute(), (String)executeDB.getSql(), (Object[])executeDB.getParams());
        }
        if (collectExecuteDBs != null) {
            DB.execute((DBRoute)collectExecuteDBs.getDbRoute(), (String)collectExecuteDBs.getSql(), (Object[])collectExecuteDBs.getParams());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSummary(DynamicObject model, DataExtractingDTO dataExtDTO) {
        AtomicBoolean atomicBoolean = this.ifStartSummaryTask;
        synchronized (atomicBoolean) {
            if (this.ifStartSummaryTask.get()) {
                FAFSummaryDataHelper summaryDataHelper = new FAFSummaryDataHelper(this.taskId.toString(), FAFSummarySceneEnum.SYNC_DATA);
                summaryDataHelper.summary(model, dataExtDTO, this.dLock);
                this.cache.put("FAF|" + this.taskId, (Object)"true");
                this.ifStartSummaryTask.set(false);
            }
        }
    }

    private String checkValidateOlapQuery(DataExtractingDTO dataExtDTO, DynamicObjectCollection dataSchemeDynColl) {
        StringBuilder tips = new StringBuilder();
        for (DynamicObject schemeObj : dataSchemeDynColl) {
            OlapDataExtractingDTO extractingDTO;
            DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_syncdataschema", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeObj.getLong("id"))});
            DataSourceTypeEnum entityType = DataSourceTypeEnum.getEnum((String)scheme.getDynamicObject("datasource").getString("datasource_type"));
            if (DataSourceTypeEnum.EPM != entityType && DataSourceTypeEnum.BCM != entityType || (extractingDTO = FAFSyncDataSchemeHelper.buildOlapDataExtractingDTO((Long)scheme.getLong("id"), (Set)dataExtDTO.getOrgIdSet(), (Set)dataExtDTO.getPeriodIdSet())) == null) continue;
            extractingDTO.buildExtractingValues();
            String unRelationParamTips = KdOlapServerHelper.checkUnRelationParamTips((OlapDataExtractingDTO)extractingDTO, (DataExtractingDTO)dataExtDTO);
            if (!StringUtils.isNotEmpty((String)unRelationParamTips)) continue;
            tips.append(unRelationParamTips);
        }
        return tips.length() == 0 ? null : tips.toString();
    }
}

