/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.macc.faf.datasync.FAFDataSyncDTO;
import kd.macc.faf.datasync.param.BalanceQueryParam;

public class FAFGlBalanceParamIterator
implements Iterator<BalanceQueryParam> {
    private static final Log logger = LogFactory.getLog(FAFGlBalanceParamIterator.class);
    protected Set<Long> orgIds;
    protected Set<Long> periodIds;
    protected Long acctTableId;
    protected Long bookTypeId;
    protected FAFDataSyncDTO syncDto;
    protected ConcurrentLinkedQueue<ThreeTuple<Long, Long, Set<Long>>> subTaskInfoQueue;
    protected Set<Long> accountIdSet;
    protected Set<String> selectorSet = new HashSet<String>(20);

    public FAFGlBalanceParamIterator(Set<Long> orgIds, Set<Long> periodIds, Long acctTableId, Long bookTypeId, FAFDataSyncDTO syncDto) {
        this.orgIds = orgIds;
        this.periodIds = periodIds;
        this.acctTableId = acctTableId;
        this.subTaskInfoQueue = new ConcurrentLinkedQueue();
        this.bookTypeId = bookTypeId;
        this.syncDto = syncDto;
        this.dataSourceFieldProcess();
        this.confirmAccountView();
    }

    private void dataSourceFieldProcess() {
        long dataSourceId = this.syncDto.getScheme().getDynamicObject("datasource").getLong("id");
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)dataSourceId, (String)"pa_datasourceconfig");
        String filterJson = dy.getString("entityfilter_tag");
        if (StringUtils.isNotEmpty((CharSequence)filterJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            MainEntityType number = EntityMetadataCache.getDataEntityType((String)"bd_accountview");
            FilterBuilder filterBuilder = new FilterBuilder(number, filterCondition);
            filterBuilder.buildFilter(false);
            QFilter qFilter = filterBuilder.getQFilter();
            if (qFilter != null) {
                this.accountIdSet = new HashSet<Long>(100);
                try (DataSet accountDs = QueryServiceHelper.queryDataSet((String)"faf.datasync.FAFGlBalanceParamIterator.dataSourceFieldProcess", (String)"bd_accountview", (String)"id", (QFilter[])qFilter.toArray(), null);){
                    while (accountDs.hasNext()) {
                        this.accountIdSet.add(accountDs.next().getLong("id"));
                    }
                }
            }
        }
        for (String selector : this.syncDto.getSelectFieldSet()) {
            if ("id".equals(selector) || "period".equals(selector)) continue;
            if (selector.contains(".")) {
                this.selectorSet.add(selector.substring(0, selector.indexOf(".")));
                continue;
            }
            this.selectorSet.add(selector);
        }
    }

    private void confirmAccountView() {
        logger.info("MACC-Balance: accounts" + this.accountIdSet);
        if (this.accountIdSet != null && this.accountIdSet.size() == 0) {
            return;
        }
        DynamicObjectCollection periodCollection = QueryServiceHelper.query((String)"bd_period", (String)"id, enddate", (QFilter[])new QFilter[]{new QFilter("id", "in", this.periodIds)});
        for (Long orgId : this.orgIds) {
            HashMap<Long, HashSet<Long>> periodAccountMap = new HashMap<Long, HashSet<Long>>(periodCollection.size());
            QFilter fOrgId = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
            QFilter fAcctTableId = new QFilter("accounttable", "=", (Object)this.acctTableId);
            try (DataSet accountIdDs = QueryServiceHelper.queryDataSet((String)"faf.datasync.FAFGlBalanceParamIterator.confirmAccountView", (String)"bd_accountview", (String)"id, startdate, enddate", (QFilter[])new QFilter[]{fOrgId, fAcctTableId}, null);){
                while (accountIdDs.hasNext()) {
                    Row next = accountIdDs.next();
                    for (DynamicObject period : periodCollection) {
                        Date enddate = period.getDate("enddate");
                        if (next.getDate("startdate") == null || next.getDate("enddate") == null || enddate.compareTo(next.getDate("startdate")) < 0 || enddate.compareTo(next.getDate("enddate")) > 0) continue;
                        long periodId = period.getLong("id");
                        if (periodAccountMap.get(periodId) == null) {
                            periodAccountMap.put(periodId, new HashSet<Long>(Collections.singletonList(next.getLong("id"))));
                            continue;
                        }
                        ((Set)periodAccountMap.get(periodId)).add(next.getLong("id"));
                    }
                }
            }
            for (Map.Entry entry : periodAccountMap.entrySet()) {
                Set accountIds = (Set)entry.getValue();
                if (CollectionUtils.isNotEmpty(this.accountIdSet)) {
                    accountIds.retainAll(this.accountIdSet);
                }
                if (CollectionUtils.isEmpty((Collection)accountIds)) continue;
                this.subTaskInfoQueue.add((ThreeTuple<Long, Long, Set<Long>>)new ThreeTuple((Object)orgId, entry.getKey(), (Object)accountIds));
            }
        }
    }

    @Override
    public boolean hasNext() {
        return !this.subTaskInfoQueue.isEmpty();
    }

    @Override
    public BalanceQueryParam next() {
        if (this.hasNext()) {
            ThreeTuple info = (ThreeTuple)this.subTaskInfoQueue.remove();
            BalanceQueryParam param = new BalanceQueryParam();
            param.setOrgId((Long)info.item1);
            param.setPeriodId((Long)info.item2);
            Set accountIds = (Set)info.item3;
            for (Long accountId : accountIds) {
                param.setAccountAssgrp(accountId, null);
            }
            param.setAccountTableId(this.acctTableId);
            param.setBookTypeId(this.bookTypeId);
            for (String selector : this.selectorSet) {
                param.addSelector(selector);
            }
            logger.info("MACC-BALANCE selectFields:" + param.getSelector());
            logger.info("MACC-BALANCE param:" + param);
            return param;
        }
        return null;
    }

    public Set<String> getSelectorSet() {
        return this.selectorSet;
    }
}

