/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.GenericServiceResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.macc.faf.cache.DistributeCache;
import kd.macc.faf.cache.IDataCacheModule;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.datasync.SyncDataCallBack;
import kd.macc.faf.datasync.SyncDataExec;
import kd.macc.faf.datasync.SyncDataRunnable;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.mservice.TaskInstParams;
import kd.macc.faf.datasync.mservice.TaskInstServiceHelper;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.enums.EnableStatusEnum;
import kd.macc.faf.enums.TimeTypeEnum;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.lock.ModelTaskLock;
import kd.macc.faf.management.enums.TaskResultCodeEnum;
import kd.macc.faf.management.enums.TaskTypeEnum;
import kd.macc.faf.olap.KdOlapServerHelper;
import kd.macc.faf.service.PeriodServiceHelper;
import kd.macc.faf.system.DimhashMarkUpgrade;
import kd.macc.faf.system.ModelMarkEnum;
import kd.macc.faf.system.ModelMarks;
import kd.macc.faf.util.DataAdjustUtils;
import org.jetbrains.annotations.Nullable;

public class SyncDataExecutor
implements SyncDataExec {
    private static final Log logger = LogFactory.getLog(SyncDataExecutor.class);
    private static final int MAX_THREAD = 3;
    private final Semaphore semaphore = new Semaphore(3, true);
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FAF);
    private final Long requestId;
    private final DataSyncModel model;
    private final Set<Object> schemaList;
    private final DataExtractingDTO dataExtDTO;
    private final List<Long> errorOrgIds = new ArrayList<Long>(10);
    private DynamicObject[] schemaDynamics;

    public SyncDataExecutor(Object modelObject, DataExtractingDTO dataExtractingDTO) {
        this.model = BusinessDynamicObjectFactory.createDataSyncModel(modelObject);
        this.dataExtDTO = dataExtractingDTO;
        this.requestId = DB.genGlobalLongId();
        QFilter qFilter = new QFilter("analysismodel", "=", this.model.getPkValue()).and("enable", "=", (Object)"1");
        this.schemaList = QueryServiceHelper.query((String)"pa_syncdataschema", (String)"id", (QFilter[])qFilter.toArray()).stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
    }

    @Override
    public ErrorCode valid() {
        if (this.schemaList == null || this.schemaList.isEmpty()) {
            return new ErrorCode("fail_01", ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u53d6\u6570\u65b9\u6848\u3002", (String)"SyncDataExecutor_1", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)this.model.getPkValue(), (String)"pa_analysismodel");
        if (analysisModel == null) {
            return new ErrorCode("fail_02", ResManager.loadKDString((String)"\u6240\u9009\u5206\u6790\u6a21\u578b\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SyncDataExecutor_2", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        if (EnableStatusEnum.disable.getCodeString().equals(analysisModel.getString("enable"))) {
            return new ErrorCode("fail_03", ResManager.loadKDString((String)"\u6240\u9009\u5206\u6790\u6a21\u578b\u5df2\u88ab\u7981\u7528,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SyncDataExecutor_3", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        String entityNumber = this.model.getEntitynumber();
        if (StringUtils.isEmpty((String)entityNumber)) {
            return new ErrorCode("fail_04", ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u6570\u636e\u8868\u672a\u521b\u5efa\u6216\u5df2\u5220\u9664\u3002", (String)"SyncDataExecutor_4", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        try {
            EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        catch (Exception e) {
            return new ErrorCode("fail_04", ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u6570\u636e\u8868\u672a\u521b\u5efa\u6216\u5df2\u5220\u9664\u3002", (String)"SyncDataExecutor_4", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        if (!FAFAnalysisModelHelper.isModelNewVersion((DynamicObject)this.model.getDynamic())) {
            logger.info("this analysisModel not Update");
            return new ErrorCode("fail_05", ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u9700\u8fdb\u884c\u5347\u7ea7\u540e\u518d\u83b7\u53d6\u6570\u636e\u3002", (String)"SyncDataExecutor_5", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        if (this.dataExtDTO.getPeriodDimNumber() == null || !this.dataExtDTO.getPeriodDimNumber().equals(this.model.getPeriodField().getString("number"))) {
            return new ErrorCode("fail_06", ResManager.loadKDString((String)"\u6240\u9009\u5206\u6790\u6a21\u578b\u7684\u6a21\u578b\u5fc5\u8981\u7ef4\u5ea6\u201c\u65f6\u95f4/\u671f\u95f4\u201d\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SyncDataExecutor_6", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        String validateResult = KdOlapServerHelper.validateSyncSchemaInTypeOfEpmOrBcm((Long)this.model.getDynamic().getLong("id"));
        if (!validateResult.isEmpty()) {
            return new ErrorCode("fail_07", validateResult);
        }
        Long[] periodIds = this.dataExtDTO.getPeriodIds();
        if (TimeTypeEnum.PERIOD.getCode().equals(this.dataExtDTO.getTimeType()) && periodIds != null && periodIds.length != 0 && Arrays.stream(periodIds).noneMatch(period -> Arrays.stream(this.dataExtDTO.getOrgIds()).allMatch(org -> DataAdjustUtils.allowReCollectData((Long)((Long)this.model.getPkValue()), (Long)period, (Long)org)))) {
            return new ErrorCode("fail_08", ResManager.loadKDString((String)"\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u672a\u6267\u884c\u8c03\u6574\u7684\u8c03\u6574\u5355\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u6570\u636e\u83b7\u53d6\u3002", (String)"SyncDataExecutor_9", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        if (this.dataExtDTO.getOrgIdSet() != null && this.dataExtDTO.getOrgIdSet().size() > 100) {
            return new ErrorCode("fail_09", ResManager.loadKDString((String)"\u6700\u591a\u53ea\u5141\u8bb8\u9009\u62e9100\u4e2a\u7ec4\u7ec7\u3002", (String)"SyncDataExecutor_12", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("id", "in", this.schemaList);
        DynamicObjectCollection dataSchemeDynColl = QueryServiceHelper.query((String)"pa_syncdataschema", (String)"id, datasource.datasource_type", (QFilter[])new QFilter[]{qFilter});
        String tips = KdOlapServerHelper.checkValidateOlapQuery((DataExtractingDTO)this.dataExtDTO, (DynamicObjectCollection)dataSchemeDynColl);
        if (StringUtils.isNotEmpty((String)tips)) {
            this.cache.put("FAF|" + this.requestId + "showView", (Object)("showView:" + tips));
        }
        return new ErrorCode("success", "success");
    }

    @Override
    public ErrorCode sync() {
        try {
            ModelTaskLock modelTaskLock;
            ErrorCode valid = this.valid();
            if (!"success".equals(valid.getCode())) {
                return valid;
            }
            Long modelId = (Long)this.model.getPkValue();
            ModelMarks modelMarks = new ModelMarks(modelId);
            if (!modelMarks.exists(ModelMarkEnum.DIMHASHV1) && (modelTaskLock = ModelTaskLock.create(this.model.getEntitynumber_d(), modelId)).existsLock()) {
                String errorMessage = ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u5df2\u6709\u6267\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u8bf7\u5f85\u4efb\u52a1\u6267\u884c\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6570\u636e\u83b7\u53d6\uff0c\u60a8\u4e5f\u53ef\u524d\u5f80\u4efb\u52a1\u7ba1\u7406\u5e73\u53f0\u67e5\u770b\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u60c5\u51b5\u3002", (String)"SyncDataExecutor_11", (String)"macc-faf-business", (Object[])new Object[0]);
                return new ErrorCode("fail", errorMessage);
            }
            TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum((String)this.dataExtDTO.getTimeType());
            if (TimeTypeEnum.PERIOD == timeTypeEnum) {
                ArrayList<Long> orgIdList = new ArrayList<Long>(this.dataExtDTO.getOrgIdSet());
                ArrayList<Long> periodIdList = new ArrayList<Long>(this.dataExtDTO.getPeriodIdSet());
                if (!PeriodServiceHelper.checkPeriodOrgList(modelId, orgIdList, periodIdList, true).booleanValue()) {
                    return new ErrorCode("forbidden", ResManager.loadKDString((String)"\u671f\u95f4\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u53d6\u6570\u3002", (String)"SyncDataExecutor_8", (String)"macc-faf-business", (Object[])new Object[0]));
                }
                PeriodServiceHelper.batchCreateCtrlRecord((long)this.model.getSystemId(), (long)modelId, orgIdList, periodIdList, this.dataExtDTO.getPeriodBaseData());
                ErrorCode register = this.registerTask(orgIdList, periodIdList);
                if (register != null) {
                    return register;
                }
            }
            this.startSync();
            return new ErrorCode("success", "success");
        }
        catch (Exception e) {
            logger.error("sync error", (Throwable)e);
            String errorMessage = String.format(ResManager.loadKDString((String)"\u53d6\u6570\u6267\u884c\u5f02\u5e38\uff1a%s", (String)"SyncDataExecutor_10", (String)"macc-faf-business", (Object[])new Object[0]), e.getMessage());
            return new ErrorCode("fail", errorMessage);
        }
    }

    private void startSync() {
        ThreadPools.executeOnce((String)"queryData", () -> {
            block11: {
                Long modelId = (Long)this.model.getPkValue();
                try {
                    ModelMarks modelMarks = new ModelMarks(modelId);
                    modelMarks.addIfAbsent(ModelMarkEnum.DIMHASHV1, new DimhashMarkUpgrade());
                    TimeTypeEnum timeTypeEnum = TimeTypeEnum.getTimeTypeEnum((String)this.dataExtDTO.getTimeType());
                    if (timeTypeEnum == TimeTypeEnum.DATE) {
                        this.execSyncDataByDateTime();
                        break block11;
                    }
                    ArrayList orgIdList = new ArrayList(this.dataExtDTO.getOrgIdSet());
                    ArrayList periodIdList = new ArrayList(this.dataExtDTO.getPeriodIdSet());
                    for (Long org : orgIdList) {
                        for (Long period : periodIdList) {
                            try {
                                this.semaphore.acquire();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            this.execSyncData(org, period);
                        }
                    }
                    try {
                        this.semaphore.acquire(3);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (!this.errorOrgIds.isEmpty()) {
                        List orgNumbers = QueryServiceHelper.query((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", this.errorOrgIds)}).stream().map(x -> x.getString("number")).collect(Collectors.toList());
                        FAFDataSyncUtil.updateCacheSuccessMessage(this.cache, this.requestId, String.format(ResManager.loadKDString((String)"\u6210\u529f%1$s\u4e2a\u7ec4\u7ec7\uff0c\u5931\u8d25%2$s\u4e2a\u7ec4\u7ec7 \r\n \u5931\u8d25\u7ec4\u7ec7\u7f16\u53f7\uff1a %3$s", (String)"SyncDataExecutor_7", (String)"macc-faf-business", (Object[])new Object[0]), orgIdList.size() - this.errorOrgIds.size(), this.errorOrgIds.size(), String.join((CharSequence)"\u3001", orgNumbers)), true);
                    } else {
                        FAFDataSyncUtil.updateCacheMessage(this.cache, this.requestId, "summarySuccess");
                    }
                }
                catch (Exception e) {
                    logger.error("start sync error", (Throwable)e);
                    String errorMessage = String.format(ResManager.loadKDString((String)"\u53d6\u6570\u6267\u884c\u5f02\u5e38\uff1a%s", (String)"SyncDataExecutor_10", (String)"macc-faf-business", (Object[])new Object[0]), e.getMessage());
                    FAFDataSyncUtil.updateCacheErrorMessage(this.cache, this.requestId, errorMessage);
                }
            }
        });
    }

    @Nullable
    private ErrorCode registerTask(List<Long> orgIdList, List<Long> periodIdList) {
        GenericServiceResult<String> register;
        if (this.dataExtDTO.isRegisterTask() && (register = this.registerToTaskManager(orgIdList, periodIdList)).getSuccess() != null && !register.getSuccess().booleanValue()) {
            String registerCode = register.getCode();
            TaskResultCodeEnum resultCodeEnum = TaskResultCodeEnum.getEnumByCode((String)registerCode);
            logger.info("MACC-FAF GenericServiceResult registerCode: " + registerCode + "errorMessage:" + register.getMessage());
            switch (resultCodeEnum) {
                case TO_CONFIRM: {
                    return new ErrorCode("TO_CONFIRM_YesNo", register.getMessage());
                }
                case CLIENT_ERROR: 
                case SERVER_ERROR: {
                    return new ErrorCode(resultCodeEnum.getCode(), register.getMessage());
                }
                case CLIENT_ERROR_401: {
                    return new ErrorCode("TO_CONFIRM_OK", register.getMessage());
                }
            }
            return new ErrorCode("register fail", register.getMessage());
        }
        return null;
    }

    private GenericServiceResult<String> registerToTaskManager(List<Long> orgIdList, List<Long> periodIdList) {
        TaskInstParams params = new TaskInstParams();
        params.put("requestId", this.requestId);
        params.put("taskExecType", this.dataExtDTO.getTaskExecType());
        params.put("anaModelId", this.model.getPkValue() + "");
        ArrayList list = new ArrayList();
        for (Long org : orgIdList) {
            for (Long period : periodIdList) {
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("orgId", org);
                map.put("periodId", period);
                list.add(map);
            }
        }
        params.put("orgPeriodIds", list);
        params.put("businessKey", "sync");
        params.put("force", this.dataExtDTO.isForce());
        params.put("taskType", TaskTypeEnum.SYNC.getCode());
        params.put("creatorId", RequestContext.get().getCurrUserId());
        params.put("businessInfo", "");
        return TaskInstServiceHelper.register(params);
    }

    private void execSyncDataByDateTime() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.execSyncData(null, null);
        try {
            this.semaphore.acquire(3);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.errorOrgIds.isEmpty()) {
            FAFDataSyncUtil.updateCacheMessage(this.cache, this.requestId, "summarySuccess");
        }
    }

    private void execSyncData(Long org, Long period) {
        SyncDataRunnable runnable = new SyncDataRunnable(this.model, this.requestId);
        runnable.setOrg(org);
        runnable.setPeriod(period);
        runnable.setDataExtractingDTO(this.dataExtDTO);
        runnable.setSchemaDynamics(this.getSchemaDynamics());
        runnable.setCallBack(new SyncDataCallBack(){

            @Override
            public void sumFinished(Long org, Long period) {
                SyncDataExecutor.this.semaphore.release();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFail(Long org, Long period, String message) {
                try {
                    SyncDataExecutor.this.errorOrgIds.add(org);
                    FAFDataSyncUtil.updateCacheSuccessMessage(SyncDataExecutor.this.cache, SyncDataExecutor.this.requestId, message, true);
                }
                finally {
                    SyncDataExecutor.this.semaphore.release();
                }
            }
        });
        ThreadPools.executeOnce((String)"SyncDataExecutor", (Runnable)runnable);
    }

    public String getRequestId() {
        return this.requestId + "";
    }

    public DynamicObject[] getSchemaDynamics() {
        if (this.schemaDynamics == null) {
            MainEntityType schemaEntityType = EntityMetadataCache.getDataEntityType((String)"pa_syncdataschema");
            this.schemaDynamics = BusinessDataServiceHelper.load((Object[])this.schemaList.toArray(), (DynamicObjectType)schemaEntityType);
        }
        return this.schemaDynamics;
    }
}

