/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kd.bos.algox.AlgoXCallBack;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.GenericServiceResult;
import kd.macc.faf.algox.FAFExecuteDB;
import kd.macc.faf.bservice.check.DataCheckRuleExecParams;
import kd.macc.faf.bservice.check.DataCheckRuleExecutor;
import kd.macc.faf.bservice.check.DataCheckRunModeEnum;
import kd.macc.faf.cache.DistributeCache;
import kd.macc.faf.cache.IDataCacheModule;
import kd.macc.faf.datasync.FAFDataSyncDTO;
import kd.macc.faf.datasync.SyncDataCallBack;
import kd.macc.faf.datasync.SyncDataExecutor;
import kd.macc.faf.datasync.exec.AlgoXExecutor;
import kd.macc.faf.datasync.exec.AlgoXSummaryExecutor;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.mservice.SubTask;
import kd.macc.faf.datasync.mservice.TaskInstParams;
import kd.macc.faf.datasync.mservice.TaskInstServiceHelper;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.enums.TimeTypeEnum;
import kd.macc.faf.helper.DLockHelper;
import kd.macc.faf.management.enums.SubTaskStatusEnum;
import kd.macc.faf.management.enums.TaskExecTypeEnum;

public class SyncDataRunnable
implements Runnable {
    private static final Log logger = LogFactory.getLog(SyncDataExecutor.class);
    private static final int MAX_THREAD = 7;
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FAF);
    private final Semaphore semaphore = new Semaphore(7, true);
    private final Long requestId;
    private final DataSyncModel model;
    private final Queue<SubTask> syncTaskQueue = new ConcurrentLinkedQueue<SubTask>();
    private SubTask summaryTask;
    private volatile boolean haveFailSyncTask;
    private DLock dLock;
    private Long org;
    private Long period;
    private SyncDataCallBack callBack;
    private boolean haveSyncDataJob = false;
    private int taskCount = 0;
    private DynamicObject[] schemaDynamics;
    private DataExtractingDTO dataExtDTO;

    public SyncDataRunnable(DataSyncModel model, Long requestId) {
        this.model = model;
        this.requestId = requestId;
    }

    public void setSchemaDynamics(DynamicObject[] schemaDynamics) {
        this.schemaDynamics = schemaDynamics;
    }

    public void registerTask() {
        if (this.taskCount > 0 || this.schemaDynamics == null) {
            return;
        }
        this.taskCount = this.schemaDynamics.length + 1;
        for (int i = 0; i < this.schemaDynamics.length; ++i) {
            DynamicObject schema = this.schemaDynamics[i];
            int subTaskIndex = i + 1;
            String taskname = String.format(ResManager.loadKDString((String)"\u6570\u636e\u83b7\u53d6-%s", (String)"SyncDataRunnable_0", (String)"macc-faf-business", (Object[])new Object[0]), schema.getString("name"));
            String pushSubTask = this.pushSubTask(subTaskIndex, taskname);
            SubTask task = new SubTask(subTaskIndex, pushSubTask);
            task.setData(schema);
            this.syncTaskQueue.add(task);
        }
        String pushSubTask = this.pushSubTask(this.taskCount, ResManager.loadKDString((String)"\u6c47\u603b\u8ba1\u7b97", (String)"SyncDataRunnable_1", (String)"macc-faf-business", (Object[])new Object[0]));
        this.summaryTask = new SubTask(this.taskCount, pushSubTask);
    }

    public void setOrg(Long org) {
        this.org = org;
    }

    public void setPeriod(Long period) {
        this.period = period;
    }

    public SyncDataCallBack getCallBack() {
        if (this.callBack == null) {
            throw new KDBizException("call back not is null.");
        }
        return this.callBack;
    }

    public void setCallBack(SyncDataCallBack callBack) {
        this.callBack = callBack;
    }

    @Override
    public void run() {
        if (!this.lock()) {
            String comment = ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u5df2\u6709\u6267\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u8bf7\u5f85\u4efb\u52a1\u6267\u884c\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6570\u636e\u83b7\u53d6\uff0c\u60a8\u4e5f\u53ef\u524d\u5f80\u4efb\u52a1\u7ba1\u7406\u5e73\u53f0\u67e5\u770b\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u60c5\u51b5", (String)"SyncDataRunnable_9", (String)"macc-faf-business", (Object[])new Object[0]);
            this.taskCount = 1;
            String subtaskInfo = this.pushSubTask(1, ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501", (String)"SyncDataRunnable_11", (String)"macc-faf-business", (Object[])new Object[0]));
            this.onFailMessage(new SubTask(1, subtaskInfo), comment, null);
            return;
        }
        this.registerTask();
        SubTask tempPushSubTask = null;
        try {
            this.deleteModelData();
            for (final SubTask subTask : this.syncTaskQueue) {
                DynamicObject schema = (DynamicObject)subTask.getData();
                tempPushSubTask = subTask;
                AlgoXExecutor executor = new AlgoXExecutor(this.model.getDynamic(), this.getDataExtractingDTO());
                executor.exec(schema);
                if (!executor.isCommit()) {
                    this.releaseSubTask(subTask, SubTaskStatusEnum.SUCCEED, ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e", (String)"SyncDataRunnable_2", (String)"macc-faf-business", (Object[])new Object[0]));
                    this.getCallBack().syncFinished((DynamicObject)subTask.getData(), this.org, this.period);
                    continue;
                }
                JobSession jobSession = executor.getSession();
                this.haveSyncDataJob = true;
                this.semaphore.acquire();
                if (this.haveFailSyncTask) {
                    return;
                }
                this.commitSubTask(subTask, jobSession.asyncCommit(1, TimeUnit.DAYS, new AlgoXCallBack(){

                    public void onFinished() {
                        try {
                            SyncDataRunnable.this.releaseSubTask(subTask, SubTaskStatusEnum.SUCCEED, "");
                            SyncDataRunnable.this.getCallBack().syncFinished((DynamicObject)subTask.getData(), SyncDataRunnable.this.org, SyncDataRunnable.this.period);
                        }
                        finally {
                            SyncDataRunnable.this.semaphore.release();
                        }
                    }

                    public void onFailed(Exception e) {
                        try {
                            SyncDataRunnable.this.haveFailSyncTask = true;
                            SyncDataRunnable.this.onFailMessage(subTask, ResManager.loadKDString((String)"\u6267\u884c\u53d6\u6570\u4efb\u52a1\u5931\u8d25", (String)"SyncDataRunnable_3", (String)"macc-faf-business", (Object[])new Object[0]), e);
                        }
                        finally {
                            SyncDataRunnable.this.semaphore.release();
                        }
                    }
                }));
            }
            this.semaphore.acquire(7);
        }
        catch (Exception e) {
            this.onFailMessage(tempPushSubTask, ResManager.loadKDString((String)"\u521b\u5efa\u53d6\u6570\u4efb\u52a1\u5931\u8d25", (String)"SyncDataRunnable_4", (String)"macc-faf-business", (Object[])new Object[0]), e);
            return;
        }
        try {
            this.exeSummary();
        }
        catch (Exception e) {
            this.onFailMessage(this.summaryTask, ResManager.loadKDString((String)"\u521b\u5efa\u6c47\u603b\u4efb\u52a1\u5931\u8d25", (String)"SyncDataRunnable_5", (String)"macc-faf-business", (Object[])new Object[0]), e);
        }
    }

    private void exeSummary() {
        if (this.haveFailSyncTask) {
            this.unlock();
            return;
        }
        if (!this.haveSyncDataJob) {
            this.unlock();
            this.releaseSubTask(this.summaryTask, SubTaskStatusEnum.SUCCEED, ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e", (String)"SyncDataRunnable_2", (String)"macc-faf-business", (Object[])new Object[0]));
            this.getCallBack().sumFinished(this.org, this.period);
            return;
        }
        AlgoXSummaryExecutor executor = new AlgoXSummaryExecutor(this.model.getDynamic(), this.getDataSyncParams());
        JobSession jobSession = executor.exec();
        if (jobSession == null) {
            this.onFailMessage(this.summaryTask, ResManager.loadKDString((String)"\u521b\u5efa\u6c47\u603b\u4efb\u52a1\u5931\u8d25", (String)"SyncDataRunnable_5", (String)"macc-faf-business", (Object[])new Object[0]), null);
            return;
        }
        this.commitSubTask(this.summaryTask, jobSession.asyncCommit(1, TimeUnit.DAYS, new AlgoXCallBack(){

            public void onFinished() {
                SyncDataRunnable.this.unlock();
                SyncDataRunnable.this.releaseSubTask(SyncDataRunnable.this.summaryTask, SubTaskStatusEnum.SUCCEED, "");
                SyncDataRunnable.this.executeCheck();
                SyncDataRunnable.this.getCallBack().sumFinished(SyncDataRunnable.this.org, SyncDataRunnable.this.period);
            }

            public void onFailed(Exception e) {
                SyncDataRunnable.this.onFailMessage(SyncDataRunnable.this.summaryTask, ResManager.loadKDString((String)"\u6267\u884c\u6c47\u603b\u4efb\u52a1\u5931\u8d25", (String)"SyncDataRunnable_8", (String)"macc-faf-business", (Object[])new Object[0]), e);
            }
        }));
    }

    private void deleteModelData() {
        FAFDataSyncDTO dto = this.getFAFDataSyncDTO();
        FAFExecuteDB executeDB = dto.getRollbackExcuteDBs();
        FAFExecuteDB collectExecuteDBs = dto.getRollbackCollectExecuteDBs();
        if (executeDB != null) {
            DB.execute((DBRoute)executeDB.getDbRoute(), (String)executeDB.getSql(), (Object[])executeDB.getParams());
        }
        if (collectExecuteDBs != null) {
            DB.execute((DBRoute)collectExecuteDBs.getDbRoute(), (String)collectExecuteDBs.getSql(), (Object[])collectExecuteDBs.getParams());
        }
        FAFExecuteDB dataAdjustUpdateDBs = null;
        dataAdjustUpdateDBs = dto.getDataAdjustResetExecuteDBs();
        if (dataAdjustUpdateDBs != null) {
            DB.execute((DBRoute)dataAdjustUpdateDBs.getDbRoute(), (String)dataAdjustUpdateDBs.getSql(), (Object[])dataAdjustUpdateDBs.getParams());
        }
    }

    private FAFDataSyncDTO getFAFDataSyncDTO() {
        if (this.isRegisterTask()) {
            return new FAFDataSyncDTO(this.model.getDynamic(), null, new Object[]{this.org}, new Object[]{this.period}, TimeTypeEnum.PERIOD.getCode(), null, null);
        }
        return new FAFDataSyncDTO(this.model.getDynamic(), null, this.dataExtDTO.getOrgIds(), this.dataExtDTO.getPeriodIds(), this.dataExtDTO.getTimeType(), this.dataExtDTO.getStartDate(), this.dataExtDTO.getEndDate());
    }

    private DataExtractingDTO getDataExtractingDTO() {
        if (this.isRegisterTask()) {
            return new DataExtractingDTO(Collections.singleton(this.org), TimeTypeEnum.PERIOD.getCode(), null, null, this.model.getPeriodField().getDataEntityType().getName(), Collections.singleton(this.period), this.model.getOrgNumber(), this.model.getPeriodNumber());
        }
        return this.dataExtDTO;
    }

    public void setDataExtractingDTO(DataExtractingDTO dataExtDTO) {
        this.dataExtDTO = dataExtDTO;
    }

    private DataSyncParams getDataSyncParams() {
        DataSyncParams params = new DataSyncParams();
        if (this.isRegisterTask()) {
            params.getOrgIdSet().add(this.org);
            params.getPeriodIdSet().add(this.period);
            params.setTimeType(TimeTypeEnum.PERIOD.getCode());
        } else {
            params.setTimeType(this.dataExtDTO.getTimeType());
            params.setOrgIdSet(this.dataExtDTO.getOrgIdSet());
            params.setPeriodIdSet(this.dataExtDTO.getPeriodIdSet());
            params.setStartDate(this.dataExtDTO.getStartDate());
            params.setEndDate(this.dataExtDTO.getEndDate());
        }
        return params;
    }

    private boolean isRegisterTask() {
        return this.dataExtDTO.isRegisterTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean lock() {
        if (this.org != null && this.period != null) {
            String mopLockKey = DLockHelper.getMOPLockKey((Long)((Long)this.model.getPkValue()), (Long)this.org, (Long)this.period);
            this.dLock = DLock.create((String)mopLockKey);
            if (!this.dLock.tryLock(1000L)) return false;
            if (!DLockHelper.existsMLock((String)this.model.getEntitynumber_d())) return true;
            this.dLock.unlock();
            logger.info("faf-sync-data: runnable lock fail, model number:{},org:{},peirod:{}", new Object[]{this.model.getNumber(), this.org, this.period});
            return false;
        } else {
            String lockKey = DLockHelper.getMLockKey((String)this.model.getEntitynumber_d());
            this.dLock = DLock.create((String)lockKey);
            if (!this.dLock.tryLock(1000L)) return false;
            if (!DLockHelper.existsMOPLock((Long)((Long)this.model.getPkValue()))) return true;
            this.dLock.unlock();
            logger.info("faf-sync-data: runnable lock fail, model number: {}", (Object)this.model.getNumber());
        }
        return false;
    }

    private void unlock() {
        if (this.dLock != null) {
            this.dLock.close();
        }
    }

    private void onFailMessage(SubTask subTask, String message, Exception e) {
        this.unlock();
        StringBuilder sb = new StringBuilder(message);
        if (e != null) {
            logger.error("faf-sync-data: onFailMessage", (Throwable)e);
            String errMessage = e.getMessage();
            if (e.getCause() != null) {
                errMessage = e.getCause().getMessage();
            }
            if (errMessage != null && errMessage.contains("temp_file_limit")) {
                errMessage = ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u6570\u636e\u91cf\u8d85\u51fa\u78c1\u76d8\u7a7a\u95f4\uff0c\u8bf7\u4fee\u6539\u53d6\u6570\u6761\u4ef6\u91cd\u65b0\u53d6\u6570\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (String)"SyncDataRunnable_10", (String)"macc-faf-business", (Object[])new Object[0]);
            }
            if (e.getCause() instanceof KDException) {
                errMessage = e.getCause().getMessage();
            }
            sb.append("\uff1a").append(errMessage);
        }
        sb.append("\u3002");
        String collectMessage = sb.toString();
        this.releaseSubTask(subTask, SubTaskStatusEnum.FAILED, collectMessage);
        FAFDataSyncUtil.updateCacheErrorMessage(this.cache, this.requestId, collectMessage);
        this.getCallBack().onFail(this.org, this.period, collectMessage);
    }

    private String pushSubTask(int subTaskIndex, String subtaskname) {
        if (!this.isRegisterTask()) {
            return "";
        }
        try {
            TaskInstParams params = new TaskInstParams();
            params.put("subTaskCount", this.taskCount);
            params.put("requestId", this.requestId);
            params.put("orgId", this.org);
            params.put("periodId", this.period);
            params.put("taskExecType", this.dataExtDTO.getTaskExecType());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("subTaskIndex", subTaskIndex);
            map.put("subTaskName", subtaskname);
            map.put("subTaskStatus", SubTaskStatusEnum.TODO.getCode());
            List mapList = Collections.singletonList(map);
            params.put("subTaskInfos", mapList);
            GenericServiceResult<String> result = TaskInstServiceHelper.update(params);
            if (result.getSuccess().booleanValue()) {
                return (String)result.getData();
            }
            if (logger.isInfoEnabled()) {
                logger.info("faf-sync-data:pushSubTask fail: {} ", (Object)result.getMessage());
            }
        }
        catch (Exception ex) {
            logger.error("faf-sync-data:pushSubTask Exception:", (Throwable)ex);
        }
        return null;
    }

    private void commitSubTask(SubTask pushSubTask, String jobId) {
        if (!this.isRegisterTask()) {
            return;
        }
        try {
            TaskInstParams params = new TaskInstParams();
            params.put("subTaskCount", this.taskCount);
            params.put("requestId", this.requestId);
            params.put("orgId", this.org);
            params.put("periodId", this.period);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("subTaskIndex", pushSubTask.getIndex());
            map.put("subTaskStatus", SubTaskStatusEnum.PROCESSING.getCode());
            map.put("jobId", jobId);
            params.put("subTaskInfos", Collections.singletonList(map));
            GenericServiceResult<String> result = TaskInstServiceHelper.update(params);
            if (!result.getSuccess().booleanValue()) {
                if (logger.isInfoEnabled()) {
                    logger.info("faf-sync-data:commitSubTask fail:{}", (Object)result.getMessage());
                }
            } else {
                Object data = result.getData();
                if (logger.isInfoEnabled()) {
                    logger.info("faf-sync-data:commitSubTask success: {}", data);
                }
            }
        }
        catch (Exception ex) {
            logger.error("faf-sync-data:commitSubTask Exception:", (Throwable)ex);
        }
    }

    private void releaseSubTask(SubTask subTask, SubTaskStatusEnum subTaskStatus, String subTaskComment) {
        if (!this.isRegisterTask()) {
            return;
        }
        try {
            if (subTask == null) {
                return;
            }
            TaskInstParams params = new TaskInstParams();
            params.put("subTaskCount", this.taskCount);
            params.put("requestId", this.requestId);
            params.put("orgId", this.org);
            params.put("periodId", this.period);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("subTaskIndex", subTask.getIndex());
            map.put("subTaskStatus", subTaskStatus.getCode());
            map.put("subTaskComment", subTaskComment);
            params.put("subTaskInfos", Collections.singletonList(map));
            GenericServiceResult<String> result = TaskInstServiceHelper.update(params);
            if (!result.getSuccess().booleanValue()) {
                if (logger.isInfoEnabled()) {
                    logger.info("faf-sync-data:releaseSubTask fail: {}", (Object)result.getMessage());
                }
            } else if (logger.isInfoEnabled()) {
                logger.info("faf-sync-data:releaseSubTask success: {}", result.getData());
            }
        }
        catch (Exception ex) {
            logger.error("faf-sync-data:releaseSubTask Exception:", (Throwable)ex);
        }
    }

    public void executeCheck() {
        try {
            DataCheckRuleExecParams params;
            DataCheckRuleExecutor executor;
            ErrorCode exec;
            if (this.isRegisterTask() && !"success".equals((exec = (executor = DataCheckRuleExecutor.create(params = this.getDataCheckRuleExecParams())).execute()).getCode()) && logger.isInfoEnabled()) {
                logger.info("executeCheck fail: {}", (Object)exec.getMessage());
            }
        }
        catch (Exception ex) {
            logger.error("executeCheck:", (Throwable)ex);
        }
    }

    private DataCheckRuleExecParams getDataCheckRuleExecParams() {
        DataCheckRuleExecParams params = new DataCheckRuleExecParams();
        params.setBatchNo(this.dataExtDTO.getBatchNo());
        params.setModelPkvalue((Long)this.model.getPkValue());
        params.setOrgList(Collections.singletonList(this.org));
        params.setPeriodList(Collections.singletonList(this.period));
        params.setRunmode(DataCheckRunModeEnum.AUTO_END_SYNC_DATA.getCode());
        params.setSendMessage(Boolean.valueOf(TaskExecTypeEnum.MANUAL.getCode().equals(this.dataExtDTO.getTaskExecType())));
        return params;
    }
}

