/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.datasync.exec.Exec;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.datasync.exec.impl.BcmSyncSchema;
import kd.macc.faf.datasync.exec.impl.BcmSyncSchemaExec;
import kd.macc.faf.datasync.exec.impl.GenericSchemaExec;
import kd.macc.faf.datasync.exec.impl.GlBalanceSchemaExec;
import kd.macc.faf.datasync.exec.impl.GlBalanceSyncSchema;
import kd.macc.faf.datasync.exec.impl.InvSyncSchema;
import kd.macc.faf.datasync.exec.impl.InvSyncSchemaExec;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.enums.DataSourceTypeEnum;

public class AlgoXExecutor {
    private static final Log logger = LogFactory.getLog(AlgoXExecutor.class);
    private final DataSyncModel syncModel;
    private final DataSyncParams params;
    private final List<JobSession> sessions;
    private boolean commit = false;

    public AlgoXExecutor(DynamicObject model, DataExtractingDTO dto) {
        this.syncModel = new DataSyncModel(model);
        this.params = new DataSyncParams();
        this.params.setOrgIdSet(dto.getOrgIdSet());
        this.params.setPeriodIdSet(dto.getPeriodIdSet());
        this.params.setTimeType(dto.getTimeType());
        this.params.setStartDate(dto.getStartDate());
        this.params.setEndDate(dto.getEndDate());
        this.params.getExts().put("DataExtractingDTO", dto);
        this.sessions = new ArrayList<JobSession>();
    }

    public void exec(DynamicObject schemaDynamic) {
        Exec<JobSession, DataSetX> exec = this.buildExec(schemaDynamic);
        if (exec != null) {
            while (exec.hasNext()) {
                JobSession jobSession = this.generatorSession();
                DataSetX dataSetX = exec.exec(jobSession);
                if (dataSetX == null) continue;
                this.sessions.add(jobSession);
                this.commit = true;
            }
        } else {
            GenericSchemaExec genericSchemaExec = new GenericSchemaExec(this.syncModel, this.params);
            List<JobSession> jobSessions = genericSchemaExec.exec(schemaDynamic);
            if (jobSessions != null && !jobSessions.isEmpty()) {
                this.sessions.addAll(jobSessions);
                this.commit = true;
            }
        }
    }

    private Exec<JobSession, DataSetX> buildExec(DynamicObject shemaDynamic) {
        DynamicObject datasource = shemaDynamic.getDynamicObject("datasource");
        String datasourceType = datasource.getString("datasource_type");
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getEnum((String)datasourceType);
        switch (dataSourceTypeEnum) {
            case BCM: {
                boolean synctype = datasource.getBoolean("synctype");
                if (!synctype) break;
                return new BcmSyncSchemaExec((BcmSyncSchema)BusinessDynamicObjectFactory.createDataSyncSchema(shemaDynamic), this.params);
            }
            case INV_PERIODBALANCE: {
                return new InvSyncSchemaExec((InvSyncSchema)BusinessDynamicObjectFactory.createDataSyncSchema(shemaDynamic), this.params);
            }
            case GLBALANCE: {
                GlBalanceSyncSchema syncSchema = (GlBalanceSyncSchema)BusinessDynamicObjectFactory.createDataSyncSchema(shemaDynamic);
                if (syncSchema == null || !syncSchema.validExecute()) break;
                return new GlBalanceSchemaExec(syncSchema, this.params);
            }
        }
        return null;
    }

    private JobSession generatorSession() {
        return AlgoX.createSession((String)"faf_AlgoXExecutor", (String)ResManager.loadKDString((String)"\u76c8\u5229\u80fd\u529b\u5206\u6790\u6570\u636e\u540c\u6b65", (String)"AlgoXExecutor_0", (String)"macc-faf-business", (Object[])new Object[0]));
    }

    public boolean isCommit() {
        return this.commit;
    }

    public List<JobSession> getSessions() {
        return this.sessions;
    }

    public JobSession getSession() {
        if (this.sessions.size() == 1) {
            return this.sessions.get(0);
        }
        throw new KDBizException("job session build erro.");
    }
}

