/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec;

import java.util.concurrent.TimeUnit;
import kd.bos.algox.AlgoX;
import kd.bos.algox.AlgoXCallBack;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.datasync.exec.AlgoxIncrementSummaryExec;
import kd.macc.faf.datasync.exec.data.DataExecSummary;
import kd.macc.faf.datasync.exec.data.DataSyncParams;

public class AlgoXIncrementSummaryExecutor {
    protected static final Log logger = LogFactory.getLog(AlgoXIncrementSummaryExecutor.class);
    private final DataExecSummary dataExecSummary;

    public AlgoXIncrementSummaryExecutor(DynamicObject model, DataSyncParams params) {
        this.dataExecSummary = new DataExecSummary(model, params);
    }

    public JobSession exec() {
        AlgoxIncrementSummaryExec exec = new AlgoxIncrementSummaryExec(this.dataExecSummary);
        while (exec.hasNext()) {
            JobSession jobSession = this.generatorSession();
            Boolean execked = exec.exec(jobSession);
            if (!execked.booleanValue()) continue;
            return jobSession;
        }
        return null;
    }

    public void asyncCommit(final DLock dLock) {
        try {
            this.exec().asyncCommit(1, TimeUnit.DAYS, new AlgoXCallBack(){

                public void onFinished() {
                    if (dLock != null) {
                        dLock.unlock();
                    }
                }

                public void onFailed(Exception e) {
                    logger.error((Throwable)e);
                    if (dLock != null) {
                        dLock.unlock();
                    }
                }
            });
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
    }

    private JobSession generatorSession() {
        return AlgoX.createSession((String)"faf_AlgoXIncrementSummaryExecutor", (String)"faf_AlgoXIncrementSummaryExecutor");
    }
}

