/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.exec;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Output;
import kd.bos.algox.CoGroupDataSetX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.macc.faf.algox.XDbOutput;
import kd.macc.faf.datasync.exec.Exec;
import kd.macc.faf.datasync.exec.data.DataExecRecalculate;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.func.RecalcAndComplementCoGroupFunction;

public class AlgoXRecalculateExec
implements Exec<JobSession, Boolean> {
    private final DataExecRecalculate dataExecRecalculate;

    public AlgoXRecalculateExec(DataExecRecalculate dataExecRecalculate) {
        this.dataExecRecalculate = dataExecRecalculate;
    }

    @Override
    public Boolean exec(JobSession session) {
        this.execRecalculate(session);
        return Boolean.TRUE;
    }

    private void execRecalculate(JobSession session) {
        DataSyncModel syncModel = this.dataExecRecalculate.getModel();
        DataSetX currPeriodSum = session.fromInput(this.dataExecRecalculate.getCurrPeriodSumInput());
        DataSetX prevPeriodSum = session.fromInput(this.dataExecRecalculate.getPrevPeriodSumInput());
        currPeriodSum = currPeriodSum.addFields(new Field[]{new Field("_dbflag", (DataType)DataType.IntegerType)}, new Object[]{0});
        prevPeriodSum = prevPeriodSum.addFields(new Field[]{new Field("_dbflag", (DataType)DataType.IntegerType)}, new Object[]{0});
        DataSetX dsxOutToSum = this.coCalc(currPeriodSum, prevPeriodSum);
        if (syncModel.isHaveTimeField()) {
            dsxOutToSum = dsxOutToSum.addFields(new Field[]{new Field("fcreatetime", (DataType)DataType.TimestampType)}, new Object[]{new Date()});
        }
        DataSetX dsxInsertSum = dsxOutToSum.filter("_dbflag = 1").removeFields(new String[]{"_dbflag", "operationstatus", "collectstatus"});
        String insertSQL = syncModel.getInsertSumTableSQL();
        XDbOutput dbOutputInsertSum = new XDbOutput("fias", insertSQL, dsxInsertSum.getRowMeta());
        dsxInsertSum.output((Output)dbOutputInsertSum);
        DataSetX dsxUpdateSum = dsxOutToSum.filter("_dbflag = 2").select(syncModel.getUpdateCalcMeasureSelectRows());
        String updateSQL = syncModel.getUpdateCalcMeasureSumTableSQL();
        XDbOutput dbOutputUpdateSum = new XDbOutput("fias", updateSQL, dsxUpdateSum.getRowMeta());
        dsxUpdateSum.output((Output)dbOutputUpdateSum);
    }

    private DataSetX coCalc(DataSetX dsxSum, DataSetX dsxPreData) {
        DataSyncModel syncModel = this.dataExecRecalculate.getModel();
        CoGroupDataSetX coGroupDataSetX = dsxSum.coGroup(dsxPreData, (CoGroupFunction)new RecalcAndComplementCoGroupFunction(dsxSum.getRowMeta(), this.dataExecRecalculate.buildDataExecCalculate()));
        List<String> fields = syncModel.getAllDimensionFields();
        for (String field : fields) {
            if (Objects.equals(field, syncModel.getPeriodNumber())) continue;
            coGroupDataSetX.on(field, field);
        }
        return coGroupDataSetX;
    }
}

